/*
 * Decompiled with CFR 0.152.
 */
package android.net.netstats.provider;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkStatsProvider
extends IInterface {
    public void onRequestStatsUpdate(int var1) throws RemoteException;

    public void onSetLimit(String var1, long var2) throws RemoteException;

    public void onSetAlert(long var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkStatsProvider {
        private static final String DESCRIPTOR = "android.net.netstats.provider.INetworkStatsProvider";
        static final int TRANSACTION_onRequestStatsUpdate = 1;
        static final int TRANSACTION_onSetLimit = 2;
        static final int TRANSACTION_onSetAlert = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkStatsProvider asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INetworkStatsProvider) {
                return (INetworkStatsProvider)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onRequestStatsUpdate";
                }
                case 2: {
                    return "onSetLimit";
                }
                case 3: {
                    return "onSetAlert";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onRequestStatsUpdate(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    this.onSetLimit(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.onSetAlert(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(INetworkStatsProvider impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static INetworkStatsProvider getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements INetworkStatsProvider {
            private IBinder mRemote;
            public static INetworkStatsProvider sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestStatsUpdate(int token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(token);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRequestStatsUpdate(token);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetLimit(String iface, long quotaBytes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeLong(quotaBytes);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSetLimit(iface, quotaBytes);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetAlert(long quotaBytes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(quotaBytes);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSetAlert(quotaBytes);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkStatsProvider {
        @Override
        public void onRequestStatsUpdate(int token) throws RemoteException {
        }

        @Override
        public void onSetLimit(String iface, long quotaBytes) throws RemoteException {
        }

        @Override
        public void onSetAlert(long quotaBytes) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

