/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.net.RouteInfo;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Collection;

public class NetUtils {
    public static boolean addressTypeMatches(InetAddress left, InetAddress right) {
        return left instanceof Inet4Address && right instanceof Inet4Address || left instanceof Inet6Address && right instanceof Inet6Address;
    }

    public static RouteInfo selectBestRoute(Collection<RouteInfo> routes, InetAddress dest) {
        if (routes == null || dest == null) {
            return null;
        }
        RouteInfo bestRoute = null;
        for (RouteInfo route : routes) {
            if (!NetUtils.addressTypeMatches(route.getDestination().getAddress(), dest) || bestRoute != null && bestRoute.getDestination().getPrefixLength() >= route.getDestination().getPrefixLength() || !route.matches(dest)) continue;
            bestRoute = route;
        }
        return bestRoute;
    }
}

