/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class SoftApInfo
implements Parcelable {
    public static final int CHANNEL_WIDTH_INVALID = 0;
    public static final int CHANNEL_WIDTH_20MHZ_NOHT = 1;
    public static final int CHANNEL_WIDTH_20MHZ = 2;
    public static final int CHANNEL_WIDTH_40MHZ = 3;
    public static final int CHANNEL_WIDTH_80MHZ = 4;
    public static final int CHANNEL_WIDTH_80MHZ_PLUS_MHZ = 5;
    public static final int CHANNEL_WIDTH_160MHZ = 6;
    private int mFrequency = 0;
    private int mBandwidth = 0;
    public static final Parcelable.Creator<SoftApInfo> CREATOR = new Parcelable.Creator<SoftApInfo>(){

        @Override
        public SoftApInfo createFromParcel(Parcel in) {
            SoftApInfo info = new SoftApInfo();
            info.mFrequency = in.readInt();
            info.mBandwidth = in.readInt();
            return info;
        }

        public SoftApInfo[] newArray(int size) {
            return new SoftApInfo[size];
        }
    };

    public int getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(int freq) {
        this.mFrequency = freq;
    }

    public int getBandwidth() {
        return this.mBandwidth;
    }

    public void setBandwidth(int bandwidth) {
        this.mBandwidth = bandwidth;
    }

    public SoftApInfo(SoftApInfo source) {
        if (source != null) {
            this.mFrequency = source.mFrequency;
            this.mBandwidth = source.mBandwidth;
        }
    }

    public SoftApInfo() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mFrequency);
        dest.writeInt(this.mBandwidth);
    }

    public String toString() {
        return "SoftApInfo{bandwidth= " + this.mBandwidth + ",frequency= " + this.mFrequency + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftApInfo)) {
            return false;
        }
        SoftApInfo softApInfo = (SoftApInfo)o;
        return this.mFrequency == softApInfo.mFrequency && this.mBandwidth == softApInfo.mBandwidth;
    }

    public int hashCode() {
        return Objects.hash(this.mFrequency, this.mBandwidth);
    }
}

