/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.net.wifi.IWifiManager;
import android.net.wifi.IWifiScanner;
import android.net.wifi.RttManager;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiScanner;
import android.net.wifi.aware.IWifiAwareManager;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.net.wifi.rtt.IWifiRttManager;
import android.net.wifi.rtt.WifiRttManager;
import android.os.HandlerThread;
import android.os.Looper;

@SystemApi
public class WifiFrameworkInitializer {
    private static Looper getInstanceLooper() {
        return NoPreloadHolder.INSTANCE.getLooper();
    }

    private WifiFrameworkInitializer() {
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("wifi", WifiManager.class, (context, serviceBinder) -> {
            IWifiManager service = IWifiManager.Stub.asInterface(serviceBinder);
            return new WifiManager(context, service, WifiFrameworkInitializer.getInstanceLooper());
        });
        SystemServiceRegistry.registerStaticService("wifip2p", WifiP2pManager.class, serviceBinder -> {
            IWifiP2pManager service = IWifiP2pManager.Stub.asInterface(serviceBinder);
            return new WifiP2pManager(service);
        });
        SystemServiceRegistry.registerContextAwareService("wifiaware", WifiAwareManager.class, (context, serviceBinder) -> {
            IWifiAwareManager service = IWifiAwareManager.Stub.asInterface(serviceBinder);
            return new WifiAwareManager(context, service);
        });
        SystemServiceRegistry.registerContextAwareService("wifiscanner", WifiScanner.class, (context, serviceBinder) -> {
            IWifiScanner service = IWifiScanner.Stub.asInterface(serviceBinder);
            return new WifiScanner(context, service, WifiFrameworkInitializer.getInstanceLooper());
        });
        SystemServiceRegistry.registerContextAwareService("wifirtt", WifiRttManager.class, (context, serviceBinder) -> {
            IWifiRttManager service = IWifiRttManager.Stub.asInterface(serviceBinder);
            return new WifiRttManager(context, service);
        });
        SystemServiceRegistry.registerContextAwareService("rttmanager", RttManager.class, context -> {
            WifiRttManager wifiRttManager = context.getSystemService(WifiRttManager.class);
            return new RttManager(context, wifiRttManager);
        });
    }

    private static class NoPreloadHolder {
        private static final HandlerThread INSTANCE = NoPreloadHolder.createInstance();

        private NoPreloadHolder() {
        }

        private static HandlerThread createInstance() {
            HandlerThread thread = new HandlerThread("WifiManagerThread");
            thread.start();
            return thread;
        }
    }
}

