/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public class WifiP2pWfdInfo
implements Parcelable {
    private boolean mEnabled;
    private int mDeviceInfo;
    public static final int DEVICE_TYPE_WFD_SOURCE = 0;
    public static final int DEVICE_TYPE_PRIMARY_SINK = 1;
    public static final int DEVICE_TYPE_SECONDARY_SINK = 2;
    public static final int DEVICE_TYPE_SOURCE_OR_PRIMARY_SINK = 3;
    private static final int DEVICE_TYPE = 3;
    private static final int COUPLED_SINK_SUPPORT_AT_SOURCE = 4;
    private static final int COUPLED_SINK_SUPPORT_AT_SINK = 8;
    private static final int SESSION_AVAILABLE_BIT1 = 16;
    private static final int SESSION_AVAILABLE_BIT2 = 32;
    private static final int SESSION_AVAILABLE = 48;
    private static final int CONTENT_PROTECTION_SUPPORT = 256;
    private int mCtrlPort;
    private int mMaxThroughput;
    public static final Parcelable.Creator<WifiP2pWfdInfo> CREATOR = new Parcelable.Creator<WifiP2pWfdInfo>(){

        @Override
        public WifiP2pWfdInfo createFromParcel(Parcel in) {
            WifiP2pWfdInfo device = new WifiP2pWfdInfo();
            device.readFromParcel(in);
            return device;
        }

        public WifiP2pWfdInfo[] newArray(int size) {
            return new WifiP2pWfdInfo[size];
        }
    };

    public WifiP2pWfdInfo() {
    }

    @UnsupportedAppUsage
    public WifiP2pWfdInfo(int devInfo, int ctrlPort, int maxTput) {
        this.mEnabled = true;
        this.mDeviceInfo = devInfo;
        this.mCtrlPort = ctrlPort;
        this.mMaxThroughput = maxTput;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public int getDeviceType() {
        return this.mDeviceInfo & 3;
    }

    public boolean setDeviceType(int deviceType) {
        if (0 <= deviceType && deviceType <= 3) {
            this.mDeviceInfo &= 0xFFFFFFFC;
            this.mDeviceInfo |= deviceType;
            return true;
        }
        return false;
    }

    public boolean isSessionAvailable() {
        return (this.mDeviceInfo & 0x30) != 0;
    }

    public void setSessionAvailable(boolean enabled) {
        if (enabled) {
            this.mDeviceInfo |= 0x10;
            this.mDeviceInfo &= 0xFFFFFFDF;
        } else {
            this.mDeviceInfo &= 0xFFFFFFCF;
        }
    }

    public boolean isContentProtectionSupported() {
        return (this.mDeviceInfo & 0x100) != 0;
    }

    public void setContentProtectionSupported(boolean enabled) {
        this.mDeviceInfo = enabled ? (this.mDeviceInfo |= 0x100) : (this.mDeviceInfo &= 0xFFFFFEFF);
    }

    public int getControlPort() {
        return this.mCtrlPort;
    }

    public void setControlPort(int port) {
        this.mCtrlPort = port;
    }

    public void setMaxThroughput(int maxThroughput) {
        this.mMaxThroughput = maxThroughput;
    }

    public int getMaxThroughput() {
        return this.mMaxThroughput;
    }

    public String getDeviceInfoHex() {
        return String.format(Locale.US, "%04x%04x%04x", this.mDeviceInfo, this.mCtrlPort, this.mMaxThroughput);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("WFD enabled: ").append(this.mEnabled);
        sbuf.append("WFD DeviceInfo: ").append(this.mDeviceInfo);
        sbuf.append("\n WFD CtrlPort: ").append(this.mCtrlPort);
        sbuf.append("\n WFD MaxThroughput: ").append(this.mMaxThroughput);
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public WifiP2pWfdInfo(WifiP2pWfdInfo source) {
        if (source != null) {
            this.mEnabled = source.mEnabled;
            this.mDeviceInfo = source.mDeviceInfo;
            this.mCtrlPort = source.mCtrlPort;
            this.mMaxThroughput = source.mMaxThroughput;
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mEnabled ? 1 : 0);
        dest.writeInt(this.mDeviceInfo);
        dest.writeInt(this.mCtrlPort);
        dest.writeInt(this.mMaxThroughput);
    }

    private void readFromParcel(Parcel in) {
        this.mEnabled = in.readInt() == 1;
        this.mDeviceInfo = in.readInt();
        this.mCtrlPort = in.readInt();
        this.mMaxThroughput = in.readInt();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceType {
    }
}

