/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.SystemApi;
import android.content.Context;
import android.net.wifi.rtt.IRttCallback;
import android.net.wifi.rtt.IWifiRttManager;
import android.net.wifi.rtt.RangingRequest;
import android.net.wifi.rtt.RangingResult;
import android.net.wifi.rtt.RangingResultCallback;
import android.os.Binder;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.List;
import java.util.concurrent.Executor;

public class WifiRttManager {
    private static final String TAG = "WifiRttManager";
    private static final boolean VDBG = false;
    private final Context mContext;
    private final IWifiRttManager mService;
    public static final String ACTION_WIFI_RTT_STATE_CHANGED = "android.net.wifi.rtt.action.WIFI_RTT_STATE_CHANGED";

    public WifiRttManager(Context context, IWifiRttManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public boolean isAvailable() {
        try {
            return this.mService.isAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void startRanging(RangingRequest request, Executor executor, RangingResultCallback callback) {
        this.startRanging(null, request, executor, callback);
    }

    @SystemApi
    public void startRanging(WorkSource workSource, RangingRequest request, final Executor executor, final RangingResultCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("Null executor provided");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Null callback provided");
        }
        Binder binder = new Binder();
        try {
            this.mService.startRanging(binder, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), workSource, request, new IRttCallback.Stub(){

                @Override
                public void onRangingFailure(int status) throws RemoteException {
                    1.clearCallingIdentity();
                    executor.execute(() -> callback.onRangingFailure(status));
                }

                @Override
                public void onRangingResults(List<RangingResult> results) throws RemoteException {
                    1.clearCallingIdentity();
                    executor.execute(() -> callback.onRangingResults(results));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void cancelRanging(WorkSource workSource) {
        try {
            this.mService.cancelRanging(workSource);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

