/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.os.RemoteException;
import android.os.WorkSource;
import android.os.connectivity.CellularBatteryStats;
import android.os.connectivity.WifiBatteryStats;
import com.android.internal.app.IBatteryStats;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class BatteryStatsManager {
    public static final int WIFI_STATE_OFF = 0;
    public static final int WIFI_STATE_OFF_SCANNING = 1;
    public static final int WIFI_STATE_ON_NO_NETWORKS = 2;
    public static final int WIFI_STATE_ON_DISCONNECTED = 3;
    public static final int WIFI_STATE_ON_CONNECTED_STA = 4;
    public static final int WIFI_STATE_ON_CONNECTED_P2P = 5;
    public static final int WIFI_STATE_ON_CONNECTED_STA_P2P = 6;
    public static final int WIFI_STATE_SOFT_AP = 7;
    public static final int NUM_WIFI_STATES = 8;
    public static final int WIFI_SUPPL_STATE_INVALID = 0;
    public static final int WIFI_SUPPL_STATE_DISCONNECTED = 1;
    public static final int WIFI_SUPPL_STATE_INTERFACE_DISABLED = 2;
    public static final int WIFI_SUPPL_STATE_INACTIVE = 3;
    public static final int WIFI_SUPPL_STATE_SCANNING = 4;
    public static final int WIFI_SUPPL_STATE_AUTHENTICATING = 5;
    public static final int WIFI_SUPPL_STATE_ASSOCIATING = 6;
    public static final int WIFI_SUPPL_STATE_ASSOCIATED = 7;
    public static final int WIFI_SUPPL_STATE_FOUR_WAY_HANDSHAKE = 8;
    public static final int WIFI_SUPPL_STATE_GROUP_HANDSHAKE = 9;
    public static final int WIFI_SUPPL_STATE_COMPLETED = 10;
    public static final int WIFI_SUPPL_STATE_DORMANT = 11;
    public static final int WIFI_SUPPL_STATE_UNINITIALIZED = 12;
    public static final int NUM_WIFI_SUPPL_STATES = 13;
    private final IBatteryStats mBatteryStats;

    public BatteryStatsManager(IBatteryStats batteryStats) {
        this.mBatteryStats = batteryStats;
    }

    public void reportWifiRssiChanged(int newRssi) {
        try {
            this.mBatteryStats.noteWifiRssiChanged(newRssi);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void reportWifiOn() {
        try {
            this.mBatteryStats.noteWifiOn();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void reportWifiOff() {
        try {
            this.mBatteryStats.noteWifiOff();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void reportWifiState(int newWifiState, String accessPoint) {
        try {
            this.mBatteryStats.noteWifiState(newWifiState, accessPoint);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void reportWifiScanStartedFromSource(WorkSource ws) {
        try {
            this.mBatteryStats.noteWifiScanStartedFromSource(ws);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void reportWifiScanStoppedFromSource(WorkSource ws) {
        try {
            this.mBatteryStats.noteWifiScanStoppedFromSource(ws);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void reportWifiBatchedScanStartedFromSource(WorkSource ws, int csph) {
        try {
            this.mBatteryStats.noteWifiBatchedScanStartedFromSource(ws, csph);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void reportWifiBatchedScanStoppedFromSource(WorkSource ws) {
        try {
            this.mBatteryStats.noteWifiBatchedScanStoppedFromSource(ws);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public CellularBatteryStats getCellularBatteryStats() {
        try {
            return this.mBatteryStats.getCellularBatteryStats();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public WifiBatteryStats getWifiBatteryStats() {
        try {
            return this.mBatteryStats.getWifiBatteryStats();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public void reportFullWifiLockAcquiredFromSource(WorkSource ws) {
        try {
            this.mBatteryStats.noteFullWifiLockAcquiredFromSource(ws);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void reportFullWifiLockReleasedFromSource(WorkSource ws) {
        try {
            this.mBatteryStats.noteFullWifiLockReleasedFromSource(ws);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void reportWifiSupplicantStateChanged(int newSupplState, boolean failedAuth) {
        try {
            this.mBatteryStats.noteWifiSupplicantStateChanged(newSupplState, failedAuth);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void reportWifiMulticastEnabled(WorkSource ws) {
        try {
            this.mBatteryStats.noteWifiMulticastEnabled(ws.getAttributionUid());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void reportWifiMulticastDisabled(WorkSource ws) {
        try {
            this.mBatteryStats.noteWifiMulticastDisabled(ws.getAttributionUid());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiSupplState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiState {
    }
}

