/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SuppressLint;
import android.os.HidlMemory;
import android.os.NativeHandle;
import android.os.SharedMemory;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class HidlMemoryUtil {
    private static final String TAG = "HidlMemoryUtil";

    private HidlMemoryUtil() {
    }

    public static HidlMemory byteArrayToHidlMemory(byte[] input) {
        return HidlMemoryUtil.byteArrayToHidlMemory(input, null);
    }

    public static HidlMemory byteArrayToHidlMemory(byte[] input, String name) {
        Preconditions.checkNotNull(input);
        if (input.length == 0) {
            return new HidlMemory("ashmem", 0L, null);
        }
        try {
            SharedMemory shmem = SharedMemory.create(name != null ? name : "", input.length);
            ByteBuffer buffer = shmem.mapReadWrite();
            buffer.put(input);
            SharedMemory.unmap(buffer);
            return HidlMemoryUtil.sharedMemoryToHidlMemory(shmem);
        }
        catch (ErrnoException e) {
            throw new RuntimeException(e);
        }
    }

    public static HidlMemory byteListToHidlMemory(List<Byte> input) {
        return HidlMemoryUtil.byteListToHidlMemory(input, null);
    }

    public static HidlMemory byteListToHidlMemory(List<Byte> input, String name) {
        Preconditions.checkNotNull(input);
        if (input.isEmpty()) {
            return new HidlMemory("ashmem", 0L, null);
        }
        try {
            SharedMemory shmem = SharedMemory.create(name != null ? name : "", input.size());
            ByteBuffer buffer = shmem.mapReadWrite();
            for (Byte b : input) {
                buffer.put(b);
            }
            SharedMemory.unmap(buffer);
            return HidlMemoryUtil.sharedMemoryToHidlMemory(shmem);
        }
        catch (ErrnoException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] hidlMemoryToByteArray(HidlMemory mem) {
        Preconditions.checkNotNull(mem);
        Preconditions.checkArgumentInRange(mem.getSize(), 0L, Integer.MAX_VALUE, "Memory size");
        Preconditions.checkArgument(mem.getSize() == 0L || mem.getName().equals("ashmem"), "Unsupported memory type: %s", mem.getName());
        if (mem.getSize() == 0L) {
            return new byte[0];
        }
        ByteBuffer buffer = HidlMemoryUtil.getBuffer(mem);
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    @SuppressLint(value={"ConcreteCollection"})
    public static ArrayList<Byte> hidlMemoryToByteList(HidlMemory mem) {
        Preconditions.checkNotNull(mem);
        Preconditions.checkArgumentInRange(mem.getSize(), 0L, Integer.MAX_VALUE, "Memory size");
        Preconditions.checkArgument(mem.getSize() == 0L || mem.getName().equals("ashmem"), "Unsupported memory type: %s", mem.getName());
        if (mem.getSize() == 0L) {
            return new ArrayList<Byte>();
        }
        ByteBuffer buffer = HidlMemoryUtil.getBuffer(mem);
        ArrayList<Byte> result = new ArrayList<Byte>(buffer.remaining());
        while (buffer.hasRemaining()) {
            result.add(buffer.get());
        }
        return result;
    }

    public static HidlMemory sharedMemoryToHidlMemory(SharedMemory shmem) {
        if (shmem == null) {
            return new HidlMemory("ashmem", 0L, null);
        }
        return HidlMemoryUtil.fileDescriptorToHidlMemory(shmem.getFileDescriptor(), shmem.getSize());
    }

    public static HidlMemory fileDescriptorToHidlMemory(FileDescriptor fd, int size) {
        Preconditions.checkArgument(fd != null || size == 0);
        if (fd == null) {
            return new HidlMemory("ashmem", 0L, null);
        }
        NativeHandle handle = new NativeHandle(fd, true);
        return new HidlMemory("ashmem", size, handle);
    }

    private static ByteBuffer getBuffer(HidlMemory mem) {
        try {
            int size = (int)mem.getSize();
            if (size == 0) {
                return ByteBuffer.wrap(new byte[0]);
            }
            NativeHandle handle = mem.getHandle();
            long address = Os.mmap(0L, size, OsConstants.PROT_READ, OsConstants.MAP_SHARED, handle.getFileDescriptor(), 0L);
            return new DirectByteBuffer(size, address, handle.getFileDescriptor(), () -> {
                try {
                    Os.munmap(address, size);
                }
                catch (ErrnoException e) {
                    Log.wtf(TAG, e);
                }
            }, true);
        }
        catch (ErrnoException e) {
            throw new RuntimeException(e);
        }
    }
}

