/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.StatsDimensionsValueParcel;

public interface IPendingIntentRef
extends IInterface {
    public void sendDataBroadcast(long var1) throws RemoteException;

    public void sendActiveConfigsChangedBroadcast(long[] var1) throws RemoteException;

    public void sendSubscriberBroadcast(long var1, long var3, long var5, long var7, String[] var9, StatsDimensionsValueParcel var10) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPendingIntentRef {
        private static final String DESCRIPTOR = "android.os.IPendingIntentRef";
        static final int TRANSACTION_sendDataBroadcast = 1;
        static final int TRANSACTION_sendActiveConfigsChangedBroadcast = 2;
        static final int TRANSACTION_sendSubscriberBroadcast = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPendingIntentRef asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPendingIntentRef) {
                return (IPendingIntentRef)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "sendDataBroadcast";
                }
                case 2: {
                    return "sendActiveConfigsChangedBroadcast";
                }
                case 3: {
                    return "sendSubscriberBroadcast";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.sendDataBroadcast(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    long[] _arg0 = data.createLongArray();
                    this.sendActiveConfigsChangedBroadcast(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    long _arg3 = data.readLong();
                    String[] _arg4 = data.createStringArray();
                    StatsDimensionsValueParcel _arg5 = 0 != data.readInt() ? StatsDimensionsValueParcel.CREATOR.createFromParcel(data) : null;
                    this.sendSubscriberBroadcast(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IPendingIntentRef impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IPendingIntentRef getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IPendingIntentRef {
            private IBinder mRemote;
            public static IPendingIntentRef sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendDataBroadcast(long lastReportTimeNs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(lastReportTimeNs);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendDataBroadcast(lastReportTimeNs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendActiveConfigsChangedBroadcast(long[] configIds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLongArray(configIds);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendActiveConfigsChangedBroadcast(configIds);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSubscriberBroadcast(long configUid, long configId, long subscriptionId, long subscriptionRuleId, String[] cookies, StatsDimensionsValueParcel dimensionsValueParcel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(configUid);
                    _data.writeLong(configId);
                    _data.writeLong(subscriptionId);
                    _data.writeLong(subscriptionRuleId);
                    _data.writeStringArray(cookies);
                    if (dimensionsValueParcel != null) {
                        _data.writeInt(1);
                        dimensionsValueParcel.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendSubscriberBroadcast(configUid, configId, subscriptionId, subscriptionRuleId, cookies, dimensionsValueParcel);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPendingIntentRef {
        @Override
        public void sendDataBroadcast(long lastReportTimeNs) throws RemoteException {
        }

        @Override
        public void sendActiveConfigsChangedBroadcast(long[] configIds) throws RemoteException {
        }

        @Override
        public void sendSubscriberBroadcast(long configUid, long configId, long subscriptionId, long subscriptionRuleId, String[] cookies, StatsDimensionsValueParcel dimensionsValueParcel) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

