/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.BasicShellCommandHandler;
import android.os.Binder;
import android.os.ParcelFileDescriptor;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import java.io.FileDescriptor;

public abstract class ShellCommand
extends BasicShellCommandHandler {
    private ShellCallback mShellCallback;
    private ResultReceiver mResultReceiver;

    public int exec(Binder target, FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        this.mShellCallback = callback;
        this.mResultReceiver = resultReceiver;
        int result = super.exec(target, in, out, err, args);
        if (this.mResultReceiver != null) {
            this.mResultReceiver.send(result, null);
        }
        return result;
    }

    public ResultReceiver adoptResultReceiver() {
        ResultReceiver rr = this.mResultReceiver;
        this.mResultReceiver = null;
        return rr;
    }

    public ParcelFileDescriptor openFileForSystem(String path, String mode) {
        try {
            ParcelFileDescriptor pfd = this.getShellCallback().openFile(path, "u:r:system_server:s0", mode);
            if (pfd != null) {
                return pfd;
            }
        }
        catch (RuntimeException e) {
            this.getErrPrintWriter().println("Failure opening file: " + e.getMessage());
        }
        this.getErrPrintWriter().println("Error: Unable to open file: " + path);
        String suggestedPath = "/data/local/tmp/";
        if (path == null || !path.startsWith(suggestedPath)) {
            this.getErrPrintWriter().println("Consider using a file under " + suggestedPath);
        }
        return null;
    }

    @Override
    public int handleDefaultCommands(String cmd) {
        if ("dump".equals(cmd)) {
            String[] newArgs = new String[this.getAllArgs().length - 1];
            System.arraycopy(this.getAllArgs(), 1, newArgs, 0, this.getAllArgs().length - 1);
            this.getTarget().doDump(this.getOutFileDescriptor(), this.getOutPrintWriter(), newArgs);
            return 0;
        }
        return super.handleDefaultCommands(cmd);
    }

    @Override
    @UnsupportedAppUsage
    public String peekNextArg() {
        return super.peekNextArg();
    }

    public ShellCallback getShellCallback() {
        return this.mShellCallback;
    }
}

