/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.ContextImpl;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.media.AudioAttributes;
import android.os.Process;
import android.os.VibrationEffect;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.concurrent.Executor;

public abstract class Vibrator {
    private static final String TAG = "Vibrator";
    public static final int VIBRATION_INTENSITY_OFF = 0;
    public static final int VIBRATION_INTENSITY_LOW = 1;
    public static final int VIBRATION_INTENSITY_MEDIUM = 2;
    public static final int VIBRATION_INTENSITY_HIGH = 3;
    public static final int VIBRATION_EFFECT_SUPPORT_UNKNOWN = 0;
    public static final int VIBRATION_EFFECT_SUPPORT_YES = 1;
    public static final int VIBRATION_EFFECT_SUPPORT_NO = 2;
    private final String mPackageName;
    private int mDefaultHapticFeedbackIntensity;
    private int mDefaultNotificationVibrationIntensity;
    private int mDefaultRingVibrationIntensity;

    @UnsupportedAppUsage
    public Vibrator() {
        this.mPackageName = ActivityThread.currentPackageName();
        ContextImpl ctx = ActivityThread.currentActivityThread().getSystemContext();
        this.loadVibrationIntensities(ctx);
    }

    protected Vibrator(Context context) {
        this.mPackageName = context.getOpPackageName();
        this.loadVibrationIntensities(context);
    }

    private void loadVibrationIntensities(Context context) {
        this.mDefaultHapticFeedbackIntensity = this.loadDefaultIntensity(context, 17694773);
        this.mDefaultNotificationVibrationIntensity = this.loadDefaultIntensity(context, 17694780);
        this.mDefaultRingVibrationIntensity = this.loadDefaultIntensity(context, 17694785);
    }

    private int loadDefaultIntensity(Context ctx, int resId) {
        return ctx != null ? ctx.getResources().getInteger(resId) : 2;
    }

    public int getDefaultHapticFeedbackIntensity() {
        return this.mDefaultHapticFeedbackIntensity;
    }

    public int getDefaultNotificationVibrationIntensity() {
        return this.mDefaultNotificationVibrationIntensity;
    }

    public int getDefaultRingVibrationIntensity() {
        return this.mDefaultRingVibrationIntensity;
    }

    public abstract boolean hasVibrator();

    public abstract boolean hasAmplitudeControl();

    public boolean setAlwaysOnEffect(int alwaysOnId, VibrationEffect effect, AudioAttributes attributes) {
        return this.setAlwaysOnEffect(Process.myUid(), this.mPackageName, alwaysOnId, effect, attributes);
    }

    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, VibrationEffect effect, AudioAttributes attributes) {
        Log.w(TAG, "Always-on effects aren't supported");
        return false;
    }

    @Deprecated
    public void vibrate(long milliseconds) {
        this.vibrate(milliseconds, null);
    }

    @Deprecated
    public void vibrate(long milliseconds, AudioAttributes attributes) {
        try {
            VibrationEffect effect = VibrationEffect.createOneShot(milliseconds, -1);
            this.vibrate(effect, attributes);
        }
        catch (IllegalArgumentException iae) {
            Log.e(TAG, "Failed to create VibrationEffect", iae);
        }
    }

    @Deprecated
    public void vibrate(long[] pattern, int repeat) {
        this.vibrate(pattern, repeat, null);
    }

    @Deprecated
    public void vibrate(long[] pattern, int repeat, AudioAttributes attributes) {
        if (repeat < -1 || repeat >= pattern.length) {
            Log.e(TAG, "vibrate called with repeat index out of bounds (pattern.length=" + pattern.length + ", index=" + repeat + ")");
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            this.vibrate(VibrationEffect.createWaveform(pattern, repeat), attributes);
        }
        catch (IllegalArgumentException iae) {
            Log.e(TAG, "Failed to create VibrationEffect", iae);
        }
    }

    public void vibrate(VibrationEffect vibe) {
        this.vibrate(vibe, null);
    }

    public void vibrate(VibrationEffect vibe, AudioAttributes attributes) {
        this.vibrate(Process.myUid(), this.mPackageName, vibe, null, attributes);
    }

    public abstract void vibrate(int var1, String var2, VibrationEffect var3, String var4, AudioAttributes var5);

    public int[] areEffectsSupported(int ... effectIds) {
        int[] support = new int[effectIds.length];
        Arrays.fill(support, 2);
        return support;
    }

    public int areAllEffectsSupported(int ... effectIds) {
        int support = 1;
        for (int supported : this.areEffectsSupported(effectIds)) {
            if (supported == 2) {
                return 2;
            }
            if (supported != 0) continue;
            support = 0;
        }
        return support;
    }

    public boolean[] arePrimitivesSupported(int ... primitiveIds) {
        return new boolean[primitiveIds.length];
    }

    public boolean areAllPrimitivesSupported(int ... primitiveIds) {
        for (boolean supported : this.arePrimitivesSupported(primitiveIds)) {
            if (supported) continue;
            return false;
        }
        return true;
    }

    public abstract void cancel();

    @SystemApi
    public boolean isVibrating() {
        return false;
    }

    @SystemApi
    public void addVibratorStateListener(OnVibratorStateChangedListener listener) {
    }

    @SystemApi
    public void addVibratorStateListener(Executor executor, OnVibratorStateChangedListener listener) {
    }

    @SystemApi
    public void removeVibratorStateListener(OnVibratorStateChangedListener listener) {
    }

    @SystemApi
    public static interface OnVibratorStateChangedListener {
        public void onVibratorStateChanged(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VibrationIntensity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VibrationEffectSupport {
    }
}

