/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.pm.ApplicationInfo;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.ChildZygoteProcess;
import android.os.Parcel;
import android.os.Process;
import android.os.SystemClock;
import android.os.ZygoteStartFailedEx;
import android.os._Original_Build;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.Zygote;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ZygoteProcess {
    private static final int ZYGOTE_CONNECT_TIMEOUT_MS = 20000;
    private static final int ZYGOTE_CONNECT_RETRY_DELAY_MS = 50;
    private static final String LOG_TAG = "ZygoteProcess";
    private static final String USAP_POOL_ENABLED_DEFAULT = "false";
    private final LocalSocketAddress mZygoteSocketAddress;
    private final LocalSocketAddress mZygoteSecondarySocketAddress;
    private final LocalSocketAddress mUsapPoolSocketAddress;
    private final LocalSocketAddress mUsapPoolSecondarySocketAddress;
    private final Object mLock = new Object();
    private List<String> mApiBlacklistExemptions = Collections.emptyList();
    private int mHiddenApiAccessLogSampleRate;
    private int mHiddenApiAccessStatslogSampleRate;
    private ZygoteState primaryZygoteState;
    private ZygoteState secondaryZygoteState;
    private final boolean mUsapPoolSupported;
    private boolean mUsapPoolEnabled = false;
    static final int ZYGOTE_RETRY_MILLIS = 500;
    private static final String[] INVALID_USAP_FLAGS = new String[]{"--query-abi-list", "--get-pid", "--preload-default", "--preload-package", "--preload-app", "--start-child-zygote", "--set-api-blacklist-exemptions", "--hidden-api-log-sampling-rate", "--hidden-api-statslog-sampling-rate", "--invoke-with"};
    private boolean mIsFirstPropCheck = true;
    private long mLastPropCheckTimestamp = 0L;

    public ZygoteProcess() {
        this.mZygoteSocketAddress = new LocalSocketAddress("zygote", LocalSocketAddress.Namespace.RESERVED);
        this.mZygoteSecondarySocketAddress = new LocalSocketAddress("zygote_secondary", LocalSocketAddress.Namespace.RESERVED);
        this.mUsapPoolSocketAddress = new LocalSocketAddress("usap_pool_primary", LocalSocketAddress.Namespace.RESERVED);
        this.mUsapPoolSecondarySocketAddress = new LocalSocketAddress("usap_pool_secondary", LocalSocketAddress.Namespace.RESERVED);
        this.mUsapPoolSupported = true;
    }

    public ZygoteProcess(LocalSocketAddress primarySocketAddress, LocalSocketAddress secondarySocketAddress) {
        this.mZygoteSocketAddress = primarySocketAddress;
        this.mZygoteSecondarySocketAddress = secondarySocketAddress;
        this.mUsapPoolSocketAddress = null;
        this.mUsapPoolSecondarySocketAddress = null;
        this.mUsapPoolSupported = false;
    }

    public LocalSocketAddress getPrimarySocketAddress() {
        return this.mZygoteSocketAddress;
    }

    public Process.ProcessStartResult start(String processClass, String niceName, int uid, int gid, int[] gids, int runtimeFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String invokeWith, String packageName, int zygotePolicyFlags, boolean isTopApp, long[] disabledCompatChanges, Map<String, Pair<String, Long>> pkgDataInfoMap, Map<String, Pair<String, Long>> whitelistedDataInfoMap, boolean bindMountAppsData, boolean bindMountAppStorageDirs, String[] zygoteArgs) {
        if (this.fetchUsapPoolEnabledPropWithMinInterval()) {
            this.informZygotesOfUsapPoolStatus();
        }
        try {
            return this.startViaZygote(processClass, niceName, uid, gid, gids, runtimeFlags, mountExternal, targetSdkVersion, seInfo, abi, instructionSet, appDataDir, invokeWith, false, packageName, zygotePolicyFlags, isTopApp, disabledCompatChanges, pkgDataInfoMap, whitelistedDataInfoMap, bindMountAppsData, bindMountAppStorageDirs, zygoteArgs);
        }
        catch (ZygoteStartFailedEx ex) {
            Log.e(LOG_TAG, "Starting VM process through Zygote failed");
            throw new RuntimeException("Starting VM process through Zygote failed", ex);
        }
    }

    @GuardedBy(value={"mLock"})
    private static List<String> getAbiList(BufferedWriter writer, DataInputStream inputStream) throws IOException {
        writer.write("1");
        writer.newLine();
        writer.write("--query-abi-list");
        writer.newLine();
        writer.flush();
        int numBytes = inputStream.readInt();
        byte[] bytes = new byte[numBytes];
        inputStream.readFully(bytes);
        String rawList = new String(bytes, StandardCharsets.US_ASCII);
        return Arrays.asList(rawList.split(","));
    }

    @GuardedBy(value={"mLock"})
    private Process.ProcessStartResult zygoteSendArgsAndGetResult(ZygoteState zygoteState, int zygotePolicyFlags, ArrayList<String> args) throws ZygoteStartFailedEx {
        for (String arg : args) {
            if (arg.indexOf(10) >= 0) {
                throw new ZygoteStartFailedEx("Embedded newlines not allowed");
            }
            if (arg.indexOf(13) < 0) continue;
            throw new ZygoteStartFailedEx("Embedded carriage returns not allowed");
        }
        String msgStr = args.size() + "\n" + String.join((CharSequence)"\n", args) + "\n";
        if (this.shouldAttemptUsapLaunch(zygotePolicyFlags, args)) {
            try {
                return this.attemptUsapSendArgsAndGetResult(zygoteState, msgStr);
            }
            catch (IOException ex) {
                Log.e(LOG_TAG, "IO Exception while communicating with USAP pool - " + ex.getMessage());
            }
        }
        return this.attemptZygoteSendArgsAndGetResult(zygoteState, msgStr);
    }

    private Process.ProcessStartResult attemptZygoteSendArgsAndGetResult(ZygoteState zygoteState, String msgStr) throws ZygoteStartFailedEx {
        try {
            BufferedWriter zygoteWriter = zygoteState.mZygoteOutputWriter;
            DataInputStream zygoteInputStream = zygoteState.mZygoteInputStream;
            zygoteWriter.write(msgStr);
            zygoteWriter.flush();
            Process.ProcessStartResult result = new Process.ProcessStartResult();
            result.pid = zygoteInputStream.readInt();
            result.usingWrapper = zygoteInputStream.readBoolean();
            if (result.pid < 0) {
                throw new ZygoteStartFailedEx("fork() failed");
            }
            return result;
        }
        catch (IOException ex) {
            zygoteState.close();
            Log.e(LOG_TAG, "IO Exception while communicating with Zygote - " + ex.toString());
            throw new ZygoteStartFailedEx(ex);
        }
    }

    private Process.ProcessStartResult attemptUsapSendArgsAndGetResult(ZygoteState zygoteState, String msgStr) throws ZygoteStartFailedEx, IOException {
        try (LocalSocket usapSessionSocket = zygoteState.getUsapSessionSocket();){
            BufferedWriter usapWriter = new BufferedWriter(new OutputStreamWriter(usapSessionSocket.getOutputStream()), 256);
            DataInputStream usapReader = new DataInputStream(usapSessionSocket.getInputStream());
            usapWriter.write(msgStr);
            usapWriter.flush();
            Process.ProcessStartResult result = new Process.ProcessStartResult();
            result.pid = usapReader.readInt();
            result.usingWrapper = false;
            if (result.pid >= 0) {
                Process.ProcessStartResult processStartResult = result;
                return processStartResult;
            }
            throw new ZygoteStartFailedEx("USAP specialization failed");
        }
    }

    private boolean shouldAttemptUsapLaunch(int zygotePolicyFlags, ArrayList<String> args) {
        return this.mUsapPoolSupported && this.mUsapPoolEnabled && ZygoteProcess.policySpecifiesUsapPoolLaunch(zygotePolicyFlags) && ZygoteProcess.commandSupportedByUsap(args);
    }

    private static boolean policySpecifiesUsapPoolLaunch(int zygotePolicyFlags) {
        return (zygotePolicyFlags & 5) == 1;
    }

    private static boolean commandSupportedByUsap(ArrayList<String> args) {
        for (String flag : args) {
            for (String badFlag : INVALID_USAP_FLAGS) {
                if (!flag.startsWith(badFlag)) continue;
                return false;
            }
            if (!flag.startsWith("--nice-name=") || Zygote.getWrapProperty(flag.substring(12)) == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process.ProcessStartResult startViaZygote(String processClass, String niceName, int uid, int gid, int[] gids, int runtimeFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String invokeWith, boolean startChildZygote, String packageName, int zygotePolicyFlags, boolean isTopApp, long[] disabledCompatChanges, Map<String, Pair<String, Long>> pkgDataInfoMap, Map<String, Pair<String, Long>> whitelistedDataInfoMap, boolean bindMountAppsData, boolean bindMountAppStorageDirs, String[] extraArgs) throws ZygoteStartFailedEx {
        boolean started;
        int i;
        int sz;
        StringBuilder sb;
        ArrayList<String> argsForZygote = new ArrayList<String>();
        argsForZygote.add("--runtime-args");
        argsForZygote.add("--setuid=" + uid);
        argsForZygote.add("--setgid=" + gid);
        argsForZygote.add("--runtime-flags=" + runtimeFlags);
        if (mountExternal == 1) {
            argsForZygote.add("--mount-external-default");
        } else if (mountExternal == 2) {
            argsForZygote.add("--mount-external-read");
        } else if (mountExternal == 3) {
            argsForZygote.add("--mount-external-write");
        } else if (mountExternal == 6) {
            argsForZygote.add("--mount-external-full");
        } else if (mountExternal == 5) {
            argsForZygote.add("--mount-external-installer");
        } else if (mountExternal == 4) {
            argsForZygote.add("--mount-external-legacy");
        } else if (mountExternal == 7) {
            argsForZygote.add("--mount-external-pass-through");
        } else if (mountExternal == 8) {
            argsForZygote.add("--mount-external-android-writable");
        }
        argsForZygote.add("--target-sdk-version=" + targetSdkVersion);
        if (gids != null && gids.length > 0) {
            sb = new StringBuilder();
            sb.append("--setgroups=");
            sz = gids.length;
            for (i = 0; i < sz; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(gids[i]);
            }
            argsForZygote.add(sb.toString());
        }
        if (niceName != null) {
            argsForZygote.add("--nice-name=" + niceName);
        }
        if (seInfo != null) {
            argsForZygote.add("--seinfo=" + seInfo);
        }
        if (instructionSet != null) {
            argsForZygote.add("--instruction-set=" + instructionSet);
        }
        if (appDataDir != null) {
            argsForZygote.add("--app-data-dir=" + appDataDir);
        }
        if (invokeWith != null) {
            argsForZygote.add("--invoke-with");
            argsForZygote.add(invokeWith);
        }
        if (startChildZygote) {
            argsForZygote.add("--start-child-zygote");
        }
        if (packageName != null) {
            argsForZygote.add("--package-name=" + packageName);
        }
        if (isTopApp) {
            argsForZygote.add("--is-top-app");
        }
        if (pkgDataInfoMap != null && pkgDataInfoMap.size() > 0) {
            sb = new StringBuilder();
            sb.append("--pkg-data-info-map");
            sb.append("=");
            started = false;
            for (Map.Entry<String, Pair<String, Long>> entry : pkgDataInfoMap.entrySet()) {
                if (started) {
                    sb.append(',');
                }
                started = true;
                sb.append(entry.getKey());
                sb.append(',');
                sb.append((String)entry.getValue().first);
                sb.append(',');
                sb.append(entry.getValue().second);
            }
            argsForZygote.add(sb.toString());
        }
        if (whitelistedDataInfoMap != null && whitelistedDataInfoMap.size() > 0) {
            sb = new StringBuilder();
            sb.append("--whitelisted-data-info-map");
            sb.append("=");
            started = false;
            for (Map.Entry<String, Pair<String, Long>> entry : whitelistedDataInfoMap.entrySet()) {
                if (started) {
                    sb.append(',');
                }
                started = true;
                sb.append(entry.getKey());
                sb.append(',');
                sb.append((String)entry.getValue().first);
                sb.append(',');
                sb.append(entry.getValue().second);
            }
            argsForZygote.add(sb.toString());
        }
        if (bindMountAppStorageDirs) {
            argsForZygote.add("--bind-mount-storage-dirs");
        }
        if (bindMountAppsData) {
            argsForZygote.add("--bind-mount-data-dirs");
        }
        if (disabledCompatChanges != null && disabledCompatChanges.length > 0) {
            sb = new StringBuilder();
            sb.append("--disabled-compat-changes=");
            sz = disabledCompatChanges.length;
            for (i = 0; i < sz; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(disabledCompatChanges[i]);
            }
            argsForZygote.add(sb.toString());
        }
        argsForZygote.add(processClass);
        if (extraArgs != null) {
            Collections.addAll(argsForZygote, extraArgs);
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.zygoteSendArgsAndGetResult(this.openZygoteSocketIfNeeded(abi), zygotePolicyFlags, argsForZygote);
        }
    }

    private boolean fetchUsapPoolEnabledProp() {
        boolean valueChanged;
        boolean origVal = this.mUsapPoolEnabled;
        String propertyString = Zygote.getConfigurationProperty("usap_pool_enabled", USAP_POOL_ENABLED_DEFAULT);
        if (!propertyString.isEmpty()) {
            this.mUsapPoolEnabled = Zygote.getConfigurationPropertyBoolean("usap_pool_enabled", Boolean.parseBoolean(USAP_POOL_ENABLED_DEFAULT));
        }
        boolean bl = valueChanged = origVal != this.mUsapPoolEnabled;
        if (valueChanged) {
            Log.i(LOG_TAG, "usapPoolEnabled = " + this.mUsapPoolEnabled);
        }
        return valueChanged;
    }

    private boolean fetchUsapPoolEnabledPropWithMinInterval() {
        if (!this.mUsapPoolSupported) {
            return false;
        }
        long currentTimestamp = SystemClock.elapsedRealtime();
        if (this.mIsFirstPropCheck || currentTimestamp - this.mLastPropCheckTimestamp >= 60000L) {
            this.mIsFirstPropCheck = false;
            this.mLastPropCheckTimestamp = currentTimestamp;
            return this.fetchUsapPoolEnabledProp();
        }
        return false;
    }

    public void close() {
        if (this.primaryZygoteState != null) {
            this.primaryZygoteState.close();
        }
        if (this.secondaryZygoteState != null) {
            this.secondaryZygoteState.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establishZygoteConnectionForAbi(String abi) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.openZygoteSocketIfNeeded(abi);
            }
        }
        catch (ZygoteStartFailedEx ex) {
            throw new RuntimeException("Unable to connect to zygote for abi: " + abi, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getZygotePid(String abi) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                ZygoteState state = this.openZygoteSocketIfNeeded(abi);
                state.mZygoteOutputWriter.write("1");
                state.mZygoteOutputWriter.newLine();
                state.mZygoteOutputWriter.write("--get-pid");
                state.mZygoteOutputWriter.newLine();
                state.mZygoteOutputWriter.flush();
                int numBytes = state.mZygoteInputStream.readInt();
                byte[] bytes = new byte[numBytes];
                state.mZygoteInputStream.readFully(bytes);
                return Integer.parseInt(new String(bytes, StandardCharsets.US_ASCII));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failure retrieving pid", ex);
        }
    }

    public void bootCompleted() {
        if (_Original_Build.SUPPORTED_32_BIT_ABIS.length > 0) {
            this.bootCompleted(_Original_Build.SUPPORTED_32_BIT_ABIS[0]);
        }
        if (_Original_Build.SUPPORTED_64_BIT_ABIS.length > 0) {
            this.bootCompleted(_Original_Build.SUPPORTED_64_BIT_ABIS[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bootCompleted(String abi) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                ZygoteState state = this.openZygoteSocketIfNeeded(abi);
                state.mZygoteOutputWriter.write("1\n--boot-completed\n");
                state.mZygoteOutputWriter.flush();
                state.mZygoteInputStream.readInt();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to inform zygote of boot_completed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setApiBlacklistExemptions(List<String> exemptions) {
        Object object = this.mLock;
        synchronized (object) {
            this.mApiBlacklistExemptions = exemptions;
            boolean ok = this.maybeSetApiBlacklistExemptions(this.primaryZygoteState, true);
            if (ok) {
                ok = this.maybeSetApiBlacklistExemptions(this.secondaryZygoteState, true);
            }
            return ok;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHiddenApiAccessLogSampleRate(int rate) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHiddenApiAccessLogSampleRate = rate;
            this.maybeSetHiddenApiAccessLogSampleRate(this.primaryZygoteState);
            this.maybeSetHiddenApiAccessLogSampleRate(this.secondaryZygoteState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHiddenApiAccessStatslogSampleRate(int rate) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHiddenApiAccessStatslogSampleRate = rate;
            this.maybeSetHiddenApiAccessStatslogSampleRate(this.primaryZygoteState);
            this.maybeSetHiddenApiAccessStatslogSampleRate(this.secondaryZygoteState);
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean maybeSetApiBlacklistExemptions(ZygoteState state, boolean sendIfEmpty) {
        if (state == null || state.isClosed()) {
            Slog.e(LOG_TAG, "Can't set API blacklist exemptions: no zygote connection");
            return false;
        }
        if (!sendIfEmpty && this.mApiBlacklistExemptions.isEmpty()) {
            return true;
        }
        try {
            state.mZygoteOutputWriter.write(Integer.toString(this.mApiBlacklistExemptions.size() + 1));
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.write("--set-api-blacklist-exemptions");
            state.mZygoteOutputWriter.newLine();
            for (int i = 0; i < this.mApiBlacklistExemptions.size(); ++i) {
                state.mZygoteOutputWriter.write(this.mApiBlacklistExemptions.get(i));
                state.mZygoteOutputWriter.newLine();
            }
            state.mZygoteOutputWriter.flush();
            int status = state.mZygoteInputStream.readInt();
            if (status != 0) {
                Slog.e(LOG_TAG, "Failed to set API blacklist exemptions; status " + status);
            }
            return true;
        }
        catch (IOException ioe) {
            Slog.e(LOG_TAG, "Failed to set API blacklist exemptions", ioe);
            this.mApiBlacklistExemptions = Collections.emptyList();
            return false;
        }
    }

    private void maybeSetHiddenApiAccessLogSampleRate(ZygoteState state) {
        if (state == null || state.isClosed() || this.mHiddenApiAccessLogSampleRate == -1) {
            return;
        }
        try {
            state.mZygoteOutputWriter.write(Integer.toString(1));
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.write("--hidden-api-log-sampling-rate=" + this.mHiddenApiAccessLogSampleRate);
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.flush();
            int status = state.mZygoteInputStream.readInt();
            if (status != 0) {
                Slog.e(LOG_TAG, "Failed to set hidden API log sampling rate; status " + status);
            }
        }
        catch (IOException ioe) {
            Slog.e(LOG_TAG, "Failed to set hidden API log sampling rate", ioe);
        }
    }

    private void maybeSetHiddenApiAccessStatslogSampleRate(ZygoteState state) {
        if (state == null || state.isClosed() || this.mHiddenApiAccessStatslogSampleRate == -1) {
            return;
        }
        try {
            state.mZygoteOutputWriter.write(Integer.toString(1));
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.write("--hidden-api-statslog-sampling-rate=" + this.mHiddenApiAccessStatslogSampleRate);
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.flush();
            int status = state.mZygoteInputStream.readInt();
            if (status != 0) {
                Slog.e(LOG_TAG, "Failed to set hidden API statslog sampling rate; status " + status);
            }
        }
        catch (IOException ioe) {
            Slog.e(LOG_TAG, "Failed to set hidden API statslog sampling rate", ioe);
        }
    }

    @GuardedBy(value={"mLock"})
    private void attemptConnectionToPrimaryZygote() throws IOException {
        if (this.primaryZygoteState == null || this.primaryZygoteState.isClosed()) {
            this.primaryZygoteState = ZygoteState.connect(this.mZygoteSocketAddress, this.mUsapPoolSocketAddress);
            this.maybeSetApiBlacklistExemptions(this.primaryZygoteState, false);
            this.maybeSetHiddenApiAccessLogSampleRate(this.primaryZygoteState);
        }
    }

    @GuardedBy(value={"mLock"})
    private void attemptConnectionToSecondaryZygote() throws IOException {
        if (this.secondaryZygoteState == null || this.secondaryZygoteState.isClosed()) {
            this.secondaryZygoteState = ZygoteState.connect(this.mZygoteSecondarySocketAddress, this.mUsapPoolSecondarySocketAddress);
            this.maybeSetApiBlacklistExemptions(this.secondaryZygoteState, false);
            this.maybeSetHiddenApiAccessLogSampleRate(this.secondaryZygoteState);
        }
    }

    @GuardedBy(value={"mLock"})
    private ZygoteState openZygoteSocketIfNeeded(String abi) throws ZygoteStartFailedEx {
        try {
            this.attemptConnectionToPrimaryZygote();
            if (this.primaryZygoteState.matches(abi)) {
                return this.primaryZygoteState;
            }
            if (this.mZygoteSecondarySocketAddress != null) {
                this.attemptConnectionToSecondaryZygote();
                if (this.secondaryZygoteState.matches(abi)) {
                    return this.secondaryZygoteState;
                }
            }
        }
        catch (IOException ioe) {
            throw new ZygoteStartFailedEx("Error connecting to zygote", ioe);
        }
        throw new ZygoteStartFailedEx("Unsupported zygote ABI: " + abi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preloadApp(ApplicationInfo appInfo, String abi) throws ZygoteStartFailedEx, IOException {
        Object object = this.mLock;
        synchronized (object) {
            ZygoteState state = this.openZygoteSocketIfNeeded(abi);
            state.mZygoteOutputWriter.write("2");
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.write("--preload-app");
            state.mZygoteOutputWriter.newLine();
            Parcel parcel = Parcel.obtain();
            appInfo.writeToParcel(parcel, 0);
            String encodedParcelData = Base64.getEncoder().encodeToString(parcel.marshall());
            parcel.recycle();
            state.mZygoteOutputWriter.write(encodedParcelData);
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.flush();
            return state.mZygoteInputStream.readInt() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preloadPackageForAbi(String packagePath, String libsPath, String libFileName, String cacheKey, String abi) throws ZygoteStartFailedEx, IOException {
        Object object = this.mLock;
        synchronized (object) {
            ZygoteState state = this.openZygoteSocketIfNeeded(abi);
            state.mZygoteOutputWriter.write("5");
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.write("--preload-package");
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.write(packagePath);
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.write(libsPath);
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.write(libFileName);
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.write(cacheKey);
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.flush();
            return state.mZygoteInputStream.readInt() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preloadDefault(String abi) throws ZygoteStartFailedEx, IOException {
        Object object = this.mLock;
        synchronized (object) {
            ZygoteState state = this.openZygoteSocketIfNeeded(abi);
            state.mZygoteOutputWriter.write("1");
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.write("--preload-default");
            state.mZygoteOutputWriter.newLine();
            state.mZygoteOutputWriter.flush();
            return state.mZygoteInputStream.readInt() == 0;
        }
    }

    public static void waitForConnectionToZygote(String zygoteSocketName) {
        LocalSocketAddress zygoteSocketAddress = new LocalSocketAddress(zygoteSocketName, LocalSocketAddress.Namespace.RESERVED);
        ZygoteProcess.waitForConnectionToZygote(zygoteSocketAddress);
    }

    public static void waitForConnectionToZygote(LocalSocketAddress zygoteSocketAddress) {
        int numRetries;
        for (int n = numRetries = 400; n >= 0; --n) {
            try {
                ZygoteState zs = ZygoteState.connect(zygoteSocketAddress, null);
                zs.close();
                return;
            }
            catch (IOException ioe) {
                Log.w(LOG_TAG, "Got error connecting to zygote, retrying. msg= " + ioe.getMessage());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        Slog.wtf(LOG_TAG, "Failed to connect to Zygote through socket " + zygoteSocketAddress.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informZygotesOfUsapPoolStatus() {
        String command = "1\n--usap-pool-enabled=" + this.mUsapPoolEnabled + "\n";
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.attemptConnectionToPrimaryZygote();
                this.primaryZygoteState.mZygoteOutputWriter.write(command);
                this.primaryZygoteState.mZygoteOutputWriter.flush();
            }
            catch (IOException ioe) {
                this.mUsapPoolEnabled = !this.mUsapPoolEnabled;
                Log.w(LOG_TAG, "Failed to inform zygotes of USAP pool status: " + ioe.getMessage());
                return;
            }
            if (this.mZygoteSecondarySocketAddress != null) {
                try {
                    this.attemptConnectionToSecondaryZygote();
                    try {
                        this.secondaryZygoteState.mZygoteOutputWriter.write(command);
                        this.secondaryZygoteState.mZygoteOutputWriter.flush();
                        this.secondaryZygoteState.mZygoteInputStream.readInt();
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("USAP pool state change cause an irrecoverable error", ioe);
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            try {
                this.primaryZygoteState.mZygoteInputStream.readInt();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("USAP pool state change cause an irrecoverable error", ioe);
            }
        }
    }

    public ChildZygoteProcess startChildZygote(String processClass, String niceName, int uid, int gid, int[] gids, int runtimeFlags, String seInfo, String abi, String acceptedAbiList, String instructionSet, int uidRangeStart, int uidRangeEnd) {
        Process.ProcessStartResult result;
        LocalSocketAddress serverAddress = new LocalSocketAddress(processClass + "/" + UUID.randomUUID().toString());
        String[] extraArgs = new String[]{"--zygote-socket=" + serverAddress.getName(), "--abi-list=" + acceptedAbiList, "--uid-range-start=" + uidRangeStart, "--uid-range-end=" + uidRangeEnd};
        try {
            result = this.startViaZygote(processClass, niceName, uid, gid, gids, runtimeFlags, 0, 0, seInfo, abi, instructionSet, null, null, true, null, 4, false, null, null, null, true, false, extraArgs);
        }
        catch (ZygoteStartFailedEx ex) {
            throw new RuntimeException("Starting child-zygote through Zygote failed", ex);
        }
        return new ChildZygoteProcess(serverAddress, result.pid);
    }

    private static class ZygoteState
    implements AutoCloseable {
        final LocalSocketAddress mZygoteSocketAddress;
        final LocalSocketAddress mUsapSocketAddress;
        private final LocalSocket mZygoteSessionSocket;
        final DataInputStream mZygoteInputStream;
        final BufferedWriter mZygoteOutputWriter;
        private final List<String> mAbiList;
        private boolean mClosed;

        private ZygoteState(LocalSocketAddress zygoteSocketAddress, LocalSocketAddress usapSocketAddress, LocalSocket zygoteSessionSocket, DataInputStream zygoteInputStream, BufferedWriter zygoteOutputWriter, List<String> abiList) {
            this.mZygoteSocketAddress = zygoteSocketAddress;
            this.mUsapSocketAddress = usapSocketAddress;
            this.mZygoteSessionSocket = zygoteSessionSocket;
            this.mZygoteInputStream = zygoteInputStream;
            this.mZygoteOutputWriter = zygoteOutputWriter;
            this.mAbiList = abiList;
        }

        static ZygoteState connect(LocalSocketAddress zygoteSocketAddress, LocalSocketAddress usapSocketAddress) throws IOException {
            BufferedWriter zygoteOutputWriter;
            DataInputStream zygoteInputStream;
            LocalSocket zygoteSessionSocket = new LocalSocket();
            if (zygoteSocketAddress == null) {
                throw new IllegalArgumentException("zygoteSocketAddress can't be null");
            }
            try {
                zygoteSessionSocket.connect(zygoteSocketAddress);
                zygoteInputStream = new DataInputStream(zygoteSessionSocket.getInputStream());
                zygoteOutputWriter = new BufferedWriter(new OutputStreamWriter(zygoteSessionSocket.getOutputStream()), 256);
            }
            catch (IOException ex) {
                try {
                    zygoteSessionSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw ex;
            }
            return new ZygoteState(zygoteSocketAddress, usapSocketAddress, zygoteSessionSocket, zygoteInputStream, zygoteOutputWriter, ZygoteProcess.getAbiList(zygoteOutputWriter, zygoteInputStream));
        }

        LocalSocket getUsapSessionSocket() throws IOException {
            LocalSocket usapSessionSocket = new LocalSocket();
            usapSessionSocket.connect(this.mUsapSocketAddress);
            return usapSessionSocket;
        }

        boolean matches(String abi) {
            return this.mAbiList.contains(abi);
        }

        @Override
        public void close() {
            try {
                this.mZygoteSessionSocket.close();
            }
            catch (IOException ex) {
                Log.e(ZygoteProcess.LOG_TAG, "I/O exception on routine close", ex);
            }
            this.mClosed = true;
        }

        boolean isClosed() {
            return this.mClosed;
        }
    }
}

