/*
 * Decompiled with CFR 0.152.
 */
package android.os.connectivity;

import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.ContextImpl;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.os.PowerProfile;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class WifiActivityEnergyInfo
implements Parcelable {
    private final long mTimeSinceBootMillis;
    private final int mStackState;
    private final long mControllerTxDurationMillis;
    private final long mControllerRxDurationMillis;
    private final long mControllerScanDurationMillis;
    private final long mControllerIdleDurationMillis;
    private final long mControllerEnergyUsedMicroJoules;
    public static final int STACK_STATE_INVALID = 0;
    public static final int STACK_STATE_STATE_ACTIVE = 1;
    public static final int STACK_STATE_STATE_SCANNING = 2;
    public static final int STACK_STATE_STATE_IDLE = 3;
    public static final Parcelable.Creator<WifiActivityEnergyInfo> CREATOR = new Parcelable.Creator<WifiActivityEnergyInfo>(){

        @Override
        public WifiActivityEnergyInfo createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            int stackState = in.readInt();
            long txTime = in.readLong();
            long rxTime = in.readLong();
            long scanTime = in.readLong();
            long idleTime = in.readLong();
            return new WifiActivityEnergyInfo(timestamp, stackState, txTime, rxTime, scanTime, idleTime);
        }

        public WifiActivityEnergyInfo[] newArray(int size) {
            return new WifiActivityEnergyInfo[size];
        }
    };

    public WifiActivityEnergyInfo(long timeSinceBootMillis, int stackState, long txDurationMillis, long rxDurationMillis, long scanDurationMillis, long idleDurationMillis) {
        this(timeSinceBootMillis, stackState, txDurationMillis, rxDurationMillis, scanDurationMillis, idleDurationMillis, WifiActivityEnergyInfo.calculateEnergyMicroJoules(txDurationMillis, rxDurationMillis, idleDurationMillis));
    }

    private static long calculateEnergyMicroJoules(long txDurationMillis, long rxDurationMillis, long idleDurationMillis) {
        ContextImpl context = ActivityThread.currentActivityThread().getSystemContext();
        if (context == null) {
            return 0L;
        }
        PowerProfile powerProfile = new PowerProfile(context);
        double rxIdleCurrent = powerProfile.getAveragePower("wifi.controller.idle");
        double rxCurrent = powerProfile.getAveragePower("wifi.controller.rx");
        double txCurrent = powerProfile.getAveragePower("wifi.controller.tx");
        double voltage = powerProfile.getAveragePower("wifi.controller.voltage") / 1000.0;
        return (long)(((double)txDurationMillis * txCurrent + (double)rxDurationMillis * rxCurrent + (double)idleDurationMillis * rxIdleCurrent) * voltage);
    }

    public WifiActivityEnergyInfo(long timeSinceBootMillis, int stackState, long txDurationMillis, long rxDurationMillis, long scanDurationMillis, long idleDurationMillis, long energyUsedMicroJoules) {
        this.mTimeSinceBootMillis = timeSinceBootMillis;
        this.mStackState = stackState;
        this.mControllerTxDurationMillis = txDurationMillis;
        this.mControllerRxDurationMillis = rxDurationMillis;
        this.mControllerScanDurationMillis = scanDurationMillis;
        this.mControllerIdleDurationMillis = idleDurationMillis;
        this.mControllerEnergyUsedMicroJoules = energyUsedMicroJoules;
    }

    public String toString() {
        return "WifiActivityEnergyInfo{ mTimeSinceBootMillis=" + this.mTimeSinceBootMillis + " mStackState=" + this.mStackState + " mControllerTxDurationMillis=" + this.mControllerTxDurationMillis + " mControllerRxDurationMillis=" + this.mControllerRxDurationMillis + " mControllerScanDurationMillis=" + this.mControllerScanDurationMillis + " mControllerIdleDurationMillis=" + this.mControllerIdleDurationMillis + " mControllerEnergyUsedMicroJoules=" + this.mControllerEnergyUsedMicroJoules + " }";
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mTimeSinceBootMillis);
        out.writeInt(this.mStackState);
        out.writeLong(this.mControllerTxDurationMillis);
        out.writeLong(this.mControllerRxDurationMillis);
        out.writeLong(this.mControllerScanDurationMillis);
        out.writeLong(this.mControllerIdleDurationMillis);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public long getTimeSinceBootMillis() {
        return this.mTimeSinceBootMillis;
    }

    public int getStackState() {
        return this.mStackState;
    }

    public long getControllerTxDurationMillis() {
        return this.mControllerTxDurationMillis;
    }

    public long getControllerRxDurationMillis() {
        return this.mControllerRxDurationMillis;
    }

    public long getControllerScanDurationMillis() {
        return this.mControllerScanDurationMillis;
    }

    public long getControllerIdleDurationMillis() {
        return this.mControllerIdleDurationMillis;
    }

    public long getControllerEnergyUsedMicroJoules() {
        return this.mControllerEnergyUsedMicroJoules;
    }

    public boolean isValid() {
        return this.mControllerTxDurationMillis >= 0L && this.mControllerRxDurationMillis >= 0L && this.mControllerScanDurationMillis >= 0L && this.mControllerIdleDurationMillis >= 0L;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StackState {
    }
}

