/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.os.storage.StorageVolume;
import android.os.storage.VolumeInfo;
import android.util.DebugUtils;
import android.util.TimeUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.util.Locale;
import java.util.Objects;

public class VolumeRecord
implements Parcelable {
    public static final String EXTRA_FS_UUID = "android.os.storage.extra.FS_UUID";
    public static final int USER_FLAG_INITED = 1;
    public static final int USER_FLAG_SNOOZED = 2;
    public final int type;
    public final String fsUuid;
    public String partGuid;
    public String nickname;
    public int userFlags;
    public long createdMillis;
    public long lastSeenMillis;
    public long lastTrimMillis;
    public long lastBenchMillis;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<VolumeRecord> CREATOR = new Parcelable.Creator<VolumeRecord>(){

        @Override
        public VolumeRecord createFromParcel(Parcel in) {
            return new VolumeRecord(in);
        }

        public VolumeRecord[] newArray(int size) {
            return new VolumeRecord[size];
        }
    };

    public VolumeRecord(int type, String fsUuid) {
        this.type = type;
        this.fsUuid = Preconditions.checkNotNull(fsUuid);
    }

    @UnsupportedAppUsage
    public VolumeRecord(Parcel parcel) {
        this.type = parcel.readInt();
        this.fsUuid = parcel.readString();
        this.partGuid = parcel.readString();
        this.nickname = parcel.readString();
        this.userFlags = parcel.readInt();
        this.createdMillis = parcel.readLong();
        this.lastSeenMillis = parcel.readLong();
        this.lastTrimMillis = parcel.readLong();
        this.lastBenchMillis = parcel.readLong();
    }

    public int getType() {
        return this.type;
    }

    public String getFsUuid() {
        return this.fsUuid;
    }

    public String getNormalizedFsUuid() {
        return this.fsUuid != null ? this.fsUuid.toLowerCase(Locale.US) : null;
    }

    public String getNickname() {
        return this.nickname;
    }

    public boolean isInited() {
        return (this.userFlags & 1) != 0;
    }

    public boolean isSnoozed() {
        return (this.userFlags & 2) != 0;
    }

    public StorageVolume buildStorageVolume(Context context) {
        String id2 = "unknown:" + this.fsUuid;
        File userPath = new File("/dev/null");
        File internalPath = new File("/dev/null");
        boolean primary = false;
        boolean removable = true;
        boolean emulated = false;
        boolean allowMassStorage = false;
        long maxFileSize = 0L;
        UserHandle user = new UserHandle(-10000);
        String envState = "unknown";
        String description = this.nickname;
        if (description == null) {
            description = context.getString(17039374);
        }
        return new StorageVolume(id2, userPath, internalPath, description, false, true, false, false, 0L, user, this.fsUuid, "unknown");
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("VolumeRecord:");
        pw.increaseIndent();
        pw.printPair("type", DebugUtils.valueToString(VolumeInfo.class, "TYPE_", this.type));
        pw.printPair("fsUuid", this.fsUuid);
        pw.printPair("partGuid", this.partGuid);
        pw.println();
        pw.printPair("nickname", this.nickname);
        pw.printPair("userFlags", DebugUtils.flagsToString(VolumeRecord.class, "USER_FLAG_", this.userFlags));
        pw.println();
        pw.printPair("createdMillis", TimeUtils.formatForLogging(this.createdMillis));
        pw.printPair("lastSeenMillis", TimeUtils.formatForLogging(this.lastSeenMillis));
        pw.printPair("lastTrimMillis", TimeUtils.formatForLogging(this.lastTrimMillis));
        pw.printPair("lastBenchMillis", TimeUtils.formatForLogging(this.lastBenchMillis));
        pw.decreaseIndent();
        pw.println();
    }

    public VolumeRecord clone() {
        Parcel temp = Parcel.obtain();
        try {
            this.writeToParcel(temp, 0);
            temp.setDataPosition(0);
            VolumeRecord volumeRecord = CREATOR.createFromParcel(temp);
            return volumeRecord;
        }
        finally {
            temp.recycle();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof VolumeRecord) {
            return Objects.equals(this.fsUuid, ((VolumeRecord)o).fsUuid);
        }
        return false;
    }

    public int hashCode() {
        return this.fsUuid.hashCode();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.type);
        parcel.writeString(this.fsUuid);
        parcel.writeString(this.partGuid);
        parcel.writeString(this.nickname);
        parcel.writeInt(this.userFlags);
        parcel.writeLong(this.createdMillis);
        parcel.writeLong(this.lastSeenMillis);
        parcel.writeLong(this.lastTrimMillis);
        parcel.writeLong(this.lastBenchMillis);
    }
}

