/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.UserHandle;
import com.android.internal.infra.AndroidFuture;
import java.util.ArrayList;
import java.util.List;

public interface IPermissionController
extends IInterface {
    public void revokeRuntimePermissions(Bundle var1, boolean var2, int var3, String var4, AndroidFuture var5) throws RemoteException;

    public void getRuntimePermissionBackup(UserHandle var1, ParcelFileDescriptor var2) throws RemoteException;

    public void stageAndApplyRuntimePermissionsBackup(UserHandle var1, ParcelFileDescriptor var2) throws RemoteException;

    public void applyStagedRuntimePermissionBackup(String var1, UserHandle var2, AndroidFuture var3) throws RemoteException;

    public void getAppPermissions(String var1, AndroidFuture var2) throws RemoteException;

    public void revokeRuntimePermission(String var1, String var2) throws RemoteException;

    public void countPermissionApps(List<String> var1, int var2, AndroidFuture var3) throws RemoteException;

    public void getPermissionUsages(boolean var1, long var2, AndroidFuture var4) throws RemoteException;

    public void setRuntimePermissionGrantStateByDeviceAdmin(String var1, String var2, String var3, int var4, AndroidFuture var5) throws RemoteException;

    public void grantOrUpgradeDefaultRuntimePermissions(AndroidFuture var1) throws RemoteException;

    public void notifyOneTimePermissionSessionTimeout(String var1) throws RemoteException;

    public void updateUserSensitiveForApp(int var1, AndroidFuture var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPermissionController {
        private static final String DESCRIPTOR = "android.permission.IPermissionController";
        static final int TRANSACTION_revokeRuntimePermissions = 1;
        static final int TRANSACTION_getRuntimePermissionBackup = 2;
        static final int TRANSACTION_stageAndApplyRuntimePermissionsBackup = 3;
        static final int TRANSACTION_applyStagedRuntimePermissionBackup = 4;
        static final int TRANSACTION_getAppPermissions = 5;
        static final int TRANSACTION_revokeRuntimePermission = 6;
        static final int TRANSACTION_countPermissionApps = 7;
        static final int TRANSACTION_getPermissionUsages = 8;
        static final int TRANSACTION_setRuntimePermissionGrantStateByDeviceAdmin = 9;
        static final int TRANSACTION_grantOrUpgradeDefaultRuntimePermissions = 10;
        static final int TRANSACTION_notifyOneTimePermissionSessionTimeout = 11;
        static final int TRANSACTION_updateUserSensitiveForApp = 12;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPermissionController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPermissionController) {
                return (IPermissionController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "revokeRuntimePermissions";
                }
                case 2: {
                    return "getRuntimePermissionBackup";
                }
                case 3: {
                    return "stageAndApplyRuntimePermissionsBackup";
                }
                case 4: {
                    return "applyStagedRuntimePermissionBackup";
                }
                case 5: {
                    return "getAppPermissions";
                }
                case 6: {
                    return "revokeRuntimePermission";
                }
                case 7: {
                    return "countPermissionApps";
                }
                case 8: {
                    return "getPermissionUsages";
                }
                case 9: {
                    return "setRuntimePermissionGrantStateByDeviceAdmin";
                }
                case 10: {
                    return "grantOrUpgradeDefaultRuntimePermissions";
                }
                case 11: {
                    return "notifyOneTimePermissionSessionTimeout";
                }
                case 12: {
                    return "updateUserSensitiveForApp";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    Bundle _arg0 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    AndroidFuture _arg4 = 0 != data.readInt() ? AndroidFuture.CREATOR.createFromParcel(data) : null;
                    this.revokeRuntimePermissions(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    UserHandle _arg0 = 0 != data.readInt() ? UserHandle.CREATOR.createFromParcel(data) : null;
                    ParcelFileDescriptor _arg1 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    this.getRuntimePermissionBackup(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    UserHandle _arg0 = 0 != data.readInt() ? UserHandle.CREATOR.createFromParcel(data) : null;
                    ParcelFileDescriptor _arg1 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    this.stageAndApplyRuntimePermissionsBackup(_arg0, _arg1);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    UserHandle _arg1 = 0 != data.readInt() ? UserHandle.CREATOR.createFromParcel(data) : null;
                    AndroidFuture _arg2 = 0 != data.readInt() ? AndroidFuture.CREATOR.createFromParcel(data) : null;
                    this.applyStagedRuntimePermissionBackup(_arg0, _arg1, _arg2);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    AndroidFuture _arg1 = 0 != data.readInt() ? AndroidFuture.CREATOR.createFromParcel(data) : null;
                    this.getAppPermissions(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.revokeRuntimePermission(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    int _arg1 = data.readInt();
                    AndroidFuture _arg2 = 0 != data.readInt() ? AndroidFuture.CREATOR.createFromParcel(data) : null;
                    this.countPermissionApps(_arg0, _arg1, _arg2);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    long _arg1 = data.readLong();
                    AndroidFuture _arg2 = 0 != data.readInt() ? AndroidFuture.CREATOR.createFromParcel(data) : null;
                    this.getPermissionUsages(_arg0, _arg1, _arg2);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    AndroidFuture _arg4 = 0 != data.readInt() ? AndroidFuture.CREATOR.createFromParcel(data) : null;
                    this.setRuntimePermissionGrantStateByDeviceAdmin(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    AndroidFuture _arg0 = 0 != data.readInt() ? AndroidFuture.CREATOR.createFromParcel(data) : null;
                    this.grantOrUpgradeDefaultRuntimePermissions(_arg0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.notifyOneTimePermissionSessionTimeout(_arg0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AndroidFuture _arg1 = 0 != data.readInt() ? AndroidFuture.CREATOR.createFromParcel(data) : null;
                    this.updateUserSensitiveForApp(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IPermissionController impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IPermissionController getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IPermissionController {
            private IBinder mRemote;
            public static IPermissionController sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeRuntimePermissions(Bundle request, boolean doDryRun, int reason, String callerPackageName, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(doDryRun ? 1 : 0);
                    _data.writeInt(reason);
                    _data.writeString(callerPackageName);
                    if (callback != null) {
                        _data.writeInt(1);
                        callback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().revokeRuntimePermissions(request, doDryRun, reason, callerPackageName, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getRuntimePermissionBackup(UserHandle user, ParcelFileDescriptor pipe) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (user != null) {
                        _data.writeInt(1);
                        user.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (pipe != null) {
                        _data.writeInt(1);
                        pipe.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getRuntimePermissionBackup(user, pipe);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stageAndApplyRuntimePermissionsBackup(UserHandle user, ParcelFileDescriptor pipe) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (user != null) {
                        _data.writeInt(1);
                        user.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (pipe != null) {
                        _data.writeInt(1);
                        pipe.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stageAndApplyRuntimePermissionsBackup(user, pipe);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyStagedRuntimePermissionBackup(String packageName, UserHandle user, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    if (user != null) {
                        _data.writeInt(1);
                        user.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (callback != null) {
                        _data.writeInt(1);
                        callback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().applyStagedRuntimePermissionBackup(packageName, user, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAppPermissions(String packageName, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    if (callback != null) {
                        _data.writeInt(1);
                        callback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getAppPermissions(packageName, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeRuntimePermission(String packageName, String permissionName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(permissionName);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().revokeRuntimePermission(packageName, permissionName);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void countPermissionApps(List<String> permissionNames, int flags, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(permissionNames);
                    _data.writeInt(flags);
                    if (callback != null) {
                        _data.writeInt(1);
                        callback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().countPermissionApps(permissionNames, flags, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPermissionUsages(boolean countSystem, long numMillis, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(countSystem ? 1 : 0);
                    _data.writeLong(numMillis);
                    if (callback != null) {
                        _data.writeInt(1);
                        callback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getPermissionUsages(countSystem, numMillis, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRuntimePermissionGrantStateByDeviceAdmin(String callerPackageName, String packageName, String permission2, int grantState, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callerPackageName);
                    _data.writeString(packageName);
                    _data.writeString(permission2);
                    _data.writeInt(grantState);
                    if (callback != null) {
                        _data.writeInt(1);
                        callback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRuntimePermissionGrantStateByDeviceAdmin(callerPackageName, packageName, permission2, grantState, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantOrUpgradeDefaultRuntimePermissions(AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (callback != null) {
                        _data.writeInt(1);
                        callback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().grantOrUpgradeDefaultRuntimePermissions(callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyOneTimePermissionSessionTimeout(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyOneTimePermissionSessionTimeout(packageName);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateUserSensitiveForApp(int uid, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    if (callback != null) {
                        _data.writeInt(1);
                        callback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateUserSensitiveForApp(uid, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPermissionController {
        @Override
        public void revokeRuntimePermissions(Bundle request, boolean doDryRun, int reason, String callerPackageName, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void getRuntimePermissionBackup(UserHandle user, ParcelFileDescriptor pipe) throws RemoteException {
        }

        @Override
        public void stageAndApplyRuntimePermissionsBackup(UserHandle user, ParcelFileDescriptor pipe) throws RemoteException {
        }

        @Override
        public void applyStagedRuntimePermissionBackup(String packageName, UserHandle user, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void getAppPermissions(String packageName, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void revokeRuntimePermission(String packageName, String permissionName) throws RemoteException {
        }

        @Override
        public void countPermissionApps(List<String> permissionNames, int flags, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void getPermissionUsages(boolean countSystem, long numMillis, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void setRuntimePermissionGrantStateByDeviceAdmin(String callerPackageName, String packageName, String permission2, int grantState, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void grantOrUpgradeDefaultRuntimePermissions(AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void notifyOneTimePermissionSessionTimeout(String packageName) throws RemoteException {
        }

        @Override
        public void updateUserSensitiveForApp(int uid, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

