/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.Context;
import android.os.RemoteException;
import android.security.IFileIntegrityService;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class FileIntegrityManager {
    private final IFileIntegrityService mService;
    private final Context mContext;

    public FileIntegrityManager(Context context, IFileIntegrityService service) {
        this.mContext = context;
        this.mService = service;
    }

    public boolean isApkVeritySupported() {
        try {
            return this.mService.isApkVeritySupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isAppSourceCertificateTrusted(X509Certificate certificate) throws CertificateEncodingException {
        try {
            return this.mService.isAppSourceCertificateTrusted(certificate.getEncoded(), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

