/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.app.ActivityThread;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.hardware.biometrics.BiometricManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.UserHandle;
import android.security.GateKeeper;
import android.security.KeyStoreException;
import android.security.keymaster.ExportResult;
import android.security.keymaster.KeyCharacteristics;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.KeymasterBlob;
import android.security.keymaster.KeymasterCertificateChain;
import android.security.keymaster.KeymasterDefs;
import android.security.keymaster.OperationResult;
import android.security.keystore.IKeystoreCertificateChainCallback;
import android.security.keystore.IKeystoreExportKeyCallback;
import android.security.keystore.IKeystoreKeyCharacteristicsCallback;
import android.security.keystore.IKeystoreOperationResultCallback;
import android.security.keystore.IKeystoreResponseCallback;
import android.security.keystore.IKeystoreService;
import android.security.keystore.KeyExpiredException;
import android.security.keystore.KeyNotYetValidException;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore.KeyProperties;
import android.security.keystore.KeystoreResponse;
import android.security.keystore.UserNotAuthenticatedException;
import android.util.Log;
import com.android.org.bouncycastle.asn1.ASN1InputStream;
import com.android.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public class KeyStore {
    private static final String TAG = "KeyStore";
    @UnsupportedAppUsage
    public static final int NO_ERROR = 1;
    public static final int LOCKED = 2;
    public static final int UNINITIALIZED = 3;
    public static final int SYSTEM_ERROR = 4;
    public static final int PROTOCOL_ERROR = 5;
    public static final int PERMISSION_DENIED = 6;
    public static final int KEY_NOT_FOUND = 7;
    public static final int VALUE_CORRUPTED = 8;
    public static final int UNDEFINED_ACTION = 9;
    public static final int WRONG_PASSWORD = 10;
    public static final int KEY_ALREADY_EXISTS = 16;
    public static final int CANNOT_ATTEST_IDS = -66;
    public static final int HARDWARE_TYPE_UNAVAILABLE = -68;
    public static final int OP_AUTH_NEEDED = 15;
    public static final int KEY_PERMANENTLY_INVALIDATED = 17;
    public static final int UID_SELF = -1;
    public static final int FLAG_NONE = 0;
    public static final int FLAG_ENCRYPTED = 1;
    public static final int FLAG_SOFTWARE = 2;
    public static final int FLAG_CRITICAL_TO_DEVICE_ENCRYPTION = 8;
    public static final int FLAG_STRONGBOX = 16;
    private int mError = 1;
    private final IKeystoreService mBinder;
    private final Context mContext;
    private IBinder mToken;
    public static final int CONFIRMATIONUI_OK = 0;
    public static final int CONFIRMATIONUI_CANCELED = 1;
    public static final int CONFIRMATIONUI_ABORTED = 2;
    public static final int CONFIRMATIONUI_OPERATION_PENDING = 3;
    public static final int CONFIRMATIONUI_IGNORED = 4;
    public static final int CONFIRMATIONUI_SYSTEM_ERROR = 5;
    public static final int CONFIRMATIONUI_UNIMPLEMENTED = 6;
    public static final int CONFIRMATIONUI_UNEXPECTED = 7;
    public static final int CONFIRMATIONUI_UIERROR = 65536;
    public static final int CONFIRMATIONUI_UIERROR_MISSING_GLYPH = 65537;
    public static final int CONFIRMATIONUI_UIERROR_MESSAGE_TOO_LONG = 65538;
    public static final int CONFIRMATIONUI_UIERROR_MALFORMED_UTF8_ENCODING = 65539;

    private KeyStore(IKeystoreService binder) {
        this.mBinder = binder;
        this.mContext = KeyStore.getApplicationContext();
    }

    @UnsupportedAppUsage
    public static Context getApplicationContext() {
        Application application = ActivityThread.currentApplication();
        if (application == null) {
            throw new IllegalStateException("Failed to obtain application Context from ActivityThread");
        }
        return application;
    }

    @UnsupportedAppUsage
    public static KeyStore getInstance() {
        IKeystoreService keystore = IKeystoreService.Stub.asInterface(ServiceManager.getService("android.security.keystore"));
        return new KeyStore(keystore);
    }

    private synchronized IBinder getToken() {
        if (this.mToken == null) {
            this.mToken = new Binder();
        }
        return this.mToken;
    }

    @UnsupportedAppUsage
    public State state(int userId) {
        int ret;
        try {
            ret = this.mBinder.getState(userId);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            throw new AssertionError((Object)e);
        }
        switch (ret) {
            case 1: {
                return State.UNLOCKED;
            }
            case 2: {
                return State.LOCKED;
            }
            case 3: {
                return State.UNINITIALIZED;
            }
        }
        throw new AssertionError(this.mError);
    }

    @UnsupportedAppUsage
    public State state() {
        return this.state(UserHandle.myUserId());
    }

    public boolean isUnlocked() {
        return this.state() == State.UNLOCKED;
    }

    public byte[] get(String key, int uid) {
        return this.get(key, uid, false);
    }

    @UnsupportedAppUsage
    public byte[] get(String key) {
        return this.get(key, -1);
    }

    public byte[] get(String key, int uid, boolean suppressKeyNotFoundWarning) {
        try {
            key = key != null ? key : "";
            return this.mBinder.get(key, uid);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return null;
        }
        catch (ServiceSpecificException e) {
            if (!suppressKeyNotFoundWarning || e.errorCode != 7) {
                Log.w(TAG, "KeyStore exception", e);
            }
            return null;
        }
    }

    public byte[] get(String key, boolean suppressKeyNotFoundWarning) {
        return this.get(key, -1, suppressKeyNotFoundWarning);
    }

    public boolean put(String key, byte[] value, int uid, int flags) {
        return this.insert(key, value, uid, flags) == 1;
    }

    public int insert(String key, byte[] value, int uid, int flags) {
        try {
            int error;
            if (value == null) {
                value = new byte[]{};
            }
            if ((error = this.mBinder.insert(key, value, uid, flags)) == 16) {
                this.mBinder.del(key, uid);
                error = this.mBinder.insert(key, value, uid, flags);
            }
            return error;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return 4;
        }
    }

    int delete2(String key, int uid) {
        try {
            return this.mBinder.del(key, uid);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return 4;
        }
    }

    public boolean delete(String key, int uid) {
        int ret = this.delete2(key, uid);
        return ret == 1 || ret == 7;
    }

    @UnsupportedAppUsage
    public boolean delete(String key) {
        return this.delete(key, -1);
    }

    public boolean contains(String key, int uid) {
        try {
            return this.mBinder.exist(key, uid) == 1;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return false;
        }
    }

    public boolean contains(String key) {
        return this.contains(key, -1);
    }

    public String[] list(String prefix, int uid) {
        try {
            return this.mBinder.list(prefix, uid);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return null;
        }
        catch (ServiceSpecificException e) {
            Log.w(TAG, "KeyStore exception", e);
            return null;
        }
    }

    @UnsupportedAppUsage
    public int[] listUidsOfAuthBoundKeys() {
        ArrayList<String> uidsOut = new ArrayList<String>();
        try {
            int rc = this.mBinder.listUidsOfAuthBoundKeys(uidsOut);
            if (rc != 1) {
                Log.w(TAG, String.format("listUidsOfAuthBoundKeys failed with error code %d", rc));
                return null;
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return null;
        }
        catch (ServiceSpecificException e) {
            Log.w(TAG, "KeyStore exception", e);
            return null;
        }
        return uidsOut.stream().mapToInt(Integer::parseInt).toArray();
    }

    public String[] list(String prefix) {
        return this.list(prefix, -1);
    }

    public boolean lock(int userId) {
        try {
            return this.mBinder.lock(userId) == 1;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return false;
        }
    }

    public boolean lock() {
        return this.lock(UserHandle.myUserId());
    }

    public boolean unlock(int userId, String password) {
        try {
            password = password != null ? password : "";
            this.mError = this.mBinder.unlock(userId, password);
            return this.mError == 1;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return false;
        }
    }

    @UnsupportedAppUsage
    public boolean unlock(String password) {
        return this.unlock(UserHandle.getUserId(Process.myUid()), password);
    }

    public boolean isEmpty(int userId) {
        try {
            return this.mBinder.isEmpty(userId) != 0;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return false;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public boolean isEmpty() {
        return this.isEmpty(UserHandle.myUserId());
    }

    public String grant(String key, int uid) {
        try {
            String grantAlias = this.mBinder.grant(key, uid);
            if (grantAlias == "") {
                return null;
            }
            return grantAlias;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return null;
        }
    }

    public boolean ungrant(String key, int uid) {
        try {
            return this.mBinder.ungrant(key, uid) == 1;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return false;
        }
    }

    public long getmtime(String key, int uid) {
        try {
            long millis = this.mBinder.getmtime(key, uid);
            if (millis == -1L) {
                return -1L;
            }
            return millis * 1000L;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return -1L;
        }
    }

    public long getmtime(String key) {
        return this.getmtime(key, -1);
    }

    public boolean isHardwareBacked() {
        return this.isHardwareBacked("RSA");
    }

    public boolean isHardwareBacked(String keyType) {
        try {
            return this.mBinder.is_hardware_backed(keyType.toUpperCase(Locale.US)) == 1;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return false;
        }
    }

    public boolean clearUid(int uid) {
        try {
            return this.mBinder.clear_uid(uid) == 1;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return false;
        }
    }

    public int getLastError() {
        return this.mError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRngEntropy(byte[] data, int flags) {
        KeystoreResultPromise promise = new KeystoreResultPromise();
        try {
            this.mBinder.asBinder().linkToDeath(promise, 0);
            int errorCode = this.mBinder.addRngEntropy(promise, data, flags);
            if (errorCode == 1) {
                boolean bl = KeyStore.interruptedPreservingGet(promise.getFuture()).getErrorCode() == 1;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            boolean bl = false;
            return bl;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "AddRngEntropy completed with exception", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateKeyInternal(String alias, KeymasterArguments args, byte[] entropy, int uid, int flags, KeyCharacteristics outCharacteristics) throws RemoteException, ExecutionException {
        KeyCharacteristicsPromise promise = new KeyCharacteristicsPromise();
        int error = 1;
        KeyCharacteristicsCallbackResult result = null;
        try {
            this.mBinder.asBinder().linkToDeath(promise, 0);
            error = this.mBinder.generateKey(promise, alias, args, entropy, uid, flags);
            if (error != 1) {
                Log.e(TAG, "generateKeyInternal failed on request " + error);
                int n = error;
                return n;
            }
            result = KeyStore.interruptedPreservingGet(promise.getFuture());
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
        error = result.getKeystoreResponse().getErrorCode();
        if (error != 1) {
            Log.e(TAG, "generateKeyInternal failed on response " + error);
            return error;
        }
        KeyCharacteristics characteristics = result.getKeyCharacteristics();
        if (characteristics == null) {
            Log.e(TAG, "generateKeyInternal got empty key characteristics " + error);
            return 4;
        }
        outCharacteristics.shallowCopyFrom(characteristics);
        return 1;
    }

    public int generateKey(String alias, KeymasterArguments args, byte[] entropy, int uid, int flags, KeyCharacteristics outCharacteristics) {
        try {
            entropy = entropy != null ? entropy : new byte[]{};
            args = args != null ? args : new KeymasterArguments();
            int error = this.generateKeyInternal(alias, args, entropy, uid, flags, outCharacteristics);
            if (error == 16) {
                this.mBinder.del(alias, uid);
                error = this.generateKeyInternal(alias, args, entropy, uid, flags, outCharacteristics);
            }
            return error;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return 4;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "generateKey completed with exception", e);
            return 4;
        }
    }

    public int generateKey(String alias, KeymasterArguments args, byte[] entropy, int flags, KeyCharacteristics outCharacteristics) {
        return this.generateKey(alias, args, entropy, -1, flags, outCharacteristics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeyCharacteristics(String alias, KeymasterBlob clientId, KeymasterBlob appId, int uid, KeyCharacteristics outCharacteristics) {
        KeyCharacteristicsPromise promise = new KeyCharacteristicsPromise();
        try {
            this.mBinder.asBinder().linkToDeath(promise, 0);
            clientId = clientId != null ? clientId : new KeymasterBlob(new byte[0]);
            appId = appId != null ? appId : new KeymasterBlob(new byte[0]);
            int error = this.mBinder.getKeyCharacteristics(promise, alias, clientId, appId, uid);
            if (error != 1) {
                int n = error;
                return n;
            }
            KeyCharacteristicsCallbackResult result = KeyStore.interruptedPreservingGet(promise.getFuture());
            error = result.getKeystoreResponse().getErrorCode();
            if (error != 1) {
                int n = error;
                return n;
            }
            KeyCharacteristics characteristics = result.getKeyCharacteristics();
            if (characteristics == null) {
                int n = 4;
                return n;
            }
            outCharacteristics.shallowCopyFrom(characteristics);
            int n = 1;
            return n;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            int n = 4;
            return n;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "GetKeyCharacteristics completed with exception", e);
            int n = 4;
            return n;
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
    }

    public int getKeyCharacteristics(String alias, KeymasterBlob clientId, KeymasterBlob appId, KeyCharacteristics outCharacteristics) {
        return this.getKeyCharacteristics(alias, clientId, appId, -1, outCharacteristics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int importKeyInternal(String alias, KeymasterArguments args, int format, byte[] keyData, int uid, int flags, KeyCharacteristics outCharacteristics) throws RemoteException, ExecutionException {
        KeyCharacteristicsPromise promise = new KeyCharacteristicsPromise();
        this.mBinder.asBinder().linkToDeath(promise, 0);
        try {
            int error = this.mBinder.importKey(promise, alias, args, format, keyData, uid, flags);
            if (error != 1) {
                int n = error;
                return n;
            }
            KeyCharacteristicsCallbackResult result = KeyStore.interruptedPreservingGet(promise.getFuture());
            error = result.getKeystoreResponse().getErrorCode();
            if (error != 1) {
                int n = error;
                return n;
            }
            KeyCharacteristics characteristics = result.getKeyCharacteristics();
            if (characteristics == null) {
                int n = 4;
                return n;
            }
            outCharacteristics.shallowCopyFrom(characteristics);
            int n = 1;
            return n;
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
    }

    public int importKey(String alias, KeymasterArguments args, int format, byte[] keyData, int uid, int flags, KeyCharacteristics outCharacteristics) {
        try {
            int error = this.importKeyInternal(alias, args, format, keyData, uid, flags, outCharacteristics);
            if (error == 16) {
                this.mBinder.del(alias, uid);
                error = this.importKeyInternal(alias, args, format, keyData, uid, flags, outCharacteristics);
            }
            return error;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return 4;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "ImportKey completed with exception", e);
            return 4;
        }
    }

    public int importKey(String alias, KeymasterArguments args, int format, byte[] keyData, int flags, KeyCharacteristics outCharacteristics) {
        return this.importKey(alias, args, format, keyData, -1, flags, outCharacteristics);
    }

    private String getAlgorithmFromPKCS8(byte[] keyData) {
        try {
            ASN1InputStream bIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(keyData));
            PrivateKeyInfo pki = PrivateKeyInfo.getInstance((Object)bIn.readObject());
            String algOid = pki.getPrivateKeyAlgorithm().getAlgorithm().getId();
            return new AlgorithmId(new ObjectIdentifier(algOid)).getName();
        }
        catch (IOException e) {
            Log.e(TAG, "getAlgorithmFromPKCS8 Failed to parse key data");
            Log.e(TAG, Log.getStackTraceString(e));
            return null;
        }
    }

    private KeymasterArguments makeLegacyArguments(String algorithm) {
        KeymasterArguments args = new KeymasterArguments();
        args.addEnum(0x10000002, KeyProperties.KeyAlgorithm.toKeymasterAsymmetricKeyAlgorithm(algorithm));
        args.addEnum(0x20000001, 2);
        args.addEnum(0x20000001, 3);
        args.addEnum(0x20000001, 0);
        args.addEnum(0x20000001, 1);
        args.addEnum(0x20000006, 1);
        if (algorithm.equalsIgnoreCase("RSA")) {
            args.addEnum(0x20000006, 2);
            args.addEnum(0x20000006, 4);
            args.addEnum(0x20000006, 5);
            args.addEnum(0x20000006, 3);
        }
        args.addEnum(0x20000005, 0);
        args.addEnum(0x20000005, 1);
        args.addEnum(0x20000005, 2);
        args.addEnum(0x20000005, 3);
        args.addEnum(0x20000005, 4);
        args.addEnum(0x20000005, 5);
        args.addEnum(0x20000005, 6);
        args.addBoolean(1879048695);
        args.addDate(1610613137, new Date(Long.MAX_VALUE));
        args.addDate(1610613138, new Date(Long.MAX_VALUE));
        args.addDate(1610613136, new Date(0L));
        return args;
    }

    public boolean importKey(String alias, byte[] keyData, int uid, int flags) {
        KeyCharacteristics out;
        String algorithm = this.getAlgorithmFromPKCS8(keyData);
        if (algorithm == null) {
            return false;
        }
        KeymasterArguments args = this.makeLegacyArguments(algorithm);
        int result = this.importKey(alias, args, 1, keyData, uid, flags, out = new KeyCharacteristics());
        if (result != 1) {
            Log.e(TAG, Log.getStackTraceString(new KeyStoreException(result, "legacy key import failed")));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int importWrappedKeyInternal(String wrappedKeyAlias, byte[] wrappedKey, String wrappingKeyAlias, byte[] maskingKey, KeymasterArguments args, long rootSid, long fingerprintSid, KeyCharacteristics outCharacteristics) throws RemoteException, ExecutionException {
        KeyCharacteristicsPromise promise = new KeyCharacteristicsPromise();
        this.mBinder.asBinder().linkToDeath(promise, 0);
        try {
            int error = this.mBinder.importWrappedKey(promise, wrappedKeyAlias, wrappedKey, wrappingKeyAlias, maskingKey, args, rootSid, fingerprintSid);
            if (error != 1) {
                int n = error;
                return n;
            }
            KeyCharacteristicsCallbackResult result = KeyStore.interruptedPreservingGet(promise.getFuture());
            error = result.getKeystoreResponse().getErrorCode();
            if (error != 1) {
                int n = error;
                return n;
            }
            KeyCharacteristics characteristics = result.getKeyCharacteristics();
            if (characteristics == null) {
                int n = 4;
                return n;
            }
            outCharacteristics.shallowCopyFrom(characteristics);
            int n = 1;
            return n;
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
    }

    public int importWrappedKey(String wrappedKeyAlias, byte[] wrappedKey, String wrappingKeyAlias, byte[] maskingKey, KeymasterArguments args, long rootSid, long fingerprintSid, int uid, KeyCharacteristics outCharacteristics) {
        try {
            int error = this.importWrappedKeyInternal(wrappedKeyAlias, wrappedKey, wrappingKeyAlias, maskingKey, args, rootSid, fingerprintSid, outCharacteristics);
            if (error == 16) {
                this.mBinder.del(wrappedKeyAlias, -1);
                error = this.importWrappedKeyInternal(wrappedKeyAlias, wrappedKey, wrappingKeyAlias, maskingKey, args, rootSid, fingerprintSid, outCharacteristics);
            }
            return error;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return 4;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "ImportWrappedKey completed with exception", e);
            return 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportResult exportKey(String alias, int format, KeymasterBlob clientId, KeymasterBlob appId, int uid) {
        ExportKeyPromise promise = new ExportKeyPromise();
        try {
            this.mBinder.asBinder().linkToDeath(promise, 0);
            clientId = clientId != null ? clientId : new KeymasterBlob(new byte[0]);
            appId = appId != null ? appId : new KeymasterBlob(new byte[0]);
            int error = this.mBinder.exportKey(promise, alias, format, clientId, appId, uid);
            if (error == 1) {
                ExportResult exportResult = KeyStore.interruptedPreservingGet(promise.getFuture());
                return exportResult;
            }
            ExportResult exportResult = new ExportResult(error);
            return exportResult;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            ExportResult exportResult = null;
            return exportResult;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "ExportKey completed with exception", e);
            ExportResult exportResult = null;
            return exportResult;
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
    }

    public ExportResult exportKey(String alias, int format, KeymasterBlob clientId, KeymasterBlob appId) {
        return this.exportKey(alias, format, clientId, appId, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult begin(String alias, int purpose, boolean pruneable, KeymasterArguments args, byte[] entropy, int uid) {
        OperationPromise promise = new OperationPromise();
        try {
            this.mBinder.asBinder().linkToDeath(promise, 0);
            args = args != null ? args : new KeymasterArguments();
            entropy = entropy != null ? entropy : new byte[]{};
            int errorCode = this.mBinder.begin(promise, this.getToken(), alias, purpose, pruneable, args, entropy, uid);
            if (errorCode == 1) {
                OperationResult operationResult = KeyStore.interruptedPreservingGet(promise.getFuture());
                return operationResult;
            }
            OperationResult operationResult = new OperationResult(errorCode);
            return operationResult;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            OperationResult operationResult = null;
            return operationResult;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "Begin completed with exception", e);
            OperationResult operationResult = null;
            return operationResult;
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
    }

    public OperationResult begin(String alias, int purpose, boolean pruneable, KeymasterArguments args, byte[] entropy) {
        entropy = entropy != null ? entropy : new byte[]{};
        args = args != null ? args : new KeymasterArguments();
        return this.begin(alias, purpose, pruneable, args, entropy, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult update(IBinder token, KeymasterArguments arguments, byte[] input) {
        OperationPromise promise = new OperationPromise();
        try {
            this.mBinder.asBinder().linkToDeath(promise, 0);
            arguments = arguments != null ? arguments : new KeymasterArguments();
            input = input != null ? input : new byte[]{};
            int errorCode = this.mBinder.update(promise, token, arguments, input);
            if (errorCode == 1) {
                OperationResult operationResult = KeyStore.interruptedPreservingGet(promise.getFuture());
                return operationResult;
            }
            OperationResult operationResult = new OperationResult(errorCode);
            return operationResult;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            OperationResult operationResult = null;
            return operationResult;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "Update completed with exception", e);
            OperationResult operationResult = null;
            return operationResult;
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult finish(IBinder token, KeymasterArguments arguments, byte[] input, byte[] signature, byte[] entropy) {
        OperationPromise promise = new OperationPromise();
        try {
            this.mBinder.asBinder().linkToDeath(promise, 0);
            arguments = arguments != null ? arguments : new KeymasterArguments();
            entropy = entropy != null ? entropy : new byte[]{};
            input = input != null ? input : new byte[]{};
            signature = signature != null ? signature : new byte[]{};
            int errorCode = this.mBinder.finish(promise, token, arguments, input, signature, entropy);
            if (errorCode == 1) {
                OperationResult operationResult = KeyStore.interruptedPreservingGet(promise.getFuture());
                return operationResult;
            }
            OperationResult operationResult = new OperationResult(errorCode);
            return operationResult;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            OperationResult operationResult = null;
            return operationResult;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "Finish completed with exception", e);
            OperationResult operationResult = null;
            return operationResult;
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
    }

    public OperationResult finish(IBinder token, KeymasterArguments arguments, byte[] signature) {
        return this.finish(token, arguments, null, signature, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int abort(IBinder token) {
        KeystoreResultPromise promise = new KeystoreResultPromise();
        try {
            this.mBinder.asBinder().linkToDeath(promise, 0);
            int errorCode = this.mBinder.abort(promise, token);
            if (errorCode == 1) {
                int n = KeyStore.interruptedPreservingGet(promise.getFuture()).getErrorCode();
                return n;
            }
            int n = errorCode;
            return n;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            int n = 4;
            return n;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "Abort completed with exception", e);
            int n = 4;
            return n;
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
    }

    public int addAuthToken(byte[] authToken) {
        try {
            return this.mBinder.addAuthToken(authToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return 4;
        }
    }

    public boolean onUserPasswordChanged(int userId, String newPassword) {
        if (newPassword == null) {
            newPassword = "";
        }
        try {
            return this.mBinder.onUserPasswordChanged(userId, newPassword) == 1;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return false;
        }
    }

    public void onUserAdded(int userId, int parentId) {
        try {
            this.mBinder.onUserAdded(userId, parentId);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
        }
    }

    public void onUserAdded(int userId) {
        this.onUserAdded(userId, -1);
    }

    public void onUserRemoved(int userId) {
        try {
            this.mBinder.onUserRemoved(userId);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
        }
    }

    public boolean onUserPasswordChanged(String newPassword) {
        return this.onUserPasswordChanged(UserHandle.getUserId(Process.myUid()), newPassword);
    }

    public void onUserLockedStateChanged(int userHandle, boolean locked) {
        try {
            this.mBinder.onKeyguardVisibilityChanged(locked, userHandle);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to update user locked state " + userHandle, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int attestKey(String alias, KeymasterArguments params, KeymasterCertificateChain outChain) {
        CertificateChainPromise promise = new CertificateChainPromise();
        try {
            int error;
            this.mBinder.asBinder().linkToDeath(promise, 0);
            if (params == null) {
                params = new KeymasterArguments();
            }
            if (outChain == null) {
                outChain = new KeymasterCertificateChain();
            }
            if ((error = this.mBinder.attestKey(promise, alias, params)) != 1) {
                int n = error;
                return n;
            }
            KeyAttestationCallbackResult result = KeyStore.interruptedPreservingGet(promise.getFuture());
            error = result.getKeystoreResponse().getErrorCode();
            if (error == 1) {
                outChain.shallowCopyFrom(result.getCertificateChain());
            }
            int n = error;
            return n;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            int n = 4;
            return n;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "AttestKey completed with exception", e);
            int n = 4;
            return n;
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int attestDeviceIds(KeymasterArguments params, KeymasterCertificateChain outChain) {
        CertificateChainPromise promise = new CertificateChainPromise();
        try {
            int error;
            this.mBinder.asBinder().linkToDeath(promise, 0);
            if (params == null) {
                params = new KeymasterArguments();
            }
            if (outChain == null) {
                outChain = new KeymasterCertificateChain();
            }
            if ((error = this.mBinder.attestDeviceIds(promise, params)) != 1) {
                int n = error;
                return n;
            }
            KeyAttestationCallbackResult result = KeyStore.interruptedPreservingGet(promise.getFuture());
            error = result.getKeystoreResponse().getErrorCode();
            if (error == 1) {
                outChain.shallowCopyFrom(result.getCertificateChain());
            }
            int n = error;
            return n;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            int n = 4;
            return n;
        }
        catch (ExecutionException e) {
            Log.e(TAG, "AttestDevicdeIds completed with exception", e);
            int n = 4;
            return n;
        }
        finally {
            this.mBinder.asBinder().unlinkToDeath(promise, 0);
        }
    }

    public void onDeviceOffBody() {
        try {
            this.mBinder.onDeviceOffBody();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
        }
    }

    public int presentConfirmationPrompt(IBinder listener, String promptText, byte[] extraData, String locale, int uiOptionsAsFlags) {
        try {
            return this.mBinder.presentConfirmationPrompt(listener, promptText, extraData, locale, uiOptionsAsFlags);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return 5;
        }
    }

    public int cancelConfirmationPrompt(IBinder listener) {
        try {
            return this.mBinder.cancelConfirmationPrompt(listener);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return 5;
        }
    }

    public boolean isConfirmationPromptSupported() {
        try {
            return this.mBinder.isConfirmationPromptSupported();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot connect to keystore", e);
            return false;
        }
    }

    @UnsupportedAppUsage
    public static KeyStoreException getKeyStoreException(int errorCode) {
        if (errorCode > 0) {
            switch (errorCode) {
                case 1: {
                    return new KeyStoreException(errorCode, "OK");
                }
                case 2: {
                    return new KeyStoreException(errorCode, "User authentication required");
                }
                case 3: {
                    return new KeyStoreException(errorCode, "Keystore not initialized");
                }
                case 4: {
                    return new KeyStoreException(errorCode, "System error");
                }
                case 6: {
                    return new KeyStoreException(errorCode, "Permission denied");
                }
                case 7: {
                    return new KeyStoreException(errorCode, "Key not found");
                }
                case 8: {
                    return new KeyStoreException(errorCode, "Key blob corrupted");
                }
                case 15: {
                    return new KeyStoreException(errorCode, "Operation requires authorization");
                }
                case 17: {
                    return new KeyStoreException(errorCode, "Key permanently invalidated");
                }
            }
            return new KeyStoreException(errorCode, String.valueOf(errorCode));
        }
        switch (errorCode) {
            case -16: {
                return new KeyStoreException(errorCode, "Invalid user authentication validity duration");
            }
        }
        return new KeyStoreException(errorCode, KeymasterDefs.getErrorMessage(errorCode));
    }

    public InvalidKeyException getInvalidKeyException(String keystoreKeyAlias, int uid, KeyStoreException e) {
        switch (e.getErrorCode()) {
            case 2: {
                return new UserNotAuthenticatedException();
            }
            case -25: {
                return new KeyExpiredException();
            }
            case -24: {
                return new KeyNotYetValidException();
            }
            case -26: 
            case 15: {
                KeyCharacteristics keyCharacteristics = new KeyCharacteristics();
                int getKeyCharacteristicsErrorCode = this.getKeyCharacteristics(keystoreKeyAlias, null, null, uid, keyCharacteristics);
                if (getKeyCharacteristicsErrorCode != 1) {
                    return new InvalidKeyException("Failed to obtained key characteristics", KeyStore.getKeyStoreException(getKeyCharacteristicsErrorCode));
                }
                List<BigInteger> keySids = keyCharacteristics.getUnsignedLongs(-1610612234);
                if (keySids.isEmpty()) {
                    return new KeyPermanentlyInvalidatedException();
                }
                long rootSid = GateKeeper.getSecureUserId();
                if (rootSid != 0L && keySids.contains(KeymasterArguments.toUint64(rootSid))) {
                    return new UserNotAuthenticatedException();
                }
                BiometricManager bm = this.mContext.getSystemService(BiometricManager.class);
                long[] biometricSids = bm.getAuthenticatorIds();
                boolean canUnlockViaBiometrics = true;
                for (long sid : biometricSids) {
                    if (keySids.contains(KeymasterArguments.toUint64(sid))) continue;
                    canUnlockViaBiometrics = false;
                    break;
                }
                if (canUnlockViaBiometrics) {
                    return new UserNotAuthenticatedException();
                }
                return new KeyPermanentlyInvalidatedException();
            }
            case 3: {
                return new KeyPermanentlyInvalidatedException();
            }
        }
        return new InvalidKeyException("Keystore operation failed", e);
    }

    public InvalidKeyException getInvalidKeyException(String keystoreKeyAlias, int uid, int errorCode) {
        return this.getInvalidKeyException(keystoreKeyAlias, uid, KeyStore.getKeyStoreException(errorCode));
    }

    private static <R> R interruptedPreservingGet(CompletableFuture<R> future) throws ExecutionException {
        boolean wasInterrupted = false;
        while (true) {
            try {
                R result = future.get();
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return result;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
    }

    private class CertificateChainPromise
    extends IKeystoreCertificateChainCallback.Stub
    implements IBinder.DeathRecipient {
        private final CompletableFuture<KeyAttestationCallbackResult> future = new CompletableFuture();

        private CertificateChainPromise() {
        }

        @Override
        public void onFinished(KeystoreResponse keystoreResponse, KeymasterCertificateChain certificateChain) throws RemoteException {
            this.future.complete(new KeyAttestationCallbackResult(keystoreResponse, certificateChain));
        }

        public CompletableFuture<KeyAttestationCallbackResult> getFuture() {
            return this.future;
        }

        @Override
        public void binderDied() {
            this.future.completeExceptionally(new RemoteException("Keystore died"));
        }
    }

    private class KeyAttestationCallbackResult {
        private KeystoreResponse keystoreResponse;
        private KeymasterCertificateChain certificateChain;

        public KeyAttestationCallbackResult(KeystoreResponse keystoreResponse, KeymasterCertificateChain certificateChain) {
            this.keystoreResponse = keystoreResponse;
            this.certificateChain = certificateChain;
        }

        public KeystoreResponse getKeystoreResponse() {
            return this.keystoreResponse;
        }

        public void setKeystoreResponse(KeystoreResponse keystoreResponse) {
            this.keystoreResponse = keystoreResponse;
        }

        public KeymasterCertificateChain getCertificateChain() {
            return this.certificateChain;
        }

        public void setCertificateChain(KeymasterCertificateChain certificateChain) {
            this.certificateChain = certificateChain;
        }
    }

    private class KeystoreResultPromise
    extends IKeystoreResponseCallback.Stub
    implements IBinder.DeathRecipient {
        private final CompletableFuture<KeystoreResponse> future = new CompletableFuture();

        private KeystoreResultPromise() {
        }

        @Override
        public void onFinished(KeystoreResponse keystoreResponse) throws RemoteException {
            this.future.complete(keystoreResponse);
        }

        public CompletableFuture<KeystoreResponse> getFuture() {
            return this.future;
        }

        @Override
        public void binderDied() {
            this.future.completeExceptionally(new RemoteException("Keystore died"));
        }
    }

    private class OperationPromise
    extends IKeystoreOperationResultCallback.Stub
    implements IBinder.DeathRecipient {
        private final CompletableFuture<OperationResult> future = new CompletableFuture();

        private OperationPromise() {
        }

        @Override
        public void onFinished(OperationResult operationResult) throws RemoteException {
            this.future.complete(operationResult);
        }

        public CompletableFuture<OperationResult> getFuture() {
            return this.future;
        }

        @Override
        public void binderDied() {
            this.future.completeExceptionally(new RemoteException("Keystore died"));
        }
    }

    private class ExportKeyPromise
    extends IKeystoreExportKeyCallback.Stub
    implements IBinder.DeathRecipient {
        private final CompletableFuture<ExportResult> future = new CompletableFuture();

        private ExportKeyPromise() {
        }

        @Override
        public void onFinished(ExportResult exportKeyResult) throws RemoteException {
            this.future.complete(exportKeyResult);
        }

        public CompletableFuture<ExportResult> getFuture() {
            return this.future;
        }

        @Override
        public void binderDied() {
            this.future.completeExceptionally(new RemoteException("Keystore died"));
        }
    }

    private class KeyCharacteristicsPromise
    extends IKeystoreKeyCharacteristicsCallback.Stub
    implements IBinder.DeathRecipient {
        private final CompletableFuture<KeyCharacteristicsCallbackResult> future = new CompletableFuture();

        private KeyCharacteristicsPromise() {
        }

        @Override
        public void onFinished(KeystoreResponse keystoreResponse, KeyCharacteristics keyCharacteristics) throws RemoteException {
            this.future.complete(new KeyCharacteristicsCallbackResult(keystoreResponse, keyCharacteristics));
        }

        public CompletableFuture<KeyCharacteristicsCallbackResult> getFuture() {
            return this.future;
        }

        @Override
        public void binderDied() {
            this.future.completeExceptionally(new RemoteException("Keystore died"));
        }
    }

    private class KeyCharacteristicsCallbackResult {
        private KeystoreResponse keystoreResponse;
        private KeyCharacteristics keyCharacteristics;

        public KeyCharacteristicsCallbackResult(KeystoreResponse keystoreResponse, KeyCharacteristics keyCharacteristics) {
            this.keystoreResponse = keystoreResponse;
            this.keyCharacteristics = keyCharacteristics;
        }

        public KeystoreResponse getKeystoreResponse() {
            return this.keystoreResponse;
        }

        public void setKeystoreResponse(KeystoreResponse keystoreResponse) {
            this.keystoreResponse = keystoreResponse;
        }

        public KeyCharacteristics getKeyCharacteristics() {
            return this.keyCharacteristics;
        }

        public void setKeyCharacteristics(KeyCharacteristics keyCharacteristics) {
            this.keyCharacteristics = keyCharacteristics;
        }
    }

    public static enum State {
        UNLOCKED,
        LOCKED,
        UNINITIALIZED;

    }
}

