/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.text.TextUtils;
import com.android.internal.telephony.util.TelephonyUtils;
import com.android.telephony.Rlog;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@SystemApi
public class CbGeoUtils {
    public static final double EPS = 1.0E-7;
    public static final int EARTH_RADIUS_METER = 6371000;
    private static final String TAG = "CbGeoUtils";
    public static final int GEO_FENCING_MAXIMUM_WAIT_TIME = 1;
    public static final int GEOMETRY_TYPE_POLYGON = 2;
    public static final int GEOMETRY_TYPE_CIRCLE = 3;
    private static final String CIRCLE_SYMBOL = "circle";
    private static final String POLYGON_SYMBOL = "polygon";

    private CbGeoUtils() {
    }

    public static List<Geometry> parseGeometriesFromString(String str) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        block8: for (String geometryStr : str.split("\\s*;\\s*")) {
            String[] geoParameters = geometryStr.split("\\s*\\|\\s*");
            switch (geoParameters[0]) {
                case "circle": {
                    geometries.add(new Circle(CbGeoUtils.parseLatLngFromString(geoParameters[1]), Double.parseDouble(geoParameters[2])));
                    continue block8;
                }
                case "polygon": {
                    ArrayList<LatLng> vertices = new ArrayList<LatLng>(geoParameters.length - 1);
                    for (int i = 1; i < geoParameters.length; ++i) {
                        vertices.add(CbGeoUtils.parseLatLngFromString(geoParameters[i]));
                    }
                    geometries.add(new Polygon(vertices));
                    continue block8;
                }
                default: {
                    Rlog.e(TAG, "Invalid geometry format " + geometryStr);
                }
            }
        }
        return geometries;
    }

    public static String encodeGeometriesToString(List<Geometry> geometries) {
        if (geometries == null || geometries.isEmpty()) {
            return "";
        }
        return geometries.stream().map(geometry -> CbGeoUtils.encodeGeometryToString(geometry)).filter(encodedStr -> !TextUtils.isEmpty(encodedStr)).collect(Collectors.joining(";"));
    }

    private static String encodeGeometryToString(Geometry geometry) {
        StringBuilder sb = new StringBuilder();
        if (geometry instanceof Polygon) {
            sb.append(POLYGON_SYMBOL);
            for (LatLng latLng : ((Polygon)geometry).getVertices()) {
                sb.append("|");
                sb.append(latLng.lat);
                sb.append(",");
                sb.append(latLng.lng);
            }
        } else if (geometry instanceof Circle) {
            sb.append(CIRCLE_SYMBOL);
            Circle circle = (Circle)geometry;
            sb.append("|");
            sb.append(circle.getCenter().lat);
            sb.append(",");
            sb.append(circle.getCenter().lng);
            sb.append("|");
            sb.append(circle.getRadius());
        } else {
            Rlog.e(TAG, "Unsupported geometry object " + geometry);
            return null;
        }
        return sb.toString();
    }

    public static LatLng parseLatLngFromString(String str) {
        String[] latLng = str.split("\\s*,\\s*");
        return new LatLng(Double.parseDouble(latLng[0]), Double.parseDouble(latLng[1]));
    }

    public static int sign(double value) {
        if (value > 1.0E-7) {
            return 1;
        }
        if (value < -1.0E-7) {
            return -1;
        }
        return 0;
    }

    public static class Circle
    implements Geometry {
        private final LatLng mCenter;
        private final double mRadiusMeter;

        public Circle(LatLng center, double radiusInMeters) {
            this.mCenter = center;
            this.mRadiusMeter = radiusInMeters;
        }

        public LatLng getCenter() {
            return this.mCenter;
        }

        public double getRadius() {
            return this.mRadiusMeter;
        }

        @Override
        public boolean contains(LatLng latLng) {
            return this.mCenter.distance(latLng) <= this.mRadiusMeter;
        }

        public String toString() {
            String str = "Circle: ";
            if (TelephonyUtils.IS_DEBUGGABLE) {
                str = str + this.mCenter + ", radius = " + this.mRadiusMeter;
            }
            return str;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Circle)) {
                return false;
            }
            Circle c = (Circle)o;
            return this.mCenter.equals(c.mCenter) && Double.compare(this.mRadiusMeter, c.mRadiusMeter) == 0;
        }
    }

    public static class Polygon
    implements Geometry {
        private static final double SCALE = 1000.0;
        private final List<LatLng> mVertices;
        private final List<Point> mScaledVertices;
        private final LatLng mOrigin;

        public Polygon(List<LatLng> vertices) {
            this.mVertices = vertices;
            int idx = 0;
            for (int i = 1; i < vertices.size(); ++i) {
                if (!(vertices.get((int)i).lng < vertices.get((int)idx).lng)) continue;
                idx = i;
            }
            this.mOrigin = vertices.get(idx);
            this.mScaledVertices = vertices.stream().map(latLng -> this.convertAndScaleLatLng((LatLng)latLng)).collect(Collectors.toList());
        }

        public List<LatLng> getVertices() {
            return this.mVertices;
        }

        @Override
        public boolean contains(LatLng latLng) {
            Point p = this.convertAndScaleLatLng(latLng);
            int n = this.mScaledVertices.size();
            int windingNumber = 0;
            for (int i = 0; i < n; ++i) {
                Point a = this.mScaledVertices.get(i);
                Point b = this.mScaledVertices.get((i + 1) % n);
                int ccw = CbGeoUtils.sign(Polygon.crossProduct(b.subtract(a), p.subtract(a)));
                if (ccw == 0) {
                    if (!(Math.min(a.x, b.x) <= p.x) || !(p.x <= Math.max(a.x, b.x)) || !(Math.min(a.y, b.y) <= p.y) || !(p.y <= Math.max(a.y, b.y))) continue;
                    return true;
                }
                if (CbGeoUtils.sign(a.y - p.y) <= 0) {
                    if (ccw <= 0 || CbGeoUtils.sign(b.y - p.y) <= 0) continue;
                    ++windingNumber;
                    continue;
                }
                if (ccw >= 0 || CbGeoUtils.sign(b.y - p.y) > 0) continue;
                --windingNumber;
            }
            return windingNumber != 0;
        }

        private Point convertAndScaleLatLng(LatLng latLng) {
            double distCross0thMeridian;
            double x = latLng.lat - this.mOrigin.lat;
            double y = latLng.lng - this.mOrigin.lng;
            if (CbGeoUtils.sign(this.mOrigin.lng) != 0 && CbGeoUtils.sign(this.mOrigin.lng) != CbGeoUtils.sign(latLng.lng) && CbGeoUtils.sign((distCross0thMeridian = Math.abs(this.mOrigin.lng) + Math.abs(latLng.lng)) * 2.0 - 360.0) > 0) {
                y = (double)CbGeoUtils.sign(this.mOrigin.lng) * (360.0 - distCross0thMeridian);
            }
            return new Point(x * 1000.0, y * 1000.0);
        }

        private static double crossProduct(Point a, Point b) {
            return a.x * b.y - a.y * b.x;
        }

        public String toString() {
            String str = "Polygon: ";
            if (TelephonyUtils.IS_DEBUGGABLE) {
                str = str + this.mVertices;
            }
            return str;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Polygon)) {
                return false;
            }
            Polygon p = (Polygon)o;
            if (this.mVertices.size() != p.mVertices.size()) {
                return false;
            }
            for (int i = 0; i < this.mVertices.size(); ++i) {
                if (this.mVertices.get(i).equals(p.mVertices.get(i))) continue;
                return false;
            }
            return true;
        }

        static class Point {
            public final double x;
            public final double y;

            Point(double x, double y) {
                this.x = x;
                this.y = y;
            }

            public Point subtract(Point p) {
                return new Point(this.x - p.x, this.y - p.y);
            }
        }
    }

    public static class LatLng {
        public final double lat;
        public final double lng;

        public LatLng(double lat, double lng) {
            this.lat = lat;
            this.lng = lng;
        }

        public LatLng subtract(LatLng p) {
            return new LatLng(this.lat - p.lat, this.lng - p.lng);
        }

        public double distance(LatLng p) {
            double dlat = Math.sin(0.5 * Math.toRadians(this.lat - p.lat));
            double dlng = Math.sin(0.5 * Math.toRadians(this.lng - p.lng));
            double x = dlat * dlat + dlng * dlng * Math.cos(Math.toRadians(this.lat)) * Math.cos(Math.toRadians(p.lat));
            return 2.0 * Math.atan2(Math.sqrt(x), Math.sqrt(1.0 - x)) * 6371000.0;
        }

        public String toString() {
            return "(" + this.lat + "," + this.lng + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LatLng)) {
                return false;
            }
            LatLng l = (LatLng)o;
            return this.lat == l.lat && this.lng == l.lng;
        }
    }

    public static interface Geometry {
        public boolean contains(LatLng var1);
    }
}

