/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.UserHandle;

public abstract class PackageChangeReceiver
extends BroadcastReceiver {
    static final IntentFilter sPackageIntentFilter = new IntentFilter();
    private static HandlerThread sHandlerThread;
    Context mRegisteredContext;

    public void register(Context context, Looper thread, UserHandle user) {
        if (this.mRegisteredContext != null) {
            throw new IllegalStateException("Already registered");
        }
        Handler handler = new Handler(thread == null ? PackageChangeReceiver.getStaticLooper() : thread);
        this.mRegisteredContext = user == null ? context : context.createContextAsUser(user, 0);
        this.mRegisteredContext.registerReceiver(this, sPackageIntentFilter, null, handler);
    }

    public void unregister() {
        if (this.mRegisteredContext == null) {
            throw new IllegalStateException("Not registered");
        }
        this.mRegisteredContext.unregisterReceiver(this);
        this.mRegisteredContext = null;
    }

    private static synchronized Looper getStaticLooper() {
        if (sHandlerThread == null) {
            sHandlerThread = new HandlerThread(PackageChangeReceiver.class.getSimpleName());
            sHandlerThread.start();
        }
        return sHandlerThread.getLooper();
    }

    public void onPackageAdded(String packageName) {
    }

    public void onPackageRemoved(String packageName) {
    }

    public void onPackageUpdateFinished(String packageName) {
    }

    public void onPackageModified(String packageName) {
    }

    public void onHandleForceStop(String[] packages, boolean doit) {
    }

    public void onPackageDisappeared() {
    }

    public void onPackageAppeared() {
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
            String pkg = this.getPackageName(intent);
            if (pkg != null) {
                if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    this.onPackageUpdateFinished(pkg);
                    this.onPackageModified(pkg);
                } else {
                    this.onPackageAdded(pkg);
                }
                this.onPackageAppeared();
            }
        } else if ("android.intent.action.PACKAGE_REMOVED".equals(action)) {
            String pkg = this.getPackageName(intent);
            if (pkg != null) {
                if (!intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    this.onPackageRemoved(pkg);
                }
                this.onPackageDisappeared();
            }
        } else if ("android.intent.action.PACKAGE_CHANGED".equals(action)) {
            String pkg = this.getPackageName(intent);
            if (pkg != null) {
                this.onPackageModified(pkg);
            }
        } else if ("android.intent.action.QUERY_PACKAGE_RESTART".equals(action)) {
            String[] disappearingPackages = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
            this.onHandleForceStop(disappearingPackages, false);
        } else if ("android.intent.action.PACKAGE_RESTARTED".equals(action)) {
            String[] disappearingPackages = new String[]{this.getPackageName(intent)};
            this.onHandleForceStop(disappearingPackages, true);
        }
    }

    String getPackageName(Intent intent) {
        Uri uri = intent.getData();
        String pkg = uri != null ? uri.getSchemeSpecificPart() : null;
        return pkg;
    }

    static {
        sPackageIntentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        sPackageIntentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        sPackageIntentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        sPackageIntentFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        sPackageIntentFilter.addAction("android.intent.action.PACKAGE_RESTARTED");
        sPackageIntentFilter.addDataScheme("package");
    }
}

