/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.content.ContentValues;
import android.database.Cursor;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CbGeoUtils;
import android.telephony.SmsCbCmasInfo;
import android.telephony.SmsCbEtwsInfo;
import android.telephony.SmsCbLocation;
import com.android.internal.lang.System_Delegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public class SmsCbMessage
implements Parcelable {
    public static final String LOG_TAG = "SMSCB";
    public static final int GEOGRAPHICAL_SCOPE_CELL_WIDE_IMMEDIATE = 0;
    public static final int GEOGRAPHICAL_SCOPE_PLMN_WIDE = 1;
    public static final int GEOGRAPHICAL_SCOPE_LOCATION_AREA_WIDE = 2;
    public static final int GEOGRAPHICAL_SCOPE_CELL_WIDE = 3;
    public static final int MESSAGE_FORMAT_3GPP = 1;
    public static final int MESSAGE_FORMAT_3GPP2 = 2;
    public static final int MESSAGE_PRIORITY_NORMAL = 0;
    public static final int MESSAGE_PRIORITY_INTERACTIVE = 1;
    public static final int MESSAGE_PRIORITY_URGENT = 2;
    public static final int MESSAGE_PRIORITY_EMERGENCY = 3;
    public static final int MAXIMUM_WAIT_TIME_NOT_SET = 255;
    private final int mMessageFormat;
    private final int mGeographicalScope;
    private final int mSerialNumber;
    private final SmsCbLocation mLocation;
    private final int mServiceCategory;
    private final String mLanguage;
    private final int mDataCodingScheme;
    private final String mBody;
    private final int mPriority;
    private final SmsCbEtwsInfo mEtwsWarningInfo;
    private final SmsCbCmasInfo mCmasWarningInfo;
    private final int mMaximumWaitTimeSec;
    private final long mReceivedTimeMillis;
    private final List<CbGeoUtils.Geometry> mGeometries;
    private final int mSlotIndex;
    private final int mSubId;
    public static final Parcelable.Creator<SmsCbMessage> CREATOR = new Parcelable.Creator<SmsCbMessage>(){

        @Override
        public SmsCbMessage createFromParcel(Parcel in) {
            return new SmsCbMessage(in);
        }

        public SmsCbMessage[] newArray(int size) {
            return new SmsCbMessage[size];
        }
    };

    public SmsCbMessage(int messageFormat, int geographicalScope, int serialNumber, SmsCbLocation location, int serviceCategory, String language, String body, int priority, SmsCbEtwsInfo etwsWarningInfo, SmsCbCmasInfo cmasWarningInfo, int slotIndex, int subId) {
        this(messageFormat, geographicalScope, serialNumber, location, serviceCategory, language, 0, body, priority, etwsWarningInfo, cmasWarningInfo, 0, null, System_Delegate.currentTimeMillis(), slotIndex, subId);
    }

    public SmsCbMessage(int messageFormat, int geographicalScope, int serialNumber, SmsCbLocation location, int serviceCategory, String language, int dataCodingScheme, String body, int priority, SmsCbEtwsInfo etwsWarningInfo, SmsCbCmasInfo cmasWarningInfo, int maximumWaitTimeSec, List<CbGeoUtils.Geometry> geometries, long receivedTimeMillis, int slotIndex, int subId) {
        this.mMessageFormat = messageFormat;
        this.mGeographicalScope = geographicalScope;
        this.mSerialNumber = serialNumber;
        this.mLocation = location;
        this.mServiceCategory = serviceCategory;
        this.mLanguage = language;
        this.mDataCodingScheme = dataCodingScheme;
        this.mBody = body;
        this.mPriority = priority;
        this.mEtwsWarningInfo = etwsWarningInfo;
        this.mCmasWarningInfo = cmasWarningInfo;
        this.mReceivedTimeMillis = receivedTimeMillis;
        this.mGeometries = geometries;
        this.mMaximumWaitTimeSec = maximumWaitTimeSec;
        this.mSlotIndex = slotIndex;
        this.mSubId = subId;
    }

    public SmsCbMessage(Parcel in) {
        this.mMessageFormat = in.readInt();
        this.mGeographicalScope = in.readInt();
        this.mSerialNumber = in.readInt();
        this.mLocation = new SmsCbLocation(in);
        this.mServiceCategory = in.readInt();
        this.mLanguage = in.readString();
        this.mDataCodingScheme = in.readInt();
        this.mBody = in.readString();
        this.mPriority = in.readInt();
        int type = in.readInt();
        switch (type) {
            case 69: {
                this.mEtwsWarningInfo = new SmsCbEtwsInfo(in);
                this.mCmasWarningInfo = null;
                break;
            }
            case 67: {
                this.mEtwsWarningInfo = null;
                this.mCmasWarningInfo = new SmsCbCmasInfo(in);
                break;
            }
            default: {
                this.mEtwsWarningInfo = null;
                this.mCmasWarningInfo = null;
            }
        }
        this.mReceivedTimeMillis = in.readLong();
        String geoStr = in.readString();
        this.mGeometries = geoStr != null ? CbGeoUtils.parseGeometriesFromString(geoStr) : null;
        this.mMaximumWaitTimeSec = in.readInt();
        this.mSlotIndex = in.readInt();
        this.mSubId = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMessageFormat);
        dest.writeInt(this.mGeographicalScope);
        dest.writeInt(this.mSerialNumber);
        this.mLocation.writeToParcel(dest, flags);
        dest.writeInt(this.mServiceCategory);
        dest.writeString(this.mLanguage);
        dest.writeInt(this.mDataCodingScheme);
        dest.writeString(this.mBody);
        dest.writeInt(this.mPriority);
        if (this.mEtwsWarningInfo != null) {
            dest.writeInt(69);
            this.mEtwsWarningInfo.writeToParcel(dest, flags);
        } else if (this.mCmasWarningInfo != null) {
            dest.writeInt(67);
            this.mCmasWarningInfo.writeToParcel(dest, flags);
        } else {
            dest.writeInt(48);
        }
        dest.writeLong(this.mReceivedTimeMillis);
        dest.writeString(this.mGeometries != null ? CbGeoUtils.encodeGeometriesToString(this.mGeometries) : null);
        dest.writeInt(this.mMaximumWaitTimeSec);
        dest.writeInt(this.mSlotIndex);
        dest.writeInt(this.mSubId);
    }

    public int getGeographicalScope() {
        return this.mGeographicalScope;
    }

    public int getSerialNumber() {
        return this.mSerialNumber;
    }

    public SmsCbLocation getLocation() {
        return this.mLocation;
    }

    public int getServiceCategory() {
        return this.mServiceCategory;
    }

    public String getLanguageCode() {
        return this.mLanguage;
    }

    public int getDataCodingScheme() {
        return this.mDataCodingScheme;
    }

    public String getMessageBody() {
        return this.mBody;
    }

    @SystemApi
    public List<CbGeoUtils.Geometry> getGeometries() {
        if (this.mGeometries == null) {
            return new ArrayList<CbGeoUtils.Geometry>();
        }
        return this.mGeometries;
    }

    public int getMaximumWaitingDuration() {
        return this.mMaximumWaitTimeSec;
    }

    public long getReceivedTime() {
        return this.mReceivedTimeMillis;
    }

    public int getSlotIndex() {
        return this.mSlotIndex;
    }

    public int getSubscriptionId() {
        return this.mSubId;
    }

    public int getMessageFormat() {
        return this.mMessageFormat;
    }

    public int getMessagePriority() {
        return this.mPriority;
    }

    public SmsCbEtwsInfo getEtwsWarningInfo() {
        return this.mEtwsWarningInfo;
    }

    public SmsCbCmasInfo getCmasWarningInfo() {
        return this.mCmasWarningInfo;
    }

    public boolean isEmergencyMessage() {
        return this.mPriority == 3;
    }

    public boolean isEtwsMessage() {
        return this.mEtwsWarningInfo != null;
    }

    public boolean isCmasMessage() {
        return this.mCmasWarningInfo != null;
    }

    public String toString() {
        return "SmsCbMessage{geographicalScope=" + this.mGeographicalScope + ", serialNumber=" + this.mSerialNumber + ", location=" + this.mLocation + ", serviceCategory=" + this.mServiceCategory + ", language=" + this.mLanguage + ", body=" + this.mBody + ", priority=" + this.mPriority + (this.mEtwsWarningInfo != null ? ", " + this.mEtwsWarningInfo.toString() : "") + (this.mCmasWarningInfo != null ? ", " + this.mCmasWarningInfo.toString() : "") + ", maximumWaitingTime=" + this.mMaximumWaitTimeSec + ", received time=" + this.mReceivedTimeMillis + ", slotIndex = " + this.mSlotIndex + ", geo=" + (this.mGeometries != null ? CbGeoUtils.encodeGeometriesToString(this.mGeometries) : "null") + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public ContentValues getContentValues() {
        SmsCbCmasInfo cmasInfo;
        ContentValues cv = new ContentValues(16);
        cv.put("slot_index", this.mSlotIndex);
        cv.put("sub_id", this.mSubId);
        cv.put("geo_scope", this.mGeographicalScope);
        if (this.mLocation.getPlmn() != null) {
            cv.put("plmn", this.mLocation.getPlmn());
        }
        if (this.mLocation.getLac() != -1) {
            cv.put("lac", this.mLocation.getLac());
        }
        if (this.mLocation.getCid() != -1) {
            cv.put("cid", this.mLocation.getCid());
        }
        cv.put("serial_number", this.getSerialNumber());
        cv.put("service_category", this.getServiceCategory());
        cv.put("language", this.getLanguageCode());
        cv.put("dcs", this.getDataCodingScheme());
        cv.put("body", this.getMessageBody());
        cv.put("format", this.getMessageFormat());
        cv.put("priority", this.getMessagePriority());
        SmsCbEtwsInfo etwsInfo = this.getEtwsWarningInfo();
        if (etwsInfo != null) {
            cv.put("etws_warning_type", etwsInfo.getWarningType());
            cv.put("etws_is_primary", etwsInfo.isPrimary());
        }
        if ((cmasInfo = this.getCmasWarningInfo()) != null) {
            cv.put("cmas_message_class", cmasInfo.getMessageClass());
            cv.put("cmas_category", cmasInfo.getCategory());
            cv.put("cmas_response_type", cmasInfo.getResponseType());
            cv.put("cmas_severity", cmasInfo.getSeverity());
            cv.put("cmas_urgency", cmasInfo.getUrgency());
            cv.put("cmas_certainty", cmasInfo.getCertainty());
        }
        cv.put("received_time", this.mReceivedTimeMillis);
        if (this.mGeometries != null) {
            cv.put("geometries", CbGeoUtils.encodeGeometriesToString(this.mGeometries));
        } else {
            cv.put("geometries", (String)null);
        }
        cv.put("maximum_wait_time", this.mMaximumWaitTimeSec);
        return cv;
    }

    public static SmsCbMessage createFromCursor(Cursor cursor) {
        String geoStr;
        SmsCbEtwsInfo etwsInfo;
        int geoScope = cursor.getInt(cursor.getColumnIndexOrThrow("geo_scope"));
        int serialNum = cursor.getInt(cursor.getColumnIndexOrThrow("serial_number"));
        int category = cursor.getInt(cursor.getColumnIndexOrThrow("service_category"));
        String language = cursor.getString(cursor.getColumnIndexOrThrow("language"));
        String body = cursor.getString(cursor.getColumnIndexOrThrow("body"));
        int format = cursor.getInt(cursor.getColumnIndexOrThrow("format"));
        int priority = cursor.getInt(cursor.getColumnIndexOrThrow("priority"));
        int slotIndex = cursor.getInt(cursor.getColumnIndexOrThrow("slot_index"));
        int subId = cursor.getInt(cursor.getColumnIndexOrThrow("sub_id"));
        int plmnColumn = cursor.getColumnIndex("plmn");
        String plmn = plmnColumn != -1 && !cursor.isNull(plmnColumn) ? cursor.getString(plmnColumn) : null;
        int lacColumn = cursor.getColumnIndex("lac");
        int lac = lacColumn != -1 && !cursor.isNull(lacColumn) ? cursor.getInt(lacColumn) : -1;
        int cidColumn = cursor.getColumnIndex("cid");
        int cid = cidColumn != -1 && !cursor.isNull(cidColumn) ? cursor.getInt(cidColumn) : -1;
        SmsCbLocation location = new SmsCbLocation(plmn, lac, cid);
        int etwsWarningTypeColumn = cursor.getColumnIndex("etws_warning_type");
        int etwsIsPrimaryColumn = cursor.getColumnIndex("etws_is_primary");
        if (etwsWarningTypeColumn != -1 && !cursor.isNull(etwsWarningTypeColumn) && etwsIsPrimaryColumn != -1 && !cursor.isNull(etwsIsPrimaryColumn)) {
            int warningType = cursor.getInt(etwsWarningTypeColumn);
            boolean isPrimary = cursor.getInt(etwsIsPrimaryColumn) != 0;
            etwsInfo = new SmsCbEtwsInfo(warningType, false, false, isPrimary, null);
        } else {
            etwsInfo = null;
        }
        SmsCbCmasInfo cmasInfo = null;
        int cmasMessageClassColumn = cursor.getColumnIndex("cmas_message_class");
        if (cmasMessageClassColumn != -1 && !cursor.isNull(cmasMessageClassColumn)) {
            int messageClass = cursor.getInt(cmasMessageClassColumn);
            int cmasCategoryColumn = cursor.getColumnIndex("cmas_category");
            int cmasCategory = cmasCategoryColumn != -1 && !cursor.isNull(cmasCategoryColumn) ? cursor.getInt(cmasCategoryColumn) : -1;
            int cmasResponseTypeColumn = cursor.getColumnIndex("cmas_response_type");
            int responseType = cmasResponseTypeColumn != -1 && !cursor.isNull(cmasResponseTypeColumn) ? cursor.getInt(cmasResponseTypeColumn) : -1;
            int cmasSeverityColumn = cursor.getColumnIndex("cmas_severity");
            int severity = cmasSeverityColumn != -1 && !cursor.isNull(cmasSeverityColumn) ? cursor.getInt(cmasSeverityColumn) : -1;
            int cmasUrgencyColumn = cursor.getColumnIndex("cmas_urgency");
            int urgency = cmasUrgencyColumn != -1 && !cursor.isNull(cmasUrgencyColumn) ? cursor.getInt(cmasUrgencyColumn) : -1;
            int cmasCertaintyColumn = cursor.getColumnIndex("cmas_certainty");
            int certainty = cmasCertaintyColumn != -1 && !cursor.isNull(cmasCertaintyColumn) ? cursor.getInt(cmasCertaintyColumn) : -1;
            cmasInfo = new SmsCbCmasInfo(messageClass, cmasCategory, responseType, severity, urgency, certainty);
        }
        List<CbGeoUtils.Geometry> geometries = (geoStr = cursor.getString(cursor.getColumnIndex("geometries"))) != null ? CbGeoUtils.parseGeometriesFromString(geoStr) : null;
        long receivedTimeMillis = cursor.getLong(cursor.getColumnIndexOrThrow("received_time"));
        int maximumWaitTimeSec = cursor.getInt(cursor.getColumnIndexOrThrow("maximum_wait_time"));
        return new SmsCbMessage(format, geoScope, serialNum, location, category, language, 0, body, priority, etwsInfo, cmasInfo, maximumWaitTimeSec, geometries, receivedTimeMillis, slotIndex, subId);
    }

    public boolean needGeoFencingCheck() {
        return this.mMaximumWaitTimeSec > 0 && this.mGeometries != null && !this.mGeometries.isEmpty();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessagePriority {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessageFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GeographicalScope {
    }
}

