/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.RcsContactUceCapability;
import java.util.ArrayList;
import java.util.List;

public interface IRcsFeatureListener
extends IInterface {
    public void onCommandUpdate(int var1, int var2) throws RemoteException;

    public void onNetworkResponse(int var1, String var2, int var3) throws RemoteException;

    public void onCapabilityRequestResponsePresence(List<RcsContactUceCapability> var1, int var2) throws RemoteException;

    public void onNotifyUpdateCapabilities(int var1) throws RemoteException;

    public void onUnpublish() throws RemoteException;

    public void onCapabilityRequestResponseOptions(int var1, String var2, RcsContactUceCapability var3, int var4) throws RemoteException;

    public void onRemoteCapabilityRequest(Uri var1, RcsContactUceCapability var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRcsFeatureListener {
        private static final String DESCRIPTOR = "android.telephony.ims.aidl.IRcsFeatureListener";
        static final int TRANSACTION_onCommandUpdate = 1;
        static final int TRANSACTION_onNetworkResponse = 2;
        static final int TRANSACTION_onCapabilityRequestResponsePresence = 3;
        static final int TRANSACTION_onNotifyUpdateCapabilities = 4;
        static final int TRANSACTION_onUnpublish = 5;
        static final int TRANSACTION_onCapabilityRequestResponseOptions = 6;
        static final int TRANSACTION_onRemoteCapabilityRequest = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRcsFeatureListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRcsFeatureListener) {
                return (IRcsFeatureListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCommandUpdate";
                }
                case 2: {
                    return "onNetworkResponse";
                }
                case 3: {
                    return "onCapabilityRequestResponsePresence";
                }
                case 4: {
                    return "onNotifyUpdateCapabilities";
                }
                case 5: {
                    return "onUnpublish";
                }
                case 6: {
                    return "onCapabilityRequestResponseOptions";
                }
                case 7: {
                    return "onRemoteCapabilityRequest";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onCommandUpdate(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.onNetworkResponse(_arg0, _arg1, _arg2);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ArrayList<RcsContactUceCapability> _arg0 = data.createTypedArrayList(RcsContactUceCapability.CREATOR);
                    int _arg1 = data.readInt();
                    this.onCapabilityRequestResponsePresence(_arg0, _arg1);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onNotifyUpdateCapabilities(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.onUnpublish();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    RcsContactUceCapability _arg2 = 0 != data.readInt() ? RcsContactUceCapability.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.onCapabilityRequestResponseOptions(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    Uri _arg0 = 0 != data.readInt() ? Uri.CREATOR.createFromParcel(data) : null;
                    RcsContactUceCapability _arg1 = 0 != data.readInt() ? RcsContactUceCapability.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.onRemoteCapabilityRequest(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IRcsFeatureListener impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IRcsFeatureListener getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IRcsFeatureListener {
            private IBinder mRemote;
            public static IRcsFeatureListener sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCommandUpdate(int commandCode, int operationToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(commandCode);
                    _data.writeInt(operationToken);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCommandUpdate(commandCode, operationToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNetworkResponse(int code, String reason, int operationToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeString(reason);
                    _data.writeInt(operationToken);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNetworkResponse(code, reason, operationToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCapabilityRequestResponsePresence(List<RcsContactUceCapability> infos, int operationToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(infos);
                    _data.writeInt(operationToken);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCapabilityRequestResponsePresence(infos, operationToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotifyUpdateCapabilities(int publishTriggerType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(publishTriggerType);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotifyUpdateCapabilities(publishTriggerType);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onUnpublish() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onUnpublish();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCapabilityRequestResponseOptions(int code, String reason, RcsContactUceCapability info, int operationToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeString(reason);
                    if (info != null) {
                        _data.writeInt(1);
                        info.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(operationToken);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCapabilityRequestResponseOptions(code, reason, info, operationToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoteCapabilityRequest(Uri contactUri, RcsContactUceCapability remoteInfo, int operationToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (contactUri != null) {
                        _data.writeInt(1);
                        contactUri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (remoteInfo != null) {
                        _data.writeInt(1);
                        remoteInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(operationToken);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRemoteCapabilityRequest(contactUri, remoteInfo, operationToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRcsFeatureListener {
        @Override
        public void onCommandUpdate(int commandCode, int operationToken) throws RemoteException {
        }

        @Override
        public void onNetworkResponse(int code, String reason, int operationToken) throws RemoteException {
        }

        @Override
        public void onCapabilityRequestResponsePresence(List<RcsContactUceCapability> infos, int operationToken) throws RemoteException {
        }

        @Override
        public void onNotifyUpdateCapabilities(int publishTriggerType) throws RemoteException {
        }

        @Override
        public void onUnpublish() throws RemoteException {
        }

        @Override
        public void onCapabilityRequestResponseOptions(int code, String reason, RcsContactUceCapability info, int operationToken) throws RemoteException {
        }

        @Override
        public void onRemoteCapabilityRequest(Uri contactUri, RcsContactUceCapability remoteInfo, int operationToken) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

