/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.compat.annotation.UnsupportedAppUsage;
import android.text.NoCopySpan;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.lang.reflect.Array;
import libcore.util.EmptyArray;

abstract class SpannableStringInternal {
    @UnsupportedAppUsage
    private String mText;
    @UnsupportedAppUsage
    private Object[] mSpans;
    @UnsupportedAppUsage
    private int[] mSpanData;
    @UnsupportedAppUsage
    private int mSpanCount;
    @UnsupportedAppUsage
    static final Object[] EMPTY = new Object[0];
    @UnsupportedAppUsage
    private static final int START = 0;
    @UnsupportedAppUsage
    private static final int END = 1;
    @UnsupportedAppUsage
    private static final int FLAGS = 2;
    @UnsupportedAppUsage
    private static final int COLUMNS = 3;

    SpannableStringInternal(CharSequence source, int start, int end, boolean ignoreNoCopySpan) {
        this.mText = start == 0 && end == source.length() ? source.toString() : source.toString().substring(start, end);
        this.mSpans = EmptyArray.OBJECT;
        this.mSpanData = EmptyArray.INT;
        if (source instanceof Spanned) {
            if (source instanceof SpannableStringInternal) {
                this.copySpansFromInternal((SpannableStringInternal)((Object)source), start, end, ignoreNoCopySpan);
            } else {
                this.copySpansFromSpanned((Spanned)source, start, end, ignoreNoCopySpan);
            }
        }
    }

    @UnsupportedAppUsage
    SpannableStringInternal(CharSequence source, int start, int end) {
        this(source, start, end, false);
    }

    private void copySpansFromSpanned(Spanned src, int start, int end, boolean ignoreNoCopySpan) {
        Object[] spans = src.getSpans(start, end, Object.class);
        for (int i = 0; i < spans.length; ++i) {
            if (ignoreNoCopySpan && spans[i] instanceof NoCopySpan) continue;
            int st = src.getSpanStart(spans[i]);
            int en = src.getSpanEnd(spans[i]);
            int fl = src.getSpanFlags(spans[i]);
            if (st < start) {
                st = start;
            }
            if (en > end) {
                en = end;
            }
            this.setSpan(spans[i], st - start, en - start, fl, false);
        }
    }

    private void copySpansFromInternal(SpannableStringInternal src, int start, int end, boolean ignoreNoCopySpan) {
        int i;
        int count = 0;
        int[] srcData = src.mSpanData;
        Object[] srcSpans = src.mSpans;
        int limit = src.mSpanCount;
        boolean hasNoCopySpan = false;
        for (i = 0; i < limit; ++i) {
            int spanStart = srcData[i * 3 + 0];
            int spanEnd = srcData[i * 3 + 1];
            if (this.isOutOfCopyRange(start, end, spanStart, spanEnd)) continue;
            if (srcSpans[i] instanceof NoCopySpan) {
                hasNoCopySpan = true;
                if (ignoreNoCopySpan) continue;
            }
            ++count;
        }
        if (count == 0) {
            return;
        }
        if (!hasNoCopySpan && start == 0 && end == src.length()) {
            this.mSpans = ArrayUtils.newUnpaddedObjectArray(src.mSpans.length);
            this.mSpanData = new int[src.mSpanData.length];
            this.mSpanCount = src.mSpanCount;
            System.arraycopy(src.mSpans, 0, this.mSpans, 0, src.mSpans.length);
            System.arraycopy(src.mSpanData, 0, this.mSpanData, 0, this.mSpanData.length);
        } else {
            this.mSpanCount = count;
            this.mSpans = ArrayUtils.newUnpaddedObjectArray(this.mSpanCount);
            this.mSpanData = new int[this.mSpans.length * 3];
            int j = 0;
            for (i = 0; i < limit; ++i) {
                int spanStart = srcData[i * 3 + 0];
                int spanEnd = srcData[i * 3 + 1];
                if (this.isOutOfCopyRange(start, end, spanStart, spanEnd) || ignoreNoCopySpan && srcSpans[i] instanceof NoCopySpan) continue;
                if (spanStart < start) {
                    spanStart = start;
                }
                if (spanEnd > end) {
                    spanEnd = end;
                }
                this.mSpans[j] = srcSpans[i];
                this.mSpanData[j * 3 + 0] = spanStart - start;
                this.mSpanData[j * 3 + 1] = spanEnd - start;
                this.mSpanData[j * 3 + 2] = srcData[i * 3 + 2];
                ++j;
            }
        }
    }

    @UnsupportedAppUsage
    private boolean isOutOfCopyRange(int start, int end, int spanStart, int spanEnd) {
        if (spanStart > end || spanEnd < start) {
            return true;
        }
        return spanStart != spanEnd && start != end && (spanStart == end || spanEnd == start);
    }

    public int length() {
        return this.mText.length();
    }

    public char charAt(int i) {
        return this.mText.charAt(i);
    }

    public String toString() {
        return this.mText;
    }

    public void getChars(int start, int end, char[] dest, int off) {
        this.mText.getChars(start, end, dest, off);
    }

    @UnsupportedAppUsage
    void setSpan(Object what, int start, int end, int flags) {
        this.setSpan(what, start, end, flags, true);
    }

    @UnsupportedAppUsage
    private boolean isIndexFollowsNextLine(int index) {
        return index != 0 && index != this.length() && this.charAt(index - 1) != '\n';
    }

    @UnsupportedAppUsage
    private void setSpan(Object what, int start, int end, int flags, boolean enforceParagraph) {
        int nstart = start;
        int nend = end;
        this.checkRange("setSpan", start, end);
        if ((flags & 0x33) == 51) {
            if (this.isIndexFollowsNextLine(start)) {
                if (!enforceParagraph) {
                    return;
                }
                throw new RuntimeException("PARAGRAPH span must start at paragraph boundary (" + start + " follows " + this.charAt(start - 1) + ")");
            }
            if (this.isIndexFollowsNextLine(end)) {
                if (!enforceParagraph) {
                    return;
                }
                throw new RuntimeException("PARAGRAPH span must end at paragraph boundary (" + end + " follows " + this.charAt(end - 1) + ")");
            }
        }
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = 0; i < count; ++i) {
            if (spans[i] != what) continue;
            int ostart = data[i * 3 + 0];
            int oend = data[i * 3 + 1];
            data[i * 3 + 0] = start;
            data[i * 3 + 1] = end;
            data[i * 3 + 2] = flags;
            this.sendSpanChanged(what, ostart, oend, nstart, nend);
            return;
        }
        if (this.mSpanCount + 1 >= this.mSpans.length) {
            Object[] newtags = ArrayUtils.newUnpaddedObjectArray(GrowingArrayUtils.growSize(this.mSpanCount));
            int[] newdata = new int[newtags.length * 3];
            System.arraycopy(this.mSpans, 0, newtags, 0, this.mSpanCount);
            System.arraycopy(this.mSpanData, 0, newdata, 0, this.mSpanCount * 3);
            this.mSpans = newtags;
            this.mSpanData = newdata;
        }
        this.mSpans[this.mSpanCount] = what;
        this.mSpanData[this.mSpanCount * 3 + 0] = start;
        this.mSpanData[this.mSpanCount * 3 + 1] = end;
        this.mSpanData[this.mSpanCount * 3 + 2] = flags;
        ++this.mSpanCount;
        if (this instanceof Spannable) {
            this.sendSpanAdded(what, nstart, nend);
        }
    }

    @UnsupportedAppUsage
    void removeSpan(Object what) {
        this.removeSpan(what, 0);
    }

    public void removeSpan(Object what, int flags) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            int ostart = data[i * 3 + 0];
            int oend = data[i * 3 + 1];
            int c = count - (i + 1);
            System.arraycopy(spans, i + 1, spans, i, c);
            System.arraycopy(data, (i + 1) * 3, data, i * 3, c * 3);
            --this.mSpanCount;
            if ((flags & 0x200) == 0) {
                this.sendSpanRemoved(what, ostart, oend);
            }
            return;
        }
    }

    @UnsupportedAppUsage
    public int getSpanStart(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 0];
        }
        return -1;
    }

    @UnsupportedAppUsage
    public int getSpanEnd(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 1];
        }
        return -1;
    }

    @UnsupportedAppUsage
    public int getSpanFlags(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 2];
        }
        return 0;
    }

    @UnsupportedAppUsage
    public <T> T[] getSpans(int queryStart, int queryEnd, Class<T> kind) {
        int count = 0;
        int spanCount = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        Object[] ret = null;
        Object ret1 = null;
        for (int i = 0; i < spanCount; ++i) {
            int prio;
            int spanStart = data[i * 3 + 0];
            int spanEnd = data[i * 3 + 1];
            if (spanStart > queryEnd || spanEnd < queryStart || spanStart != spanEnd && queryStart != queryEnd && (spanStart == queryEnd || spanEnd == queryStart) || kind != null && kind != Object.class && !kind.isInstance(spans[i])) continue;
            if (count == 0) {
                ret1 = spans[i];
                ++count;
                continue;
            }
            if (count == 1) {
                ret = (Object[])Array.newInstance(kind, spanCount - i + 1);
                ret[0] = ret1;
            }
            if ((prio = data[i * 3 + 2] & 0xFF0000) != 0) {
                int p;
                int j;
                for (j = 0; j < count && prio <= (p = this.getSpanFlags(ret[j]) & 0xFF0000); ++j) {
                }
                System.arraycopy(ret, j, ret, j + 1, count - j);
                ret[j] = spans[i];
                ++count;
                continue;
            }
            ret[count++] = spans[i];
        }
        if (count == 0) {
            return ArrayUtils.emptyArray(kind);
        }
        if (count == 1) {
            ret = (Object[])Array.newInstance(kind, 1);
            ret[0] = ret1;
            return ret;
        }
        if (count == ret.length) {
            return ret;
        }
        Object[] nret = (Object[])Array.newInstance(kind, count);
        System.arraycopy(ret, 0, nret, 0, count);
        return nret;
    }

    @UnsupportedAppUsage
    public int nextSpanTransition(int start, int limit, Class kind) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        if (kind == null) {
            kind = Object.class;
        }
        for (int i = 0; i < count; ++i) {
            int st = data[i * 3 + 0];
            int en = data[i * 3 + 1];
            if (st > start && st < limit && kind.isInstance(spans[i])) {
                limit = st;
            }
            if (en <= start || en >= limit || !kind.isInstance(spans[i])) continue;
            limit = en;
        }
        return limit;
    }

    @UnsupportedAppUsage
    private void sendSpanAdded(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanAdded((Spannable)((Object)this), what, start, end);
        }
    }

    @UnsupportedAppUsage
    private void sendSpanRemoved(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanRemoved((Spannable)((Object)this), what, start, end);
        }
    }

    @UnsupportedAppUsage
    private void sendSpanChanged(Object what, int s, int e, int st, int en) {
        SpanWatcher[] recip = this.getSpans(Math.min(s, st), Math.max(e, en), SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanChanged((Spannable)((Object)this), what, s, e, st, en);
        }
    }

    @UnsupportedAppUsage
    private static String region(int start, int end) {
        return "(" + start + " ... " + end + ")";
    }

    @UnsupportedAppUsage
    private void checkRange(String operation, int start, int end) {
        if (end < start) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringInternal.region(start, end) + " has end before start");
        }
        int len = this.length();
        if (start > len || end > len) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringInternal.region(start, end) + " ends beyond length " + len);
        }
        if (start < 0 || end < 0) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringInternal.region(start, end) + " starts before 0");
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Spanned && this.toString().equals(o.toString())) {
            Spanned other = (Spanned)o;
            Object[] otherSpans = other.getSpans(0, other.length(), Object.class);
            Object[] thisSpans = this.getSpans(0, this.length(), Object.class);
            if (this.mSpanCount == otherSpans.length) {
                for (int i = 0; i < this.mSpanCount; ++i) {
                    Object thisSpan = thisSpans[i];
                    Object otherSpan = otherSpans[i];
                    if (!(thisSpan == this ? other != otherSpan || this.getSpanStart(thisSpan) != other.getSpanStart(otherSpan) || this.getSpanEnd(thisSpan) != other.getSpanEnd(otherSpan) || this.getSpanFlags(thisSpan) != other.getSpanFlags(otherSpan) : !thisSpan.equals(otherSpan) || this.getSpanStart(thisSpan) != other.getSpanStart(otherSpan) || this.getSpanEnd(thisSpan) != other.getSpanEnd(otherSpan) || this.getSpanFlags(thisSpan) != other.getSpanFlags(otherSpan))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.toString().hashCode();
        hash = hash * 31 + this.mSpanCount;
        for (int i = 0; i < this.mSpanCount; ++i) {
            Object span = this.mSpans[i];
            if (span != this) {
                hash = hash * 31 + span.hashCode();
            }
            hash = hash * 31 + this.getSpanStart(span);
            hash = hash * 31 + this.getSpanEnd(span);
            hash = hash * 31 + this.getSpanFlags(span);
        }
        return hash;
    }

    @UnsupportedAppUsage
    private void copySpans(Spanned src, int start, int end) {
        this.copySpansFromSpanned(src, start, end, false);
    }

    @UnsupportedAppUsage
    private void copySpans(SpannableStringInternal src, int start, int end) {
        this.copySpansFromInternal(src, start, end, false);
    }
}

