/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;

public class Rational
extends Number
implements Comparable<Rational> {
    public static final Rational NaN = new Rational(0, 0);
    public static final Rational POSITIVE_INFINITY = new Rational(1, 0);
    public static final Rational NEGATIVE_INFINITY = new Rational(-1, 0);
    public static final Rational ZERO = new Rational(0, 1);
    private static final long serialVersionUID = 1L;
    @UnsupportedAppUsage
    private final int mNumerator;
    @UnsupportedAppUsage
    private final int mDenominator;

    public Rational(int numerator, int denominator) {
        if (denominator < 0) {
            numerator = -numerator;
            denominator = -denominator;
        }
        if (denominator == 0 && numerator > 0) {
            this.mNumerator = 1;
            this.mDenominator = 0;
        } else if (denominator == 0 && numerator < 0) {
            this.mNumerator = -1;
            this.mDenominator = 0;
        } else if (denominator == 0 && numerator == 0) {
            this.mNumerator = 0;
            this.mDenominator = 0;
        } else if (numerator == 0) {
            this.mNumerator = 0;
            this.mDenominator = 1;
        } else {
            int gcd = Rational.gcd(numerator, denominator);
            this.mNumerator = numerator / gcd;
            this.mDenominator = denominator / gcd;
        }
    }

    public int getNumerator() {
        return this.mNumerator;
    }

    public int getDenominator() {
        return this.mDenominator;
    }

    public boolean isNaN() {
        return this.mDenominator == 0 && this.mNumerator == 0;
    }

    public boolean isInfinite() {
        return this.mNumerator != 0 && this.mDenominator == 0;
    }

    public boolean isFinite() {
        return this.mDenominator != 0;
    }

    public boolean isZero() {
        return this.isFinite() && this.mNumerator == 0;
    }

    private boolean isPosInf() {
        return this.mDenominator == 0 && this.mNumerator > 0;
    }

    private boolean isNegInf() {
        return this.mDenominator == 0 && this.mNumerator < 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof Rational && this.equals((Rational)obj);
    }

    private boolean equals(Rational other) {
        return this.mNumerator == other.mNumerator && this.mDenominator == other.mDenominator;
    }

    public String toString() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isPosInf()) {
            return "Infinity";
        }
        if (this.isNegInf()) {
            return "-Infinity";
        }
        return this.mNumerator + "/" + this.mDenominator;
    }

    public float toFloat() {
        return this.floatValue();
    }

    public int hashCode() {
        int numeratorFlipped = this.mNumerator << 16 | this.mNumerator >>> 16;
        return this.mDenominator ^ numeratorFlipped;
    }

    public static int gcd(int numerator, int denominator) {
        int a = numerator;
        int b = denominator;
        while (b != 0) {
            int oldB = b;
            b = a % b;
            a = oldB;
        }
        return Math.abs(a);
    }

    @Override
    public double doubleValue() {
        double num = this.mNumerator;
        double den = this.mDenominator;
        return num / den;
    }

    @Override
    public float floatValue() {
        float num = this.mNumerator;
        float den = this.mDenominator;
        return num / den;
    }

    @Override
    public int intValue() {
        if (this.isPosInf()) {
            return Integer.MAX_VALUE;
        }
        if (this.isNegInf()) {
            return Integer.MIN_VALUE;
        }
        if (this.isNaN()) {
            return 0;
        }
        return this.mNumerator / this.mDenominator;
    }

    @Override
    public long longValue() {
        if (this.isPosInf()) {
            return Long.MAX_VALUE;
        }
        if (this.isNegInf()) {
            return Long.MIN_VALUE;
        }
        if (this.isNaN()) {
            return 0L;
        }
        return this.mNumerator / this.mDenominator;
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public int compareTo(Rational another) {
        Preconditions.checkNotNull(another, "another must not be null");
        if (this.equals(another)) {
            return 0;
        }
        if (this.isNaN()) {
            return 1;
        }
        if (another.isNaN()) {
            return -1;
        }
        if (this.isPosInf() || another.isNegInf()) {
            return 1;
        }
        if (this.isNegInf() || another.isPosInf()) {
            return -1;
        }
        long thisNumerator = (long)this.mNumerator * (long)another.mDenominator;
        long otherNumerator = (long)another.mNumerator * (long)this.mDenominator;
        if (thisNumerator < otherNumerator) {
            return -1;
        }
        if (thisNumerator > otherNumerator) {
            return 1;
        }
        return 0;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.mNumerator == 0) {
            if (this.mDenominator == 1 || this.mDenominator == 0) {
                return;
            }
            throw new InvalidObjectException("Rational must be deserialized from a reduced form for zero values");
        }
        if (this.mDenominator == 0) {
            if (this.mNumerator == 1 || this.mNumerator == -1) {
                return;
            }
            throw new InvalidObjectException("Rational must be deserialized from a reduced form for infinity values");
        }
        if (Rational.gcd(this.mNumerator, this.mDenominator) > 1) {
            throw new InvalidObjectException("Rational must be deserialized from a reduced form for finite values");
        }
    }

    private static NumberFormatException invalidRational(String s) {
        throw new NumberFormatException("Invalid Rational: \"" + s + "\"");
    }

    public static Rational parseRational(String string2) throws NumberFormatException {
        Preconditions.checkNotNull(string2, "string must not be null");
        if (string2.equals("NaN")) {
            return NaN;
        }
        if (string2.equals("Infinity")) {
            return POSITIVE_INFINITY;
        }
        if (string2.equals("-Infinity")) {
            return NEGATIVE_INFINITY;
        }
        int sep_ix = string2.indexOf(58);
        if (sep_ix < 0) {
            sep_ix = string2.indexOf(47);
        }
        if (sep_ix < 0) {
            throw Rational.invalidRational(string2);
        }
        try {
            return new Rational(Integer.parseInt(string2.substring(0, sep_ix)), Integer.parseInt(string2.substring(sep_ix + 1)));
        }
        catch (NumberFormatException e) {
            throw Rational.invalidRational(string2);
        }
    }
}

