/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ArrayMap;
import android.util.SparseArray;
import java.util.function.Consumer;

public class SparseArrayMap<T> {
    private final SparseArray<ArrayMap<String, T>> mData = new SparseArray();

    public void add(int key, String mapKey, T obj) {
        ArrayMap<String, Object> data = this.mData.get(key);
        if (data == null) {
            data = new ArrayMap();
            this.mData.put(key, data);
        }
        data.put(mapKey, obj);
    }

    public void clear() {
        for (int i = 0; i < this.mData.size(); ++i) {
            this.mData.valueAt(i).clear();
        }
    }

    public boolean contains(int key, String mapKey) {
        return this.mData.contains(key) && this.mData.get(key).containsKey(mapKey);
    }

    public void delete(int key) {
        this.mData.delete(key);
    }

    public T delete(int key, String mapKey) {
        ArrayMap<String, T> data = this.mData.get(key);
        if (data != null) {
            return data.remove(mapKey);
        }
        return null;
    }

    public T get(int key, String mapKey) {
        ArrayMap<String, T> data = this.mData.get(key);
        if (data != null) {
            return data.get(mapKey);
        }
        return null;
    }

    public T getOrDefault(int key, String mapKey, T defaultValue) {
        ArrayMap<String, T> data;
        if (this.mData.contains(key) && (data = this.mData.get(key)) != null && data.containsKey(mapKey)) {
            return data.get(mapKey);
        }
        return defaultValue;
    }

    public int indexOfKey(int key) {
        return this.mData.indexOfKey(key);
    }

    public int indexOfKey(int key, String mapKey) {
        ArrayMap<String, T> data = this.mData.get(key);
        if (data != null) {
            return data.indexOfKey(mapKey);
        }
        return -1;
    }

    public int keyAt(int index) {
        return this.mData.keyAt(index);
    }

    public String keyAt(int keyIndex, int mapIndex) {
        return this.mData.valueAt(keyIndex).keyAt(mapIndex);
    }

    public int numMaps() {
        return this.mData.size();
    }

    public int numElementsForKey(int key) {
        ArrayMap<String, T> data = this.mData.get(key);
        return data == null ? 0 : data.size();
    }

    public T valueAt(int keyIndex, int mapIndex) {
        return this.mData.valueAt(keyIndex).valueAt(mapIndex);
    }

    public void forEach(Consumer<T> consumer) {
        for (int i = this.numMaps() - 1; i >= 0; --i) {
            ArrayMap<String, T> data = this.mData.valueAt(i);
            for (int j = data.size() - 1; j >= 0; --j) {
                consumer.accept(data.valueAt(j));
            }
        }
    }
}

