/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.SystemApi;
import android.content.Context;
import android.os.Process;
import android.util.StatsEvent;
import android.util.proto.ProtoOutputStream;
import com.android.internal.lang.System_Delegate;
import com.android.internal.statsd.StatsdStatsLog;
import com.android.tools.layoutlib.create.OverrideMethod;

public class StatsLog {
    private static final String TAG = "StatsLog";
    private static final boolean DEBUG = false;
    private static final int EXPERIMENT_IDS_FIELD_ID = 1;

    private StatsLog() {
    }

    public static boolean logStart(int label) {
        int callingUid = Process.myUid();
        StatsdStatsLog.write(47, callingUid, label, 3);
        return true;
    }

    public static boolean logStop(int label) {
        int callingUid = Process.myUid();
        StatsdStatsLog.write(47, callingUid, label, 2);
        return true;
    }

    public static boolean logEvent(int label) {
        int callingUid = Process.myUid();
        StatsdStatsLog.write(47, callingUid, label, 1);
        return true;
    }

    public static boolean logBinaryPushStateChanged(String trainName, long trainVersionCode, int options, int state, long[] experimentIds) {
        ProtoOutputStream proto = new ProtoOutputStream();
        for (long id2 : experimentIds) {
            proto.write(2211908157441L, id2);
        }
        StatsdStatsLog.write(102, trainName, trainVersionCode, (options & 1) > 0, (options & 2) > 0, (options & 4) > 0, state, proto.getBytes(), 0, 0, false);
        return true;
    }

    @SystemApi
    public static void writeRaw(byte[] buffer, int size) {
        StatsLog.writeImpl(buffer, size, 0);
    }

    private static void writeImpl(byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("android.util.StatsLog#writeImpl([BII)V", true, null);
    }

    @SystemApi
    public static void write(StatsEvent statsEvent) {
        StatsLog.writeImpl(statsEvent.getBytes(), statsEvent.getNumBytes(), statsEvent.getAtomId());
        statsEvent.release();
    }

    private static void enforceDumpCallingPermission(Context context) {
        context.enforceCallingPermission("android.permission.DUMP", "Need DUMP permission.");
    }

    private static void enforcesageStatsCallingPermission(Context context) {
        context.enforceCallingPermission("android.permission.PACKAGE_USAGE_STATS", "Need PACKAGE_USAGE_STATS permission.");
    }

    static {
        System_Delegate.loadLibrary("stats_jni");
    }
}

