/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.os.Handler;
import android.view.Display;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import com.android.layoutlib.common.util.ReflectionUtils;

public class AttachInfo_Accessor {
    public static void setAttachInfo(View view) {
        Context context = view.getContext();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        ViewRootImpl root = new ViewRootImpl(context, display);
        View.AttachInfo info = new View.AttachInfo(ReflectionUtils.createProxy(IWindowSession.class), ReflectionUtils.createProxy(IWindow.class), display, root, new Handler(), null, context);
        info.mHasWindowFocus = true;
        info.mWindowVisibility = 0;
        info.mInTouchMode = false;
        info.mHardwareAccelerated = true;
        info.mThreadedRenderer = new ThreadedRenderer(context, false, "layoutlib-renderer");
        view.dispatchAttachedToWindow(info, 0);
    }

    public static void dispatchOnPreDraw(View view) {
        view.mAttachInfo.mTreeObserver.dispatchOnPreDraw();
    }

    public static void detachFromWindow(View view) {
        if (view != null) {
            ThreadedRenderer threadedRenderer;
            View.AttachInfo attachInfo = view.mAttachInfo;
            view.dispatchDetachedFromWindow();
            if (attachInfo != null && (threadedRenderer = attachInfo.mThreadedRenderer) != null) {
                threadedRenderer.destroy();
            }
        }
    }

    public static ViewRootImpl getRootView(View view) {
        return view.mAttachInfo != null ? view.mAttachInfo.mViewRootImpl : null;
    }
}

