/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.IScrollCaptureClient;

public interface IScrollCaptureController
extends IInterface {
    public void onClientConnected(IScrollCaptureClient var1, Rect var2, Point var3) throws RemoteException;

    public void onClientUnavailable() throws RemoteException;

    public void onCaptureStarted() throws RemoteException;

    public void onCaptureBufferSent(long var1, Rect var3) throws RemoteException;

    public void onConnectionClosed() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IScrollCaptureController {
        private static final String DESCRIPTOR = "android.view.IScrollCaptureController";
        static final int TRANSACTION_onClientConnected = 1;
        static final int TRANSACTION_onClientUnavailable = 2;
        static final int TRANSACTION_onCaptureStarted = 3;
        static final int TRANSACTION_onCaptureBufferSent = 4;
        static final int TRANSACTION_onConnectionClosed = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IScrollCaptureController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IScrollCaptureController) {
                return (IScrollCaptureController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onClientConnected";
                }
                case 2: {
                    return "onClientUnavailable";
                }
                case 3: {
                    return "onCaptureStarted";
                }
                case 4: {
                    return "onCaptureBufferSent";
                }
                case 5: {
                    return "onConnectionClosed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IScrollCaptureClient _arg0 = IScrollCaptureClient.Stub.asInterface(data.readStrongBinder());
                    Rect _arg1 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    Point _arg2 = 0 != data.readInt() ? Point.CREATOR.createFromParcel(data) : null;
                    this.onClientConnected(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onClientUnavailable();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.onCaptureStarted();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    Rect _arg1 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    this.onCaptureBufferSent(_arg0, _arg1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.onConnectionClosed();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IScrollCaptureController impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IScrollCaptureController getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IScrollCaptureController {
            private IBinder mRemote;
            public static IScrollCaptureController sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClientConnected(IScrollCaptureClient client, Rect scrollBounds, Point positionInWindow) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    if (scrollBounds != null) {
                        _data.writeInt(1);
                        scrollBounds.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (positionInWindow != null) {
                        _data.writeInt(1);
                        positionInWindow.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onClientConnected(client, scrollBounds, positionInWindow);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onClientUnavailable() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onClientUnavailable();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onCaptureStarted() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureStarted();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureBufferSent(long frameNumber, Rect capturedArea) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(frameNumber);
                    if (capturedArea != null) {
                        _data.writeInt(1);
                        capturedArea.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureBufferSent(frameNumber, capturedArea);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onConnectionClosed() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onConnectionClosed();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IScrollCaptureController {
        @Override
        public void onClientConnected(IScrollCaptureClient client, Rect scrollBounds, Point positionInWindow) throws RemoteException {
        }

        @Override
        public void onClientUnavailable() throws RemoteException {
        }

        @Override
        public void onCaptureStarted() throws RemoteException {
        }

        @Override
        public void onCaptureBufferSent(long frameNumber, Rect capturedArea) throws RemoteException {
        }

        @Override
        public void onConnectionClosed() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

