/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;

public class InputChannel
implements Parcelable {
    private static final String TAG = "InputChannel";
    private static final boolean DEBUG = false;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<InputChannel> CREATOR = new Parcelable.Creator<InputChannel>(){

        @Override
        public InputChannel createFromParcel(Parcel source) {
            InputChannel result = new InputChannel();
            result.readFromParcel(source);
            return result;
        }

        public InputChannel[] newArray(int size) {
            return new InputChannel[size];
        }
    };
    @UnsupportedAppUsage
    private long mPtr;

    private static InputChannel[] nativeOpenInputChannelPair(String string2) {
        return (InputChannel[])OverrideMethod.invokeA("android.view.InputChannel#nativeOpenInputChannelPair(Ljava/lang/String;)[Landroid/view/InputChannel;", true, null);
    }

    private void nativeDispose(boolean bl) {
        OverrideMethod.invokeV("android.view.InputChannel#nativeDispose(Z)V", true, this);
    }

    private void nativeRelease() {
        OverrideMethod.invokeV("android.view.InputChannel#nativeRelease()V", true, this);
    }

    private void nativeTransferTo(InputChannel inputChannel) {
        OverrideMethod.invokeV("android.view.InputChannel#nativeTransferTo(Landroid/view/InputChannel;)V", true, this);
    }

    private void nativeReadFromParcel(Parcel parcel) {
        OverrideMethod.invokeV("android.view.InputChannel#nativeReadFromParcel(Landroid/os/Parcel;)V", true, this);
    }

    private void nativeWriteToParcel(Parcel parcel) {
        OverrideMethod.invokeV("android.view.InputChannel#nativeWriteToParcel(Landroid/os/Parcel;)V", true, this);
    }

    private void nativeDup(InputChannel inputChannel) {
        OverrideMethod.invokeV("android.view.InputChannel#nativeDup(Landroid/view/InputChannel;)V", true, this);
    }

    private IBinder nativeGetToken() {
        return (IBinder)OverrideMethod.invokeA("android.view.InputChannel#nativeGetToken()Landroid/os/IBinder;", true, this);
    }

    private String nativeGetName() {
        return (String)OverrideMethod.invokeA("android.view.InputChannel#nativeGetName()Ljava/lang/String;", true, this);
    }

    @UnsupportedAppUsage
    public InputChannel() {
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeDispose(true);
        }
        finally {
            super.finalize();
        }
    }

    public static InputChannel[] openInputChannelPair(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return InputChannel.nativeOpenInputChannelPair(name);
    }

    public String getName() {
        String name = this.nativeGetName();
        return name != null ? name : "uninitialized";
    }

    public void dispose() {
        this.nativeDispose(false);
    }

    public void release() {
        this.nativeRelease();
    }

    public void transferTo(InputChannel outParameter) {
        if (outParameter == null) {
            throw new IllegalArgumentException("outParameter must not be null");
        }
        this.nativeTransferTo(outParameter);
    }

    public InputChannel dup() {
        InputChannel target = new InputChannel();
        this.nativeDup(target);
        return target;
    }

    @Override
    public int describeContents() {
        return 1;
    }

    public void readFromParcel(Parcel in) {
        if (in == null) {
            throw new IllegalArgumentException("in must not be null");
        }
        this.nativeReadFromParcel(in);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        if (out == null) {
            throw new IllegalArgumentException("out must not be null");
        }
        this.nativeWriteToParcel(out);
        if ((flags & 1) != 0) {
            this.dispose();
        }
    }

    public String toString() {
        return this.getName();
    }

    public IBinder getToken() {
        return this.nativeGetToken();
    }
}

