/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.ArraySet;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseSetArray;
import android.view.InsetsAnimationControlCallbacks;
import android.view.InsetsAnimationControlRunner;
import android.view.InsetsSource;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.WindowInsetsAnimation;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.animation.Interpolator;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;

@VisibleForTesting
public class InsetsAnimationControlImpl
implements WindowInsetsAnimationController,
InsetsAnimationControlRunner {
    private static final String TAG = "InsetsAnimationCtrlImpl";
    private final Rect mTmpFrame = new Rect();
    private final WindowInsetsAnimationControlListener mListener;
    private final SparseArray<InsetsSourceControl> mControls;
    private final SparseIntArray mTypeSideMap = new SparseIntArray();
    private final SparseSetArray<InsetsSourceControl> mSideSourceMap = new SparseSetArray();
    private final Insets mHiddenInsets;
    private final Insets mShownInsets;
    private final Matrix mTmpMatrix = new Matrix();
    private final InsetsState mInitialInsetsState;
    private final int mAnimationType;
    private final int mTypes;
    private final InsetsAnimationControlCallbacks mController;
    private final WindowInsetsAnimation mAnimation;
    private final boolean mHasZeroInsetsIme;
    private Insets mCurrentInsets;
    private Insets mPendingInsets;
    private float mPendingFraction;
    private boolean mFinished;
    private boolean mCancelled;
    private boolean mShownOnFinish;
    private float mCurrentAlpha = 1.0f;
    private float mPendingAlpha = 1.0f;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public boolean mReadyDispatched;
    private Boolean mPerceptible;

    @VisibleForTesting
    public InsetsAnimationControlImpl(SparseArray<InsetsSourceControl> controls, Rect frame, InsetsState state, WindowInsetsAnimationControlListener listener, int types, InsetsAnimationControlCallbacks controller, long durationMs, Interpolator interpolator2, int animationType) {
        this.mControls = controls;
        this.mListener = listener;
        this.mTypes = types;
        this.mController = controller;
        this.mInitialInsetsState = new InsetsState(state, true);
        this.mPendingInsets = this.mCurrentInsets = this.getInsetsFromState(this.mInitialInsetsState, frame, null);
        this.mHiddenInsets = this.calculateInsets(this.mInitialInsetsState, frame, controls, false, null);
        this.mShownInsets = this.calculateInsets(this.mInitialInsetsState, frame, controls, true, this.mTypeSideMap);
        boolean bl = this.mHasZeroInsetsIme = this.mShownInsets.bottom == 0 && this.controlsInternalType(13);
        if (this.mHasZeroInsetsIme) {
            this.mTypeSideMap.put(13, 3);
        }
        InsetsAnimationControlImpl.buildTypeSourcesMap(this.mTypeSideMap, this.mSideSourceMap, this.mControls);
        this.mAnimation = new WindowInsetsAnimation(this.mTypes, interpolator2, durationMs);
        this.mAnimation.setAlpha(this.getCurrentAlpha());
        this.mAnimationType = animationType;
        this.mController.startAnimation(this, listener, types, this.mAnimation, new WindowInsetsAnimation.Bounds(this.mHiddenInsets, this.mShownInsets));
    }

    private boolean calculatePerceptible(Insets currentInsets, float currentAlpha) {
        return 100 * currentInsets.left >= 5 * (this.mShownInsets.left - this.mHiddenInsets.left) && 100 * currentInsets.top >= 5 * (this.mShownInsets.top - this.mHiddenInsets.top) && 100 * currentInsets.right >= 5 * (this.mShownInsets.right - this.mHiddenInsets.right) && 100 * currentInsets.bottom >= 5 * (this.mShownInsets.bottom - this.mHiddenInsets.bottom) && currentAlpha >= 0.5f;
    }

    @Override
    public boolean hasZeroInsetsIme() {
        return this.mHasZeroInsetsIme;
    }

    @Override
    public Insets getHiddenStateInsets() {
        return this.mHiddenInsets;
    }

    @Override
    public Insets getShownStateInsets() {
        return this.mShownInsets;
    }

    @Override
    public Insets getCurrentInsets() {
        return this.mCurrentInsets;
    }

    @Override
    public float getCurrentAlpha() {
        return this.mCurrentAlpha;
    }

    @Override
    public int getTypes() {
        return this.mTypes;
    }

    @Override
    public int getAnimationType() {
        return this.mAnimationType;
    }

    @Override
    public void setInsetsAndAlpha(Insets insets, float alpha, float fraction2) {
        this.setInsetsAndAlpha(insets, alpha, fraction2, false);
    }

    private void setInsetsAndAlpha(Insets insets, float alpha, float fraction2, boolean allowWhenFinished) {
        if (!allowWhenFinished && this.mFinished) {
            throw new IllegalStateException("Can't change insets on an animation that is finished.");
        }
        if (this.mCancelled) {
            throw new IllegalStateException("Can't change insets on an animation that is cancelled.");
        }
        this.mPendingFraction = InsetsAnimationControlImpl.sanitize(fraction2);
        this.mPendingInsets = this.sanitize(insets);
        this.mPendingAlpha = InsetsAnimationControlImpl.sanitize(alpha);
        this.mController.scheduleApplyChangeInsets(this);
        boolean perceptible = this.calculatePerceptible(this.mPendingInsets, this.mPendingAlpha);
        if (this.mPerceptible == null || perceptible != this.mPerceptible) {
            this.mController.reportPerceptible(this.mTypes, perceptible);
            this.mPerceptible = perceptible;
        }
    }

    @VisibleForTesting
    public boolean applyChangeInsets(InsetsState state) {
        if (this.mCancelled) {
            return false;
        }
        Insets offset = Insets.subtract(this.mShownInsets, this.mPendingInsets);
        ArrayList<SyncRtSurfaceTransactionApplier.SurfaceParams> params = new ArrayList<SyncRtSurfaceTransactionApplier.SurfaceParams>();
        this.updateLeashesForSide(0, offset.left, this.mShownInsets.left, this.mPendingInsets.left, params, state, Float.valueOf(this.mPendingAlpha));
        this.updateLeashesForSide(1, offset.top, this.mShownInsets.top, this.mPendingInsets.top, params, state, Float.valueOf(this.mPendingAlpha));
        this.updateLeashesForSide(2, offset.right, this.mShownInsets.right, this.mPendingInsets.right, params, state, Float.valueOf(this.mPendingAlpha));
        this.updateLeashesForSide(3, offset.bottom, this.mShownInsets.bottom, this.mPendingInsets.bottom, params, state, Float.valueOf(this.mPendingAlpha));
        this.mController.applySurfaceParams(params.toArray(new SyncRtSurfaceTransactionApplier.SurfaceParams[params.size()]));
        this.mCurrentInsets = this.mPendingInsets;
        this.mAnimation.setFraction(this.mPendingFraction);
        this.mCurrentAlpha = this.mPendingAlpha;
        this.mAnimation.setAlpha(this.mPendingAlpha);
        if (this.mFinished) {
            this.mController.notifyFinished(this, this.mShownOnFinish);
            this.releaseLeashes();
        }
        return this.mFinished;
    }

    private void releaseLeashes() {
        for (int i = this.mControls.size() - 1; i >= 0; --i) {
            InsetsSourceControl c = this.mControls.valueAt(i);
            if (c == null) continue;
            c.release(this.mController::releaseSurfaceControlFromRt);
        }
    }

    @Override
    public void finish(boolean shown) {
        if (this.mCancelled || this.mFinished) {
            return;
        }
        this.mShownOnFinish = shown;
        this.mFinished = true;
        this.setInsetsAndAlpha(shown ? this.mShownInsets : this.mHiddenInsets, 1.0f, 1.0f, true);
        this.mListener.onFinished(this);
    }

    @Override
    @VisibleForTesting
    public float getCurrentFraction() {
        return this.mAnimation.getFraction();
    }

    @Override
    public void cancel() {
        if (this.mFinished) {
            return;
        }
        this.mCancelled = true;
        this.mListener.onCancelled(this.mReadyDispatched ? this : null);
        this.releaseLeashes();
    }

    @Override
    public boolean isFinished() {
        return this.mFinished;
    }

    @Override
    public boolean isCancelled() {
        return this.mCancelled;
    }

    @Override
    public WindowInsetsAnimation getAnimation() {
        return this.mAnimation;
    }

    WindowInsetsAnimationControlListener getListener() {
        return this.mListener;
    }

    SparseArray<InsetsSourceControl> getControls() {
        return this.mControls;
    }

    private Insets calculateInsets(InsetsState state, Rect frame, SparseArray<InsetsSourceControl> controls, boolean shown, SparseIntArray typeSideMap) {
        for (int i = controls.size() - 1; i >= 0; --i) {
            if (controls.valueAt(i) == null) continue;
            state.getSource(controls.valueAt(i).getType()).setVisible(shown);
        }
        return this.getInsetsFromState(state, frame, typeSideMap);
    }

    private Insets getInsetsFromState(InsetsState state, Rect frame, SparseIntArray typeSideMap) {
        return state.calculateInsets(frame, null, false, false, null, 16, 0, 0, typeSideMap).getInsets(this.mTypes);
    }

    private Insets sanitize(Insets insets) {
        if (insets == null) {
            insets = this.getCurrentInsets();
        }
        if (this.hasZeroInsetsIme()) {
            return insets;
        }
        return Insets.max(Insets.min(insets, this.mShownInsets), this.mHiddenInsets);
    }

    private static float sanitize(float alpha) {
        return alpha >= 1.0f ? 1.0f : (alpha <= 0.0f ? 0.0f : alpha);
    }

    private void updateLeashesForSide(int side, int offset, int maxInset, int inset, ArrayList<SyncRtSurfaceTransactionApplier.SurfaceParams> surfaceParams, InsetsState state, Float alpha) {
        ArraySet<InsetsSourceControl> items = this.mSideSourceMap.get(side);
        if (items == null) {
            return;
        }
        for (int i = items.size() - 1; i >= 0; --i) {
            InsetsSourceControl control = items.valueAt(i);
            InsetsSource source = this.mInitialInsetsState.getSource(control.getType());
            SurfaceControl leash = control.getLeash();
            this.mTmpMatrix.setTranslate(control.getSurfacePosition().x, control.getSurfacePosition().y);
            this.mTmpFrame.set(source.getFrame());
            this.addTranslationToMatrix(side, offset, this.mTmpMatrix, this.mTmpFrame);
            boolean visible = this.mHasZeroInsetsIme && side == 3 ? (this.mAnimationType == 0 ? true : !this.mFinished) : inset != 0;
            state.getSource(source.getType()).setVisible(visible);
            state.getSource(source.getType()).setFrame(this.mTmpFrame);
            if (leash == null) continue;
            SyncRtSurfaceTransactionApplier.SurfaceParams params = new SyncRtSurfaceTransactionApplier.SurfaceParams.Builder(leash).withAlpha(alpha.floatValue()).withMatrix(this.mTmpMatrix).withVisibility(visible).build();
            surfaceParams.add(params);
        }
    }

    private void addTranslationToMatrix(int side, int inset, Matrix m, Rect frame) {
        switch (side) {
            case 0: {
                m.postTranslate(-inset, 0.0f);
                frame.offset(-inset, 0);
                break;
            }
            case 1: {
                m.postTranslate(0.0f, -inset);
                frame.offset(0, -inset);
                break;
            }
            case 2: {
                m.postTranslate(inset, 0.0f);
                frame.offset(inset, 0);
                break;
            }
            case 3: {
                m.postTranslate(0.0f, inset);
                frame.offset(0, inset);
            }
        }
    }

    private static void buildTypeSourcesMap(SparseIntArray typeSideMap, SparseSetArray<InsetsSourceControl> sideSourcesMap, SparseArray<InsetsSourceControl> controls) {
        for (int i = typeSideMap.size() - 1; i >= 0; --i) {
            int type = typeSideMap.keyAt(i);
            int side = typeSideMap.valueAt(i);
            InsetsSourceControl control = controls.get(type);
            if (control == null) continue;
            sideSourcesMap.add(side, control);
        }
    }
}

