/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.os.Handler;
import android.os.Trace;
import android.util.SparseArray;
import android.view.InsetsAnimationControlCallbacks;
import android.view.InsetsAnimationControlImpl;
import android.view.InsetsAnimationControlRunner;
import android.view.InsetsAnimationThread;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import android.view.WindowInsetsAnimationControlListener;
import android.view.animation.Interpolator;

public class InsetsAnimationThreadControlRunner
implements InsetsAnimationControlRunner {
    private static final String TAG = "InsetsAnimThreadRunner";
    private final InsetsAnimationControlImpl mControl;
    private final InsetsAnimationControlCallbacks mOuterCallbacks;
    private final Handler mMainThreadHandler;
    private final InsetsState mState = new InsetsState();
    private final InsetsAnimationControlCallbacks mCallbacks = new InsetsAnimationControlCallbacks(){
        private final float[] mTmpFloat9 = new float[9];

        @Override
        public void startAnimation(InsetsAnimationControlImpl controller, WindowInsetsAnimationControlListener listener, int types, WindowInsetsAnimation animation, WindowInsetsAnimation.Bounds bounds) {
        }

        @Override
        public void scheduleApplyChangeInsets(InsetsAnimationControlRunner runner) {
            InsetsAnimationThreadControlRunner.this.mControl.applyChangeInsets(InsetsAnimationThreadControlRunner.this.mState);
        }

        @Override
        public void notifyFinished(InsetsAnimationControlRunner runner, boolean shown) {
            Trace.asyncTraceEnd(8L, "InsetsAsyncAnimation: " + WindowInsets.Type.toString(runner.getTypes()), runner.getTypes());
            InsetsAnimationThreadControlRunner.this.releaseControls(InsetsAnimationThreadControlRunner.this.mControl.getControls());
            InsetsAnimationThreadControlRunner.this.mMainThreadHandler.post(() -> InsetsAnimationThreadControlRunner.this.mOuterCallbacks.notifyFinished(InsetsAnimationThreadControlRunner.this, shown));
        }

        @Override
        public void applySurfaceParams(SyncRtSurfaceTransactionApplier.SurfaceParams ... params) {
            SurfaceControl.Transaction t = new SurfaceControl.Transaction();
            for (int i = params.length - 1; i >= 0; --i) {
                SyncRtSurfaceTransactionApplier.SurfaceParams surfaceParams = params[i];
                SyncRtSurfaceTransactionApplier.applyParams(t, surfaceParams, this.mTmpFloat9);
            }
            t.apply();
            t.close();
        }

        @Override
        public void releaseSurfaceControlFromRt(SurfaceControl sc) {
            sc.release();
        }

        @Override
        public void reportPerceptible(int types, boolean perceptible) {
            InsetsAnimationThreadControlRunner.this.mMainThreadHandler.post(() -> InsetsAnimationThreadControlRunner.this.mOuterCallbacks.reportPerceptible(types, perceptible));
        }
    };

    public InsetsAnimationThreadControlRunner(SparseArray<InsetsSourceControl> controls, Rect frame, InsetsState state, WindowInsetsAnimationControlListener listener, int types, InsetsAnimationControlCallbacks controller, long durationMs, Interpolator interpolator2, int animationType, Handler mainThreadHandler) {
        this.mMainThreadHandler = mainThreadHandler;
        this.mOuterCallbacks = controller;
        this.mControl = new InsetsAnimationControlImpl(controls, frame, state, listener, types, this.mCallbacks, durationMs, interpolator2, animationType);
        InsetsAnimationThread.getHandler().post(() -> {
            Trace.asyncTraceBegin(8L, "InsetsAsyncAnimation: " + WindowInsets.Type.toString(types), types);
            listener.onReady(this.mControl, types);
        });
    }

    private void releaseControls(SparseArray<InsetsSourceControl> controls) {
        for (int i = controls.size() - 1; i >= 0; --i) {
            controls.valueAt(i).release(SurfaceControl::release);
        }
    }

    @Override
    public int getTypes() {
        return this.mControl.getTypes();
    }

    @Override
    public void cancel() {
        InsetsAnimationThread.getHandler().post(this.mControl::cancel);
    }

    @Override
    public WindowInsetsAnimation getAnimation() {
        return this.mControl.getAnimation();
    }

    @Override
    public int getAnimationType() {
        return this.mControl.getAnimationType();
    }
}

