/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.InsetsState;
import android.view.SurfaceControl;
import java.io.PrintWriter;
import java.util.function.Consumer;

public class InsetsSourceControl
implements Parcelable {
    private final int mType;
    private final SurfaceControl mLeash;
    private final Point mSurfacePosition;
    public static final Parcelable.Creator<InsetsSourceControl> CREATOR = new Parcelable.Creator<InsetsSourceControl>(){

        @Override
        public InsetsSourceControl createFromParcel(Parcel in) {
            return new InsetsSourceControl(in);
        }

        public InsetsSourceControl[] newArray(int size) {
            return new InsetsSourceControl[size];
        }
    };

    public InsetsSourceControl(int type, SurfaceControl leash, Point surfacePosition) {
        this.mType = type;
        this.mLeash = leash;
        this.mSurfacePosition = surfacePosition;
    }

    public InsetsSourceControl(InsetsSourceControl other) {
        this.mType = other.mType;
        this.mLeash = other.mLeash != null ? new SurfaceControl(other.mLeash, "InsetsSourceControl") : null;
        this.mSurfacePosition = new Point(other.mSurfacePosition);
    }

    public int getType() {
        return this.mType;
    }

    public SurfaceControl getLeash() {
        return this.mLeash;
    }

    public InsetsSourceControl(Parcel in) {
        this.mType = in.readInt();
        this.mLeash = (SurfaceControl)in.readParcelable(null);
        this.mSurfacePosition = (Point)in.readParcelable(null);
    }

    public boolean setSurfacePosition(int left, int top) {
        if (this.mSurfacePosition.equals(left, top)) {
            return false;
        }
        this.mSurfacePosition.set(left, top);
        return true;
    }

    public Point getSurfacePosition() {
        return this.mSurfacePosition;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeParcelable(this.mLeash, 0);
        dest.writeParcelable(this.mSurfacePosition, 0);
    }

    public void release(Consumer<SurfaceControl> surfaceReleaseConsumer) {
        if (this.mLeash != null) {
            surfaceReleaseConsumer.accept(this.mLeash);
        }
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("InsetsSourceControl type=");
        pw.print(InsetsState.typeToString(this.mType));
        pw.print(" mLeash=");
        pw.print(this.mLeash);
        pw.print(" mSurfacePosition=");
        pw.print(this.mSurfacePosition);
        pw.println();
    }
}

