/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.VerifiedInputEvent;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class VerifiedMotionEvent
extends VerifiedInputEvent
implements Parcelable {
    private static final String TAG = "VerifiedMotionEvent";
    private float mRawX;
    private float mRawY;
    private int mActionMasked;
    @SuppressLint(value={"MethodNameUnits"})
    private long mDownTimeNanos;
    private int mFlags;
    private int mMetaState;
    private int mButtonState;
    public static final Parcelable.Creator<VerifiedMotionEvent> CREATOR = new Parcelable.Creator<VerifiedMotionEvent>(){

        public VerifiedMotionEvent[] newArray(int size) {
            return new VerifiedMotionEvent[size];
        }

        @Override
        public VerifiedMotionEvent createFromParcel(Parcel in) {
            return new VerifiedMotionEvent(in);
        }
    };

    public Boolean getFlag(int flag) {
        switch (flag) {
            case 1: 
            case 2: {
                return (this.mFlags & flag) != 0;
            }
        }
        return null;
    }

    public VerifiedMotionEvent(int deviceId, long eventTimeNanos, int source, int displayId, float rawX, float rawY, int actionMasked, @SuppressLint(value={"MethodNameUnits"}) long downTimeNanos, int flags, int metaState, int buttonState) {
        super(2, deviceId, eventTimeNanos, source, displayId);
        this.mRawX = rawX;
        this.mRawY = rawY;
        this.mActionMasked = actionMasked;
        AnnotationValidations.validate(MotionEventAction.class, null, this.mActionMasked);
        this.mDownTimeNanos = downTimeNanos;
        AnnotationValidations.validate(SuppressLint.class, null, (Object)this.mDownTimeNanos, "value", "MethodNameUnits");
        this.mFlags = flags;
        this.mMetaState = metaState;
        this.mButtonState = buttonState;
    }

    public float getRawX() {
        return this.mRawX;
    }

    public float getRawY() {
        return this.mRawY;
    }

    public int getActionMasked() {
        return this.mActionMasked;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public long getDownTimeNanos() {
        return this.mDownTimeNanos;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public int getMetaState() {
        return this.mMetaState;
    }

    public int getButtonState() {
        return this.mButtonState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifiedMotionEvent that = (VerifiedMotionEvent)o;
        return this.getDeviceId() == that.getDeviceId() && this.getEventTimeNanos() == that.getEventTimeNanos() && this.getSource() == that.getSource() && this.getDisplayId() == that.getDisplayId() && this.mRawX == that.mRawX && this.mRawY == that.mRawY && this.mActionMasked == that.mActionMasked && this.mDownTimeNanos == that.mDownTimeNanos && this.mFlags == that.mFlags && this.mMetaState == that.mMetaState && this.mButtonState == that.mButtonState;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.getDeviceId();
        _hash = 31 * _hash + Long.hashCode(this.getEventTimeNanos());
        _hash = 31 * _hash + this.getSource();
        _hash = 31 * _hash + this.getDisplayId();
        _hash = 31 * _hash + Float.hashCode(this.mRawX);
        _hash = 31 * _hash + Float.hashCode(this.mRawY);
        _hash = 31 * _hash + this.mActionMasked;
        _hash = 31 * _hash + Long.hashCode(this.mDownTimeNanos);
        _hash = 31 * _hash + this.mFlags;
        _hash = 31 * _hash + this.mMetaState;
        _hash = 31 * _hash + this.mButtonState;
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeFloat(this.mRawX);
        dest.writeFloat(this.mRawY);
        dest.writeInt(this.mActionMasked);
        dest.writeLong(this.mDownTimeNanos);
        dest.writeInt(this.mFlags);
        dest.writeInt(this.mMetaState);
        dest.writeInt(this.mButtonState);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    VerifiedMotionEvent(Parcel in) {
        super(in, 2);
        float rawX = in.readFloat();
        float rawY = in.readFloat();
        int actionMasked = in.readInt();
        long downTimeNanos = in.readLong();
        int flags = in.readInt();
        int metaState = in.readInt();
        int buttonState = in.readInt();
        this.mRawX = rawX;
        this.mRawY = rawY;
        this.mActionMasked = actionMasked;
        AnnotationValidations.validate(MotionEventAction.class, null, this.mActionMasked);
        this.mDownTimeNanos = downTimeNanos;
        AnnotationValidations.validate(SuppressLint.class, null, (Object)this.mDownTimeNanos, "value", "MethodNameUnits");
        this.mFlags = flags;
        this.mMetaState = metaState;
        this.mButtonState = buttonState;
    }

    @Deprecated
    private void __metadata() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MotionEventAction {
    }
}

