/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.view.View;
import android.view.textclassifier.EntityConfidence;
import android.view.textclassifier.SystemTextClassifierMetadata;
import android.view.textclassifier.TextClassificationManager;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinksParams;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class TextLinks
implements Parcelable {
    public static final int STATUS_LINKS_APPLIED = 0;
    public static final int STATUS_NO_LINKS_FOUND = 1;
    public static final int STATUS_NO_LINKS_APPLIED = 2;
    public static final int STATUS_DIFFERENT_TEXT = 3;
    public static final int STATUS_UNSUPPORTED_CHARACTER = 4;
    public static final int APPLY_STRATEGY_IGNORE = 0;
    public static final int APPLY_STRATEGY_REPLACE = 1;
    private final String mFullText;
    private final List<TextLink> mLinks;
    private final Bundle mExtras;
    public static final Parcelable.Creator<TextLinks> CREATOR = new Parcelable.Creator<TextLinks>(){

        @Override
        public TextLinks createFromParcel(Parcel in) {
            return new TextLinks(in);
        }

        public TextLinks[] newArray(int size) {
            return new TextLinks[size];
        }
    };

    private TextLinks(String fullText, ArrayList<TextLink> links, Bundle extras) {
        this.mFullText = fullText;
        this.mLinks = Collections.unmodifiableList(links);
        this.mExtras = extras;
    }

    public CharSequence getText() {
        return this.mFullText;
    }

    public Collection<TextLink> getLinks() {
        return this.mLinks;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public int apply(Spannable text, int applyStrategy, Function<TextLink, TextLinkSpan> spanFactory) {
        Objects.requireNonNull(text);
        return new TextLinksParams.Builder().setApplyStrategy(applyStrategy).setSpanFactory(spanFactory).build().apply(text, this);
    }

    public String toString() {
        return String.format(Locale.US, "TextLinks{fullText=%s, links=%s}", this.mFullText, this.mLinks);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mFullText);
        dest.writeTypedList(this.mLinks);
        dest.writeBundle(this.mExtras);
    }

    private TextLinks(Parcel in) {
        this.mFullText = in.readString();
        this.mLinks = in.createTypedArrayList(TextLink.CREATOR);
        this.mExtras = in.readBundle();
    }

    public static class Builder {
        private final String mFullText;
        private final ArrayList<TextLink> mLinks;
        private Bundle mExtras;

        public Builder(String fullText) {
            this.mFullText = Objects.requireNonNull(fullText);
            this.mLinks = new ArrayList();
        }

        public Builder addLink(int start, int end, Map<String, Float> entityScores) {
            return this.addLink(start, end, entityScores, Bundle.EMPTY, null);
        }

        public Builder addLink(int start, int end, Map<String, Float> entityScores, Bundle extras) {
            return this.addLink(start, end, entityScores, extras, null);
        }

        Builder addLink(int start, int end, Map<String, Float> entityScores, URLSpan urlSpan) {
            return this.addLink(start, end, entityScores, Bundle.EMPTY, urlSpan);
        }

        private Builder addLink(int start, int end, Map<String, Float> entityScores, Bundle extras, URLSpan urlSpan) {
            this.mLinks.add(new TextLink(start, end, new EntityConfidence(entityScores), extras, urlSpan));
            return this;
        }

        public Builder clearTextLinks() {
            this.mLinks.clear();
            return this;
        }

        public Builder setExtras(Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        public TextLinks build() {
            return new TextLinks(this.mFullText, this.mLinks, this.mExtras == null ? Bundle.EMPTY : this.mExtras);
        }
    }

    public static class TextLinkSpan
    extends ClickableSpan {
        public static final int INVOCATION_METHOD_UNSPECIFIED = -1;
        public static final int INVOCATION_METHOD_TOUCH = 0;
        public static final int INVOCATION_METHOD_KEYBOARD = 1;
        private final TextLink mTextLink;

        public TextLinkSpan(TextLink textLink) {
            this.mTextLink = textLink;
        }

        @Override
        public void onClick(View widget) {
            this.onClick(widget, -1);
        }

        public void onClick(View widget, int invocationMethod) {
            if (widget instanceof TextView) {
                TextView textView = (TextView)widget;
                Context context = textView.getContext();
                if (TextClassificationManager.getSettings(context).isSmartLinkifyEnabled()) {
                    switch (invocationMethod) {
                        case 0: {
                            textView.requestActionMode(this);
                            break;
                        }
                        default: {
                            textView.handleClick(this);
                            break;
                        }
                    }
                } else if (this.mTextLink.mUrlSpan != null) {
                    this.mTextLink.mUrlSpan.onClick(textView);
                } else {
                    textView.handleClick(this);
                }
            }
        }

        public TextLink getTextLink() {
            return this.mTextLink;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
        public String getUrl() {
            if (this.mTextLink.mUrlSpan != null) {
                return this.mTextLink.mUrlSpan.getURL();
            }
            return null;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InvocationMethod {
        }
    }

    public static class Request
    implements Parcelable {
        private final CharSequence mText;
        private final LocaleList mDefaultLocales;
        private final TextClassifier.EntityConfig mEntityConfig;
        private final boolean mLegacyFallback;
        private final Bundle mExtras;
        private final ZonedDateTime mReferenceTime;
        private SystemTextClassifierMetadata mSystemTcMetadata;
        public static final Parcelable.Creator<Request> CREATOR = new Parcelable.Creator<Request>(){

            @Override
            public Request createFromParcel(Parcel in) {
                return Request.readFromParcel(in);
            }

            public Request[] newArray(int size) {
                return new Request[size];
            }
        };

        private Request(CharSequence text, LocaleList defaultLocales, TextClassifier.EntityConfig entityConfig, boolean legacyFallback, ZonedDateTime referenceTime, Bundle extras) {
            this.mText = text;
            this.mDefaultLocales = defaultLocales;
            this.mEntityConfig = entityConfig;
            this.mLegacyFallback = legacyFallback;
            this.mReferenceTime = referenceTime;
            this.mExtras = extras;
        }

        public CharSequence getText() {
            return this.mText;
        }

        public LocaleList getDefaultLocales() {
            return this.mDefaultLocales;
        }

        public TextClassifier.EntityConfig getEntityConfig() {
            return this.mEntityConfig;
        }

        public boolean isLegacyFallback() {
            return this.mLegacyFallback;
        }

        public ZonedDateTime getReferenceTime() {
            return this.mReferenceTime;
        }

        public String getCallingPackageName() {
            return this.mSystemTcMetadata != null ? this.mSystemTcMetadata.getCallingPackageName() : null;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void setSystemTextClassifierMetadata(SystemTextClassifierMetadata systemTcMetadata) {
            this.mSystemTcMetadata = systemTcMetadata;
        }

        public SystemTextClassifierMetadata getSystemTextClassifierMetadata() {
            return this.mSystemTcMetadata;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mText.toString());
            dest.writeParcelable(this.mDefaultLocales, flags);
            dest.writeParcelable(this.mEntityConfig, flags);
            dest.writeBundle(this.mExtras);
            dest.writeString(this.mReferenceTime == null ? null : this.mReferenceTime.toString());
            dest.writeParcelable(this.mSystemTcMetadata, flags);
        }

        private static Request readFromParcel(Parcel in) {
            String text = in.readString();
            LocaleList defaultLocales = (LocaleList)in.readParcelable(null);
            TextClassifier.EntityConfig entityConfig = (TextClassifier.EntityConfig)in.readParcelable(null);
            Bundle extras = in.readBundle();
            String referenceTimeString = in.readString();
            ZonedDateTime referenceTime = referenceTimeString == null ? null : ZonedDateTime.parse(referenceTimeString);
            SystemTextClassifierMetadata systemTcMetadata = (SystemTextClassifierMetadata)in.readParcelable(null);
            Request request = new Request(text, defaultLocales, entityConfig, true, referenceTime, extras);
            request.setSystemTextClassifierMetadata(systemTcMetadata);
            return request;
        }

        public static class Builder {
            private final CharSequence mText;
            private LocaleList mDefaultLocales;
            private TextClassifier.EntityConfig mEntityConfig;
            private boolean mLegacyFallback = true;
            private Bundle mExtras;
            private ZonedDateTime mReferenceTime;

            public Builder(CharSequence text) {
                this.mText = Objects.requireNonNull(text);
            }

            public Builder setDefaultLocales(LocaleList defaultLocales) {
                this.mDefaultLocales = defaultLocales;
                return this;
            }

            public Builder setEntityConfig(TextClassifier.EntityConfig entityConfig) {
                this.mEntityConfig = entityConfig;
                return this;
            }

            public Builder setLegacyFallback(boolean legacyFallback) {
                this.mLegacyFallback = legacyFallback;
                return this;
            }

            public Builder setExtras(Bundle extras) {
                this.mExtras = extras;
                return this;
            }

            public Builder setReferenceTime(ZonedDateTime referenceTime) {
                this.mReferenceTime = referenceTime;
                return this;
            }

            public Request build() {
                return new Request(this.mText, this.mDefaultLocales, this.mEntityConfig, this.mLegacyFallback, this.mReferenceTime, this.mExtras == null ? Bundle.EMPTY : this.mExtras);
            }
        }
    }

    public static class TextLink
    implements Parcelable {
        private final EntityConfidence mEntityScores;
        private final int mStart;
        private final int mEnd;
        private final Bundle mExtras;
        private final URLSpan mUrlSpan;
        public static final Parcelable.Creator<TextLink> CREATOR = new Parcelable.Creator<TextLink>(){

            @Override
            public TextLink createFromParcel(Parcel in) {
                return TextLink.readFromParcel(in);
            }

            public TextLink[] newArray(int size) {
                return new TextLink[size];
            }
        };

        private TextLink(int start, int end, EntityConfidence entityConfidence, Bundle extras, URLSpan urlSpan) {
            Objects.requireNonNull(entityConfidence);
            Preconditions.checkArgument(!entityConfidence.getEntities().isEmpty());
            Preconditions.checkArgument(start <= end);
            Objects.requireNonNull(extras);
            this.mStart = start;
            this.mEnd = end;
            this.mEntityScores = entityConfidence;
            this.mUrlSpan = urlSpan;
            this.mExtras = extras;
        }

        public int getStart() {
            return this.mStart;
        }

        public int getEnd() {
            return this.mEnd;
        }

        public int getEntityCount() {
            return this.mEntityScores.getEntities().size();
        }

        public String getEntity(int index) {
            return this.mEntityScores.getEntities().get(index);
        }

        public float getConfidenceScore(String entityType) {
            return this.mEntityScores.getConfidenceScore(entityType);
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public String toString() {
            return String.format(Locale.US, "TextLink{start=%s, end=%s, entityScores=%s, urlSpan=%s}", this.mStart, this.mEnd, this.mEntityScores, this.mUrlSpan);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.mEntityScores.writeToParcel(dest, flags);
            dest.writeInt(this.mStart);
            dest.writeInt(this.mEnd);
            dest.writeBundle(this.mExtras);
        }

        private static TextLink readFromParcel(Parcel in) {
            EntityConfidence entityConfidence = EntityConfidence.CREATOR.createFromParcel(in);
            int start = in.readInt();
            int end = in.readInt();
            Bundle extras = in.readBundle();
            return new TextLink(start, end, entityConfidence, extras, null);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApplyStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

