/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.icu.text.DisplayContext;
import android.icu.text.RelativeDateTimeFormatter;
import android.icu.text.SimpleDateFormat;
import android.icu.util.Calendar;
import android.os.Bundle;
import android.text.TextPaint;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.util.IntArray;
import android.util.MathUtils;
import android.util.StateSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.R;
import com.android.internal.widget.ExploreByTouchHelper;
import java.text.NumberFormat;
import java.util.Locale;
import libcore.icu.LocaleData;

class SimpleMonthView
extends View {
    private static final int DAYS_IN_WEEK = 7;
    private static final int MAX_WEEKS_IN_MONTH = 6;
    private static final int DEFAULT_SELECTED_DAY = -1;
    private static final int DEFAULT_WEEK_START = 1;
    private static final String MONTH_YEAR_FORMAT = "MMMMy";
    private static final int SELECTED_HIGHLIGHT_ALPHA = 176;
    private final TextPaint mMonthPaint = new TextPaint();
    private final TextPaint mDayOfWeekPaint = new TextPaint();
    private final TextPaint mDayPaint = new TextPaint();
    private final Paint mDaySelectorPaint = new Paint();
    private final Paint mDayHighlightPaint = new Paint();
    private final Paint mDayHighlightSelectorPaint = new Paint();
    private final String[] mDayOfWeekLabels = new String[7];
    private final Calendar mCalendar;
    private final Locale mLocale;
    private final MonthViewTouchHelper mTouchHelper;
    private final NumberFormat mDayFormatter;
    private final int mDesiredMonthHeight;
    private final int mDesiredDayOfWeekHeight;
    private final int mDesiredDayHeight;
    private final int mDesiredCellWidth;
    private final int mDesiredDaySelectorRadius;
    private String mMonthYearLabel;
    private int mMonth;
    private int mYear;
    private int mMonthHeight;
    private int mDayOfWeekHeight;
    private int mDayHeight;
    private int mCellWidth;
    private int mDaySelectorRadius;
    private int mPaddedWidth;
    private int mPaddedHeight;
    private int mActivatedDay = -1;
    private int mToday = -1;
    private int mWeekStart = 1;
    private int mDaysInMonth;
    private int mDayOfWeekStart;
    private int mEnabledDayStart = 1;
    private int mEnabledDayEnd = 31;
    private OnDayClickListener mOnDayClickListener;
    private ColorStateList mDayTextColor;
    private int mHighlightedDay = -1;
    private int mPreviouslyHighlightedDay = -1;
    private boolean mIsTouchHighlighted = false;

    public SimpleMonthView(Context context) {
        this(context, null);
    }

    public SimpleMonthView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843612);
    }

    public SimpleMonthView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public SimpleMonthView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Resources res = context.getResources();
        this.mDesiredMonthHeight = res.getDimensionPixelSize(17105125);
        this.mDesiredDayOfWeekHeight = res.getDimensionPixelSize(17105120);
        this.mDesiredDayHeight = res.getDimensionPixelSize(17105119);
        this.mDesiredCellWidth = res.getDimensionPixelSize(17105124);
        this.mDesiredDaySelectorRadius = res.getDimensionPixelSize(17105122);
        this.mTouchHelper = new MonthViewTouchHelper(this);
        this.setAccessibilityDelegate(this.mTouchHelper);
        this.setImportantForAccessibility(1);
        this.mLocale = res.getConfiguration().locale;
        this.mCalendar = Calendar.getInstance(this.mLocale);
        this.mDayFormatter = NumberFormat.getIntegerInstance(this.mLocale);
        this.updateMonthYearLabel();
        this.updateDayOfWeekLabels();
        this.initPaints(res);
    }

    private void updateMonthYearLabel() {
        String format = DateFormat.getBestDateTimePattern(this.mLocale, MONTH_YEAR_FORMAT);
        SimpleDateFormat formatter = new SimpleDateFormat(format, this.mLocale);
        formatter.setContext(DisplayContext.CAPITALIZATION_FOR_STANDALONE);
        this.mMonthYearLabel = formatter.format(this.mCalendar.getTime());
    }

    private void updateDayOfWeekLabels() {
        String[] tinyWeekdayNames = LocaleData.get((Locale)this.mLocale).tinyWeekdayNames;
        for (int i = 0; i < 7; ++i) {
            this.mDayOfWeekLabels[i] = tinyWeekdayNames[(this.mWeekStart + i - 1) % 7 + 1];
        }
    }

    private ColorStateList applyTextAppearance(Paint p, int resId) {
        TypedArray ta = this.mContext.obtainStyledAttributes(null, R.styleable.TextAppearance, 0, resId);
        String fontFamily = ta.getString(12);
        if (fontFamily != null) {
            p.setTypeface(Typeface.create(fontFamily, 0));
        }
        p.setTextSize(ta.getDimensionPixelSize(0, (int)p.getTextSize()));
        ColorStateList textColor = ta.getColorStateList(3);
        if (textColor != null) {
            int enabledColor = textColor.getColorForState(ENABLED_STATE_SET, 0);
            p.setColor(enabledColor);
        }
        ta.recycle();
        return textColor;
    }

    public int getMonthHeight() {
        return this.mMonthHeight;
    }

    public int getCellWidth() {
        return this.mCellWidth;
    }

    public void setMonthTextAppearance(int resId) {
        this.applyTextAppearance(this.mMonthPaint, resId);
        this.invalidate();
    }

    public void setDayOfWeekTextAppearance(int resId) {
        this.applyTextAppearance(this.mDayOfWeekPaint, resId);
        this.invalidate();
    }

    public void setDayTextAppearance(int resId) {
        ColorStateList textColor = this.applyTextAppearance(this.mDayPaint, resId);
        if (textColor != null) {
            this.mDayTextColor = textColor;
        }
        this.invalidate();
    }

    private void initPaints(Resources res) {
        String monthTypeface = res.getString(17040031);
        String dayOfWeekTypeface = res.getString(17040021);
        String dayTypeface = res.getString(17040022);
        int monthTextSize = res.getDimensionPixelSize(17105126);
        int dayOfWeekTextSize = res.getDimensionPixelSize(17105121);
        int dayTextSize = res.getDimensionPixelSize(17105123);
        this.mMonthPaint.setAntiAlias(true);
        this.mMonthPaint.setTextSize(monthTextSize);
        this.mMonthPaint.setTypeface(Typeface.create(monthTypeface, 0));
        this.mMonthPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthPaint.setStyle(Paint.Style.FILL);
        this.mDayOfWeekPaint.setAntiAlias(true);
        this.mDayOfWeekPaint.setTextSize(dayOfWeekTextSize);
        this.mDayOfWeekPaint.setTypeface(Typeface.create(dayOfWeekTypeface, 0));
        this.mDayOfWeekPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayOfWeekPaint.setStyle(Paint.Style.FILL);
        this.mDaySelectorPaint.setAntiAlias(true);
        this.mDaySelectorPaint.setStyle(Paint.Style.FILL);
        this.mDayHighlightPaint.setAntiAlias(true);
        this.mDayHighlightPaint.setStyle(Paint.Style.FILL);
        this.mDayHighlightSelectorPaint.setAntiAlias(true);
        this.mDayHighlightSelectorPaint.setStyle(Paint.Style.FILL);
        this.mDayPaint.setAntiAlias(true);
        this.mDayPaint.setTextSize(dayTextSize);
        this.mDayPaint.setTypeface(Typeface.create(dayTypeface, 0));
        this.mDayPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayPaint.setStyle(Paint.Style.FILL);
    }

    void setMonthTextColor(ColorStateList monthTextColor) {
        int enabledColor = monthTextColor.getColorForState(ENABLED_STATE_SET, 0);
        this.mMonthPaint.setColor(enabledColor);
        this.invalidate();
    }

    void setDayOfWeekTextColor(ColorStateList dayOfWeekTextColor) {
        int enabledColor = dayOfWeekTextColor.getColorForState(ENABLED_STATE_SET, 0);
        this.mDayOfWeekPaint.setColor(enabledColor);
        this.invalidate();
    }

    void setDayTextColor(ColorStateList dayTextColor) {
        this.mDayTextColor = dayTextColor;
        this.invalidate();
    }

    void setDaySelectorColor(ColorStateList dayBackgroundColor) {
        int activatedColor = dayBackgroundColor.getColorForState(StateSet.get(40), 0);
        this.mDaySelectorPaint.setColor(activatedColor);
        this.mDayHighlightSelectorPaint.setColor(activatedColor);
        this.mDayHighlightSelectorPaint.setAlpha(176);
        this.invalidate();
    }

    void setDayHighlightColor(ColorStateList dayHighlightColor) {
        int pressedColor = dayHighlightColor.getColorForState(StateSet.get(24), 0);
        this.mDayHighlightPaint.setColor(pressedColor);
        this.invalidate();
    }

    public void setOnDayClickListener(OnDayClickListener listener) {
        this.mOnDayClickListener = listener;
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent event) {
        return this.mTouchHelper.dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)(event.getX() + 0.5f);
        int y = (int)(event.getY() + 0.5f);
        int action = event.getAction();
        switch (action) {
            case 0: 
            case 2: {
                int touchedItem = this.getDayAtLocation(x, y);
                this.mIsTouchHighlighted = true;
                if (this.mHighlightedDay != touchedItem) {
                    this.mHighlightedDay = touchedItem;
                    this.mPreviouslyHighlightedDay = touchedItem;
                    this.invalidate();
                }
                if (action != 0 || touchedItem >= 0) break;
                return false;
            }
            case 1: {
                int clickedDay = this.getDayAtLocation(x, y);
                this.onDayClicked(clickedDay);
            }
            case 3: {
                this.mHighlightedDay = -1;
                this.mIsTouchHighlighted = false;
                this.invalidate();
            }
        }
        return true;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean focusChanged = false;
        switch (event.getKeyCode()) {
            case 21: {
                if (!event.hasNoModifiers()) break;
                focusChanged = this.moveOneDay(this.isLayoutRtl());
                break;
            }
            case 22: {
                if (!event.hasNoModifiers()) break;
                focusChanged = this.moveOneDay(!this.isLayoutRtl());
                break;
            }
            case 19: {
                if (!event.hasNoModifiers()) break;
                this.ensureFocusedDay();
                if (this.mHighlightedDay <= 7) break;
                this.mHighlightedDay -= 7;
                focusChanged = true;
                break;
            }
            case 20: {
                if (!event.hasNoModifiers()) break;
                this.ensureFocusedDay();
                if (this.mHighlightedDay > this.mDaysInMonth - 7) break;
                this.mHighlightedDay += 7;
                focusChanged = true;
                break;
            }
            case 23: 
            case 66: 
            case 160: {
                if (this.mHighlightedDay == -1) break;
                this.onDayClicked(this.mHighlightedDay);
                return true;
            }
            case 61: {
                int focusChangeDirection = 0;
                if (event.hasNoModifiers()) {
                    focusChangeDirection = 2;
                } else if (event.hasModifiers(1)) {
                    focusChangeDirection = 1;
                }
                if (focusChangeDirection == 0) break;
                ViewParent parent = this.getParent();
                View nextFocus = this;
                while ((nextFocus = nextFocus.focusSearch(focusChangeDirection)) != null && nextFocus != this && nextFocus.getParent() == parent) {
                }
                if (nextFocus == null) break;
                nextFocus.requestFocus();
                return true;
            }
        }
        if (focusChanged) {
            this.invalidate();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private boolean moveOneDay(boolean positive) {
        this.ensureFocusedDay();
        boolean focusChanged = false;
        if (positive) {
            if (!this.isLastDayOfWeek(this.mHighlightedDay) && this.mHighlightedDay < this.mDaysInMonth) {
                ++this.mHighlightedDay;
                focusChanged = true;
            }
        } else if (!this.isFirstDayOfWeek(this.mHighlightedDay) && this.mHighlightedDay > 1) {
            --this.mHighlightedDay;
            focusChanged = true;
        }
        return focusChanged;
    }

    @Override
    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        if (gainFocus) {
            int offset = this.findDayOffset();
            switch (direction) {
                case 66: {
                    int row = this.findClosestRow(previouslyFocusedRect);
                    this.mHighlightedDay = row == 0 ? 1 : row * 7 - offset + 1;
                    break;
                }
                case 17: {
                    int row = this.findClosestRow(previouslyFocusedRect) + 1;
                    this.mHighlightedDay = Math.min(this.mDaysInMonth, row * 7 - offset);
                    break;
                }
                case 130: {
                    int col = this.findClosestColumn(previouslyFocusedRect);
                    int day = col - offset + 1;
                    this.mHighlightedDay = day < 1 ? day + 7 : day;
                    break;
                }
                case 33: {
                    int col = this.findClosestColumn(previouslyFocusedRect);
                    int maxWeeks = (offset + this.mDaysInMonth) / 7;
                    int day = col - offset + 7 * maxWeeks + 1;
                    this.mHighlightedDay = day > this.mDaysInMonth ? day - 7 : day;
                    break;
                }
            }
            this.ensureFocusedDay();
            this.invalidate();
        }
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
    }

    private int findClosestRow(Rect previouslyFocusedRect) {
        if (previouslyFocusedRect == null) {
            return 3;
        }
        if (this.mDayHeight == 0) {
            return 0;
        }
        int centerY = previouslyFocusedRect.centerY();
        TextPaint p = this.mDayPaint;
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int rowHeight = this.mDayHeight;
        float halfLineHeight = (p.ascent() + p.descent()) / 2.0f;
        int rowCenter = headerHeight + rowHeight / 2;
        centerY = (int)((float)centerY - ((float)rowCenter - halfLineHeight));
        int row = Math.round((float)centerY / (float)rowHeight);
        int maxDay = this.findDayOffset() + this.mDaysInMonth;
        int maxRows = maxDay / 7 - (maxDay % 7 == 0 ? 1 : 0);
        row = MathUtils.constrain(row, 0, maxRows);
        return row;
    }

    private int findClosestColumn(Rect previouslyFocusedRect) {
        if (previouslyFocusedRect == null) {
            return 3;
        }
        if (this.mCellWidth == 0) {
            return 0;
        }
        int centerX = previouslyFocusedRect.centerX() - this.mPaddingLeft;
        int columnFromLeft = MathUtils.constrain(centerX / this.mCellWidth, 0, 6);
        return this.isLayoutRtl() ? 7 - columnFromLeft - 1 : columnFromLeft;
    }

    @Override
    public void getFocusedRect(Rect r) {
        if (this.mHighlightedDay > 0) {
            this.getBoundsForDay(this.mHighlightedDay, r);
        } else {
            super.getFocusedRect(r);
        }
    }

    @Override
    protected void onFocusLost() {
        if (!this.mIsTouchHighlighted) {
            this.mPreviouslyHighlightedDay = this.mHighlightedDay;
            this.mHighlightedDay = -1;
            this.invalidate();
        }
        super.onFocusLost();
    }

    private void ensureFocusedDay() {
        if (this.mHighlightedDay != -1) {
            return;
        }
        if (this.mPreviouslyHighlightedDay != -1) {
            this.mHighlightedDay = this.mPreviouslyHighlightedDay;
            return;
        }
        if (this.mActivatedDay != -1) {
            this.mHighlightedDay = this.mActivatedDay;
            return;
        }
        this.mHighlightedDay = 1;
    }

    private boolean isFirstDayOfWeek(int day) {
        int offset = this.findDayOffset();
        return (offset + day - 1) % 7 == 0;
    }

    private boolean isLastDayOfWeek(int day) {
        int offset = this.findDayOffset();
        return (offset + day) % 7 == 0;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        canvas.translate(paddingLeft, paddingTop);
        this.drawMonth(canvas);
        this.drawDaysOfWeek(canvas);
        this.drawDays(canvas);
        canvas.translate(-paddingLeft, -paddingTop);
    }

    private void drawMonth(Canvas canvas) {
        float x = (float)this.mPaddedWidth / 2.0f;
        float lineHeight = this.mMonthPaint.ascent() + this.mMonthPaint.descent();
        float y = ((float)this.mMonthHeight - lineHeight) / 2.0f;
        canvas.drawText(this.mMonthYearLabel, x, y, this.mMonthPaint);
    }

    public String getMonthYearLabel() {
        return this.mMonthYearLabel;
    }

    private void drawDaysOfWeek(Canvas canvas) {
        TextPaint p = this.mDayOfWeekPaint;
        int headerHeight = this.mMonthHeight;
        int rowHeight = this.mDayOfWeekHeight;
        int colWidth = this.mCellWidth;
        float halfLineHeight = (p.ascent() + p.descent()) / 2.0f;
        int rowCenter = headerHeight + rowHeight / 2;
        for (int col = 0; col < 7; ++col) {
            int colCenter = colWidth * col + colWidth / 2;
            int colCenterRtl = this.isLayoutRtl() ? this.mPaddedWidth - colCenter : colCenter;
            String label = this.mDayOfWeekLabels[col];
            canvas.drawText(label, colCenterRtl, (float)rowCenter - halfLineHeight, p);
        }
    }

    private void drawDays(Canvas canvas) {
        TextPaint p = this.mDayPaint;
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int rowHeight = this.mDayHeight;
        int colWidth = this.mCellWidth;
        float halfLineHeight = (p.ascent() + p.descent()) / 2.0f;
        int rowCenter = headerHeight + rowHeight / 2;
        int col = this.findDayOffset();
        for (int day = 1; day <= this.mDaysInMonth; ++day) {
            int dayTextColor;
            boolean isDayToday;
            boolean isDayHighlighted;
            int colCenter = colWidth * col + colWidth / 2;
            int colCenterRtl = this.isLayoutRtl() ? this.mPaddedWidth - colCenter : colCenter;
            int stateMask = 0;
            boolean isDayEnabled = this.isDayEnabled(day);
            if (isDayEnabled) {
                stateMask |= 8;
            }
            boolean isDayActivated = this.mActivatedDay == day;
            boolean bl = isDayHighlighted = this.mHighlightedDay == day;
            if (isDayActivated) {
                stateMask |= 0x20;
                Paint paint = isDayHighlighted ? this.mDayHighlightSelectorPaint : this.mDaySelectorPaint;
                canvas.drawCircle(colCenterRtl, rowCenter, this.mDaySelectorRadius, paint);
            } else if (isDayHighlighted) {
                stateMask |= 0x10;
                if (isDayEnabled) {
                    canvas.drawCircle(colCenterRtl, rowCenter, this.mDaySelectorRadius, this.mDayHighlightPaint);
                }
            }
            boolean bl2 = isDayToday = this.mToday == day;
            if (isDayToday && !isDayActivated) {
                dayTextColor = this.mDaySelectorPaint.getColor();
            } else {
                int[] stateSet = StateSet.get(stateMask);
                dayTextColor = this.mDayTextColor.getColorForState(stateSet, 0);
            }
            p.setColor(dayTextColor);
            canvas.drawText(this.mDayFormatter.format(day), colCenterRtl, (float)rowCenter - halfLineHeight, p);
            if (++col != 7) continue;
            col = 0;
            rowCenter += rowHeight;
        }
    }

    private boolean isDayEnabled(int day) {
        return day >= this.mEnabledDayStart && day <= this.mEnabledDayEnd;
    }

    private boolean isValidDayOfMonth(int day) {
        return day >= 1 && day <= this.mDaysInMonth;
    }

    private static boolean isValidDayOfWeek(int day) {
        return day >= 1 && day <= 7;
    }

    private static boolean isValidMonth(int month) {
        return month >= 0 && month <= 11;
    }

    public void setSelectedDay(int dayOfMonth) {
        this.mActivatedDay = dayOfMonth;
        this.mTouchHelper.invalidateRoot();
        this.invalidate();
    }

    public void setFirstDayOfWeek(int weekStart) {
        this.mWeekStart = SimpleMonthView.isValidDayOfWeek(weekStart) ? weekStart : this.mCalendar.getFirstDayOfWeek();
        this.updateDayOfWeekLabels();
        this.mTouchHelper.invalidateRoot();
        this.invalidate();
    }

    void setMonthParams(int selectedDay, int month, int year, int weekStart, int enabledDayStart, int enabledDayEnd) {
        this.mActivatedDay = selectedDay;
        if (SimpleMonthView.isValidMonth(month)) {
            this.mMonth = month;
        }
        this.mYear = year;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = SimpleMonthView.isValidDayOfWeek(weekStart) ? weekStart : this.mCalendar.getFirstDayOfWeek();
        Calendar today = Calendar.getInstance();
        this.mToday = -1;
        this.mDaysInMonth = SimpleMonthView.getDaysInMonth(this.mMonth, this.mYear);
        for (int i = 0; i < this.mDaysInMonth; ++i) {
            int day = i + 1;
            if (!this.sameDay(day, today)) continue;
            this.mToday = day;
        }
        this.mEnabledDayStart = MathUtils.constrain(enabledDayStart, 1, this.mDaysInMonth);
        this.mEnabledDayEnd = MathUtils.constrain(enabledDayEnd, this.mEnabledDayStart, this.mDaysInMonth);
        this.updateMonthYearLabel();
        this.updateDayOfWeekLabels();
        this.mTouchHelper.invalidateRoot();
        this.invalidate();
    }

    private static int getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    private boolean sameDay(int day, Calendar today) {
        return this.mYear == today.get(1) && this.mMonth == today.get(2) && day == today.get(5);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int preferredHeight = this.mDesiredDayHeight * 6 + this.mDesiredDayOfWeekHeight + this.mDesiredMonthHeight + this.getPaddingTop() + this.getPaddingBottom();
        int preferredWidth = this.mDesiredCellWidth * 7 + this.getPaddingStart() + this.getPaddingEnd();
        int resolvedWidth = SimpleMonthView.resolveSize(preferredWidth, widthMeasureSpec);
        int resolvedHeight = SimpleMonthView.resolveSize(preferredHeight, heightMeasureSpec);
        this.setMeasuredDimension(resolvedWidth, resolvedHeight);
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.requestLayout();
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!changed) {
            return;
        }
        int w = right - left;
        int h = bottom - top;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int paddedRight = w - paddingRight;
        int paddedBottom = h - paddingBottom;
        int paddedWidth = paddedRight - paddingLeft;
        int paddedHeight = paddedBottom - paddingTop;
        if (paddedWidth == this.mPaddedWidth || paddedHeight == this.mPaddedHeight) {
            return;
        }
        this.mPaddedWidth = paddedWidth;
        this.mPaddedHeight = paddedHeight;
        int measuredPaddedHeight = this.getMeasuredHeight() - paddingTop - paddingBottom;
        float scaleH = (float)paddedHeight / (float)measuredPaddedHeight;
        int monthHeight = (int)((float)this.mDesiredMonthHeight * scaleH);
        int cellWidth = this.mPaddedWidth / 7;
        this.mMonthHeight = monthHeight;
        this.mDayOfWeekHeight = (int)((float)this.mDesiredDayOfWeekHeight * scaleH);
        this.mDayHeight = (int)((float)this.mDesiredDayHeight * scaleH);
        this.mCellWidth = cellWidth;
        int maxSelectorWidth = cellWidth / 2 + Math.min(paddingLeft, paddingRight);
        int maxSelectorHeight = this.mDayHeight / 2 + paddingBottom;
        this.mDaySelectorRadius = Math.min(this.mDesiredDaySelectorRadius, Math.min(maxSelectorWidth, maxSelectorHeight));
        this.mTouchHelper.invalidateRoot();
    }

    private int findDayOffset() {
        int offset = this.mDayOfWeekStart - this.mWeekStart;
        if (this.mDayOfWeekStart < this.mWeekStart) {
            return offset + 7;
        }
        return offset;
    }

    private int getDayAtLocation(int x, int y) {
        int row;
        int paddedX = x - this.getPaddingLeft();
        if (paddedX < 0 || paddedX >= this.mPaddedWidth) {
            return -1;
        }
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int paddedY = y - this.getPaddingTop();
        if (paddedY < headerHeight || paddedY >= this.mPaddedHeight) {
            return -1;
        }
        int paddedXRtl = this.isLayoutRtl() ? this.mPaddedWidth - paddedX : paddedX;
        int col = paddedXRtl * 7 / this.mPaddedWidth;
        int index = col + (row = (paddedY - headerHeight) / this.mDayHeight) * 7;
        int day = index + 1 - this.findDayOffset();
        if (!this.isValidDayOfMonth(day)) {
            return -1;
        }
        return day;
    }

    public boolean getBoundsForDay(int id2, Rect outBounds) {
        if (!this.isValidDayOfMonth(id2)) {
            return false;
        }
        int index = id2 - 1 + this.findDayOffset();
        int col = index % 7;
        int colWidth = this.mCellWidth;
        int left = this.isLayoutRtl() ? this.getWidth() - this.getPaddingRight() - (col + 1) * colWidth : this.getPaddingLeft() + col * colWidth;
        int row = index / 7;
        int rowHeight = this.mDayHeight;
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int top = this.getPaddingTop() + headerHeight + row * rowHeight;
        outBounds.set(left, top, left + colWidth, top + rowHeight);
        return true;
    }

    private boolean onDayClicked(int day) {
        if (!this.isValidDayOfMonth(day) || !this.isDayEnabled(day)) {
            return false;
        }
        if (this.mOnDayClickListener != null) {
            Calendar date = Calendar.getInstance();
            date.set(this.mYear, this.mMonth, day);
            this.mOnDayClickListener.onDayClick(this, date);
        }
        this.mTouchHelper.sendEventForVirtualView(day, 1);
        return true;
    }

    @Override
    public PointerIcon onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        int y;
        if (!this.isEnabled()) {
            return null;
        }
        int x = (int)(event.getX() + 0.5f);
        int dayUnderPointer = this.getDayAtLocation(x, y = (int)(event.getY() + 0.5f));
        if (dayUnderPointer >= 0) {
            return PointerIcon.getSystemIcon(this.getContext(), 1002);
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    public static interface OnDayClickListener {
        public void onDayClick(SimpleMonthView var1, Calendar var2);
    }

    private class MonthViewTouchHelper
    extends ExploreByTouchHelper {
        private static final String DATE_FORMAT = "dd MMMM yyyy";
        private final Rect mTempRect;
        private final Calendar mTempCalendar;

        public MonthViewTouchHelper(View host) {
            super(host);
            this.mTempRect = new Rect();
            this.mTempCalendar = Calendar.getInstance();
        }

        @Override
        protected int getVirtualViewAt(float x, float y) {
            int day = SimpleMonthView.this.getDayAtLocation((int)(x + 0.5f), (int)(y + 0.5f));
            if (day != -1) {
                return day;
            }
            return Integer.MIN_VALUE;
        }

        @Override
        protected void getVisibleVirtualViews(IntArray virtualViewIds) {
            for (int day = 1; day <= SimpleMonthView.this.mDaysInMonth; ++day) {
                virtualViewIds.add(day);
            }
        }

        @Override
        protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            event.setContentDescription(this.getDayDescription(virtualViewId));
        }

        @Override
        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfo node) {
            boolean hasBounds = SimpleMonthView.this.getBoundsForDay(virtualViewId, this.mTempRect);
            if (!hasBounds) {
                this.mTempRect.setEmpty();
                node.setContentDescription("");
                node.setBoundsInParent(this.mTempRect);
                node.setVisibleToUser(false);
                return;
            }
            node.setText(this.getDayText(virtualViewId));
            node.setContentDescription(this.getDayDescription(virtualViewId));
            if (virtualViewId == SimpleMonthView.this.mToday) {
                RelativeDateTimeFormatter fmt = RelativeDateTimeFormatter.getInstance();
                node.setStateDescription(fmt.format(RelativeDateTimeFormatter.Direction.THIS, RelativeDateTimeFormatter.AbsoluteUnit.DAY));
            }
            if (virtualViewId == SimpleMonthView.this.mActivatedDay) {
                node.setSelected(true);
            }
            node.setBoundsInParent(this.mTempRect);
            boolean isDayEnabled = SimpleMonthView.this.isDayEnabled(virtualViewId);
            if (isDayEnabled) {
                node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
            }
            node.setEnabled(isDayEnabled);
            node.setClickable(true);
            if (virtualViewId == SimpleMonthView.this.mActivatedDay) {
                node.setChecked(true);
            }
        }

        @Override
        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            switch (action) {
                case 16: {
                    return SimpleMonthView.this.onDayClicked(virtualViewId);
                }
            }
            return false;
        }

        private CharSequence getDayDescription(int id2) {
            if (SimpleMonthView.this.isValidDayOfMonth(id2)) {
                this.mTempCalendar.set(SimpleMonthView.this.mYear, SimpleMonthView.this.mMonth, id2);
                return DateFormat.format((CharSequence)DATE_FORMAT, this.mTempCalendar.getTimeInMillis());
            }
            return "";
        }

        private CharSequence getDayText(int id2) {
            if (SimpleMonthView.this.isValidDayOfMonth(id2)) {
                return SimpleMonthView.this.mDayFormatter.format(id2);
            }
            return null;
        }
    }
}

