/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.WindowConfiguration;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.view.SurfaceControl;
import android.window.WindowContainerToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WindowContainerTransaction
implements Parcelable {
    private final ArrayMap<IBinder, Change> mChanges = new ArrayMap();
    private final ArrayList<HierarchyOp> mHierarchyOps = new ArrayList();
    public static final Parcelable.Creator<WindowContainerTransaction> CREATOR = new Parcelable.Creator<WindowContainerTransaction>(){

        @Override
        public WindowContainerTransaction createFromParcel(Parcel in) {
            return new WindowContainerTransaction(in);
        }

        public WindowContainerTransaction[] newArray(int size) {
            return new WindowContainerTransaction[size];
        }
    };

    public WindowContainerTransaction() {
    }

    private WindowContainerTransaction(Parcel in) {
        in.readMap(this.mChanges, null);
        in.readList(this.mHierarchyOps, null);
    }

    private Change getOrCreateChange(IBinder token) {
        Change out = this.mChanges.get(token);
        if (out == null) {
            out = new Change();
            this.mChanges.put(token, out);
        }
        return out;
    }

    public WindowContainerTransaction setBounds(WindowContainerToken container, Rect bounds) {
        Change chg = this.getOrCreateChange(container.asBinder());
        ((Change)chg).mConfiguration.windowConfiguration.setBounds(bounds);
        chg.mConfigSetMask |= 0x20000000;
        chg.mWindowSetMask |= 1;
        return this;
    }

    public WindowContainerTransaction setAppBounds(WindowContainerToken container, Rect appBounds) {
        Change chg = this.getOrCreateChange(container.asBinder());
        ((Change)chg).mConfiguration.windowConfiguration.setAppBounds(appBounds);
        chg.mConfigSetMask |= 0x20000000;
        chg.mWindowSetMask |= 2;
        return this;
    }

    public WindowContainerTransaction setScreenSizeDp(WindowContainerToken container, int w, int h) {
        Change chg = this.getOrCreateChange(container.asBinder());
        ((Change)chg).mConfiguration.screenWidthDp = w;
        ((Change)chg).mConfiguration.screenHeightDp = h;
        chg.mConfigSetMask |= 1024;
        return this;
    }

    public WindowContainerTransaction scheduleFinishEnterPip(WindowContainerToken container, Rect bounds) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mPinnedBounds = new Rect(bounds);
        chg.mChangeMask |= 4;
        return this;
    }

    public WindowContainerTransaction setBoundsChangeTransaction(WindowContainerToken container, SurfaceControl.Transaction t) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mBoundsChangeTransaction = t;
        chg.mChangeMask |= 2;
        return this;
    }

    public WindowContainerTransaction setBoundsChangeTransaction(WindowContainerToken task, Rect surfaceBounds) {
        Change chg = this.getOrCreateChange(task.asBinder());
        if (chg.mBoundsChangeSurfaceBounds == null) {
            chg.mBoundsChangeSurfaceBounds = new Rect();
        }
        chg.mBoundsChangeSurfaceBounds.set(surfaceBounds);
        chg.mChangeMask |= 16;
        return this;
    }

    public WindowContainerTransaction setActivityWindowingMode(WindowContainerToken container, int windowingMode) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mActivityWindowingMode = windowingMode;
        return this;
    }

    public WindowContainerTransaction setWindowingMode(WindowContainerToken container, int windowingMode) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mWindowingMode = windowingMode;
        return this;
    }

    public WindowContainerTransaction setFocusable(WindowContainerToken container, boolean focusable) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mFocusable = focusable;
        chg.mChangeMask |= 1;
        return this;
    }

    public WindowContainerTransaction setHidden(WindowContainerToken container, boolean hidden) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mHidden = hidden;
        chg.mChangeMask |= 8;
        return this;
    }

    public WindowContainerTransaction setSmallestScreenWidthDp(WindowContainerToken container, int widthDp) {
        Change cfg = this.getOrCreateChange(container.asBinder());
        ((Change)cfg).mConfiguration.smallestScreenWidthDp = widthDp;
        cfg.mConfigSetMask |= 2048;
        return this;
    }

    public WindowContainerTransaction reparent(WindowContainerToken child, WindowContainerToken parent, boolean onTop) {
        this.mHierarchyOps.add(new HierarchyOp(child.asBinder(), parent == null ? null : parent.asBinder(), onTop));
        return this;
    }

    public WindowContainerTransaction reorder(WindowContainerToken child, boolean onTop) {
        this.mHierarchyOps.add(new HierarchyOp(child.asBinder(), onTop));
        return this;
    }

    public void merge(WindowContainerTransaction other, boolean transfer) {
        int i;
        int n = other.mChanges.size();
        for (i = 0; i < n; ++i) {
            IBinder key = other.mChanges.keyAt(i);
            Change existing = this.mChanges.get(key);
            if (existing == null) {
                existing = new Change();
                this.mChanges.put(key, existing);
            }
            existing.merge(other.mChanges.valueAt(i), transfer);
        }
        n = other.mHierarchyOps.size();
        for (i = 0; i < n; ++i) {
            this.mHierarchyOps.add(transfer ? other.mHierarchyOps.get(i) : new HierarchyOp(other.mHierarchyOps.get(i)));
        }
    }

    public Map<IBinder, Change> getChanges() {
        return this.mChanges;
    }

    public List<HierarchyOp> getHierarchyOps() {
        return this.mHierarchyOps;
    }

    public String toString() {
        return "WindowContainerTransaction { changes = " + this.mChanges + " hops = " + this.mHierarchyOps + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeMap(this.mChanges);
        dest.writeList(this.mHierarchyOps);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class HierarchyOp
    implements Parcelable {
        private final IBinder mContainer;
        private final IBinder mReparent;
        private final boolean mToTop;
        public static final Parcelable.Creator<HierarchyOp> CREATOR = new Parcelable.Creator<HierarchyOp>(){

            @Override
            public HierarchyOp createFromParcel(Parcel in) {
                return new HierarchyOp(in);
            }

            public HierarchyOp[] newArray(int size) {
                return new HierarchyOp[size];
            }
        };

        public HierarchyOp(IBinder container, IBinder reparent, boolean toTop) {
            this.mContainer = container;
            this.mReparent = reparent;
            this.mToTop = toTop;
        }

        public HierarchyOp(IBinder container, boolean toTop) {
            this.mContainer = container;
            this.mReparent = container;
            this.mToTop = toTop;
        }

        public HierarchyOp(HierarchyOp copy) {
            this.mContainer = copy.mContainer;
            this.mReparent = copy.mReparent;
            this.mToTop = copy.mToTop;
        }

        protected HierarchyOp(Parcel in) {
            this.mContainer = in.readStrongBinder();
            this.mReparent = in.readStrongBinder();
            this.mToTop = in.readBoolean();
        }

        public boolean isReparent() {
            return this.mContainer != this.mReparent;
        }

        public IBinder getNewParent() {
            return this.mReparent;
        }

        public IBinder getContainer() {
            return this.mContainer;
        }

        public boolean getToTop() {
            return this.mToTop;
        }

        public String toString() {
            if (this.isReparent()) {
                return "{reparent: " + this.mContainer + " to " + (this.mToTop ? "top of " : "bottom of ") + this.mReparent + "}";
            }
            return "{reorder: " + this.mContainer + " to " + (this.mToTop ? "top" : "bottom") + "}";
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeStrongBinder(this.mContainer);
            dest.writeStrongBinder(this.mReparent);
            dest.writeBoolean(this.mToTop);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static class Change
    implements Parcelable {
        public static final int CHANGE_FOCUSABLE = 1;
        public static final int CHANGE_BOUNDS_TRANSACTION = 2;
        public static final int CHANGE_PIP_CALLBACK = 4;
        public static final int CHANGE_HIDDEN = 8;
        public static final int CHANGE_BOUNDS_TRANSACTION_RECT = 16;
        private final Configuration mConfiguration = new Configuration();
        private boolean mFocusable = true;
        private boolean mHidden = false;
        private int mChangeMask = 0;
        private int mConfigSetMask = 0;
        @WindowConfiguration.WindowConfig
        private int mWindowSetMask = 0;
        private Rect mPinnedBounds = null;
        private SurfaceControl.Transaction mBoundsChangeTransaction = null;
        private Rect mBoundsChangeSurfaceBounds = null;
        private int mActivityWindowingMode = -1;
        private int mWindowingMode = -1;
        public static final Parcelable.Creator<Change> CREATOR = new Parcelable.Creator<Change>(){

            @Override
            public Change createFromParcel(Parcel in) {
                return new Change(in);
            }

            public Change[] newArray(int size) {
                return new Change[size];
            }
        };

        public Change() {
        }

        protected Change(Parcel in) {
            this.mConfiguration.readFromParcel(in);
            this.mFocusable = in.readBoolean();
            this.mHidden = in.readBoolean();
            this.mChangeMask = in.readInt();
            this.mConfigSetMask = in.readInt();
            this.mWindowSetMask = in.readInt();
            if ((this.mChangeMask & 4) != 0) {
                this.mPinnedBounds = new Rect();
                this.mPinnedBounds.readFromParcel(in);
            }
            if ((this.mChangeMask & 2) != 0) {
                this.mBoundsChangeTransaction = SurfaceControl.Transaction.CREATOR.createFromParcel(in);
            }
            if ((this.mChangeMask & 0x10) != 0) {
                this.mBoundsChangeSurfaceBounds = new Rect();
                this.mBoundsChangeSurfaceBounds.readFromParcel(in);
            }
            this.mWindowingMode = in.readInt();
            this.mActivityWindowingMode = in.readInt();
        }

        public void merge(Change other, boolean transfer) {
            this.mConfiguration.setTo(other.mConfiguration, other.mConfigSetMask, other.mWindowSetMask);
            this.mConfigSetMask |= other.mConfigSetMask;
            this.mWindowSetMask |= other.mWindowSetMask;
            if ((other.mChangeMask & 1) != 0) {
                this.mFocusable = other.mFocusable;
            }
            if (transfer && (other.mChangeMask & 2) != 0) {
                this.mBoundsChangeTransaction = other.mBoundsChangeTransaction;
                other.mBoundsChangeTransaction = null;
            }
            if ((other.mChangeMask & 4) != 0) {
                Rect rect = this.mPinnedBounds = transfer ? other.mPinnedBounds : new Rect(other.mPinnedBounds);
            }
            if ((other.mChangeMask & 8) != 0) {
                this.mHidden = other.mHidden;
            }
            this.mChangeMask |= other.mChangeMask;
            if (other.mActivityWindowingMode >= 0) {
                this.mActivityWindowingMode = other.mActivityWindowingMode;
            }
            if (other.mWindowingMode >= 0) {
                this.mWindowingMode = other.mWindowingMode;
            }
            if (other.mBoundsChangeSurfaceBounds != null) {
                this.mBoundsChangeSurfaceBounds = transfer ? other.mBoundsChangeSurfaceBounds : new Rect(other.mBoundsChangeSurfaceBounds);
            }
        }

        public int getWindowingMode() {
            return this.mWindowingMode;
        }

        public int getActivityWindowingMode() {
            return this.mActivityWindowingMode;
        }

        public Configuration getConfiguration() {
            return this.mConfiguration;
        }

        public boolean getFocusable() {
            if ((this.mChangeMask & 1) == 0) {
                throw new RuntimeException("Focusable not set. check CHANGE_FOCUSABLE first");
            }
            return this.mFocusable;
        }

        public boolean getHidden() {
            if ((this.mChangeMask & 8) == 0) {
                throw new RuntimeException("Hidden not set. check CHANGE_HIDDEN first");
            }
            return this.mHidden;
        }

        public int getChangeMask() {
            return this.mChangeMask;
        }

        public int getConfigSetMask() {
            return this.mConfigSetMask;
        }

        @WindowConfiguration.WindowConfig
        public int getWindowSetMask() {
            return this.mWindowSetMask;
        }

        public Rect getEnterPipBounds() {
            return this.mPinnedBounds;
        }

        public SurfaceControl.Transaction getBoundsChangeTransaction() {
            return this.mBoundsChangeTransaction;
        }

        public Rect getBoundsChangeSurfaceBounds() {
            return this.mBoundsChangeSurfaceBounds;
        }

        public String toString() {
            boolean changesBounds = (this.mConfigSetMask & 0x20000000) != 0 && (this.mWindowSetMask & 1) != 0;
            boolean changesAppBounds = (this.mConfigSetMask & 0x20000000) != 0 && (this.mWindowSetMask & 2) != 0;
            boolean changesSs = (this.mConfigSetMask & 0x400) != 0;
            boolean changesSss = (this.mConfigSetMask & 0x800) != 0;
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            if (changesBounds) {
                sb.append("bounds:" + this.mConfiguration.windowConfiguration.getBounds() + ",");
            }
            if (changesAppBounds) {
                sb.append("appbounds:" + this.mConfiguration.windowConfiguration.getAppBounds() + ",");
            }
            if (changesSss) {
                sb.append("ssw:" + this.mConfiguration.smallestScreenWidthDp + ",");
            }
            if (changesSs) {
                sb.append("sw/h:" + this.mConfiguration.screenWidthDp + "x" + this.mConfiguration.screenHeightDp + ",");
            }
            if ((this.mChangeMask & 1) != 0) {
                sb.append("focusable:" + this.mFocusable + ",");
            }
            if (this.mBoundsChangeTransaction != null) {
                sb.append("hasBoundsTransaction,");
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.mConfiguration.writeToParcel(dest, flags);
            dest.writeBoolean(this.mFocusable);
            dest.writeBoolean(this.mHidden);
            dest.writeInt(this.mChangeMask);
            dest.writeInt(this.mConfigSetMask);
            dest.writeInt(this.mWindowSetMask);
            if (this.mPinnedBounds != null) {
                this.mPinnedBounds.writeToParcel(dest, flags);
            }
            if (this.mBoundsChangeTransaction != null) {
                this.mBoundsChangeTransaction.writeToParcel(dest, flags);
            }
            if (this.mBoundsChangeSurfaceBounds != null) {
                this.mBoundsChangeSurfaceBounds.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mWindowingMode);
            dest.writeInt(this.mActivityWindowingMode);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }
}

