/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import com.android.internal.logging.InstanceId;
import com.android.internal.logging.UiEventLogger;

public interface ChooserActivityLogger {
    public void logShareStarted(int var1, String var2, String var3, int var4, int var5, boolean var6, int var7, String var8);

    public void logShareTargetSelected(int var1, String var2, int var3);

    default public void logSharesheetTriggered() {
        this.log(SharesheetStandardEvent.SHARESHEET_TRIGGERED, this.getInstanceId());
    }

    default public void logSharesheetAppLoadComplete() {
        this.log(SharesheetStandardEvent.SHARESHEET_APP_LOAD_COMPLETE, this.getInstanceId());
    }

    default public void logSharesheetDirectLoadComplete() {
        this.log(SharesheetStandardEvent.SHARESHEET_DIRECT_LOAD_COMPLETE, this.getInstanceId());
    }

    default public void logSharesheetDirectLoadTimeout() {
        this.log(SharesheetStandardEvent.SHARESHEET_DIRECT_LOAD_TIMEOUT, this.getInstanceId());
    }

    default public void logShareheetProfileChanged() {
        this.log(SharesheetStandardEvent.SHARESHEET_PROFILE_CHANGED, this.getInstanceId());
    }

    default public void logSharesheetExpansionChanged(boolean isCollapsed) {
        this.log(isCollapsed ? SharesheetStandardEvent.SHARESHEET_COLLAPSED : SharesheetStandardEvent.SHARESHEET_EXPANDED, this.getInstanceId());
    }

    public void log(UiEventLogger.UiEventEnum var1, InstanceId var2);

    public InstanceId getInstanceId();

    default public int typeFromPreviewInt(int previewType) {
        switch (previewType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    default public int typeFromIntentString(String intent) {
        if (intent == null) {
            return 0;
        }
        switch (intent) {
            case "android.intent.action.VIEW": {
                return 1;
            }
            case "android.intent.action.EDIT": {
                return 2;
            }
            case "android.intent.action.SEND": {
                return 3;
            }
            case "android.intent.action.SENDTO": {
                return 4;
            }
            case "android.intent.action.SEND_MULTIPLE": {
                return 5;
            }
            case "android.media.action.IMAGE_CAPTURE": {
                return 6;
            }
            case "android.intent.action.MAIN": {
                return 7;
            }
        }
        return 0;
    }

    public static enum SharesheetStandardEvent implements UiEventLogger.UiEventEnum
    {
        INVALID(0),
        SHARESHEET_TRIGGERED(227),
        SHARESHEET_PROFILE_CHANGED(229),
        SHARESHEET_EXPANDED(230),
        SHARESHEET_COLLAPSED(231),
        SHARESHEET_APP_LOAD_COMPLETE(322),
        SHARESHEET_DIRECT_LOAD_COMPLETE(323),
        SHARESHEET_DIRECT_LOAD_TIMEOUT(324);

        private final int mId;

        private SharesheetStandardEvent(int id2) {
            this.mId = id2;
        }

        @Override
        public int getId() {
            return this.mId;
        }
    }

    public static enum SharesheetTargetSelectedEvent implements UiEventLogger.UiEventEnum
    {
        INVALID(0),
        SHARESHEET_SERVICE_TARGET_SELECTED(232),
        SHARESHEET_APP_TARGET_SELECTED(233),
        SHARESHEET_STANDARD_TARGET_SELECTED(234),
        SHARESHEET_COPY_TARGET_SELECTED(235);

        private final int mId;

        private SharesheetTargetSelectedEvent(int id2) {
            this.mId = id2;
        }

        @Override
        public int getId() {
            return this.mId;
        }

        public static SharesheetTargetSelectedEvent fromTargetType(int targetType) {
            switch (targetType) {
                case 1: {
                    return SHARESHEET_SERVICE_TARGET_SELECTED;
                }
                case 2: {
                    return SHARESHEET_APP_TARGET_SELECTED;
                }
                case 3: {
                    return SHARESHEET_STANDARD_TARGET_SELECTED;
                }
                case 4: {
                    return SHARESHEET_COPY_TARGET_SELECTED;
                }
            }
            return INVALID;
        }
    }

    public static enum SharesheetStartedEvent implements UiEventLogger.UiEventEnum
    {
        SHARE_STARTED(228);

        private final int mId;

        private SharesheetStartedEvent(int id2) {
            this.mId = id2;
        }

        @Override
        public int getId() {
            return this.mId;
        }
    }
}

