/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.ObjectAnimator;
import android.app.ActionBar;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.provider.Settings;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.android.internal.lang.System_Delegate;
import org.json.JSONObject;

public class PlatLogoActivity
extends Activity {
    private static final boolean WRITE_SETTINGS = true;
    private static final String R_EGG_UNLOCK_SETTING = "egg_mode_r";
    private static final int UNLOCK_TRIES = 3;
    BigDialView mDialView;
    static final String TOUCH_STATS = "touch.stats";
    double mPressureMin = 0.0;
    double mPressureMax = -1.0;

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        float dp = this.getResources().getDisplayMetrics().density;
        this.getWindow().getDecorView().setSystemUiVisibility(768);
        this.getWindow().setNavigationBarColor(0);
        this.getWindow().setStatusBarColor(0);
        ActionBar ab = this.getActionBar();
        if (ab != null) {
            ab.hide();
        }
        this.mDialView = new BigDialView(this, null);
        if (Settings.System.getLong(this.getContentResolver(), R_EGG_UNLOCK_SETTING, 0L) == 0L) {
            this.mDialView.setUnlockTries(3);
        } else {
            this.mDialView.setUnlockTries(0);
        }
        FrameLayout layout2 = new FrameLayout(this);
        layout2.setBackgroundColor(-65536);
        layout2.addView((View)this.mDialView, -1, -1);
        this.setContentView(layout2);
    }

    private void launchNextStage(boolean locked) {
        ContentResolver cr = this.getContentResolver();
        try {
            Settings.System.putLong(cr, R_EGG_UNLOCK_SETTING, locked ? 0L : System_Delegate.currentTimeMillis());
        }
        catch (RuntimeException e) {
            Log.e("com.android.internal.app.PlatLogoActivity", "Can't write settings", e);
        }
        try {
            this.startActivity(new Intent("android.intent.action.MAIN").setFlags(0x10008000).addCategory("com.android.internal.category.PLATLOGO"));
        }
        catch (ActivityNotFoundException ex) {
            Log.e("com.android.internal.app.PlatLogoActivity", "No more eggs.");
        }
    }

    private void measureTouchPressure(MotionEvent event) {
        float pressure = event.getPressure();
        switch (event.getActionMasked()) {
            case 0: {
                if (!(this.mPressureMax < 0.0)) break;
                this.mPressureMin = this.mPressureMax = (double)pressure;
                break;
            }
            case 2: {
                if ((double)pressure < this.mPressureMin) {
                    this.mPressureMin = pressure;
                }
                if (!((double)pressure > this.mPressureMax)) break;
                this.mPressureMax = pressure;
            }
        }
    }

    private void syncTouchPressure() {
        try {
            String touchDataJson = Settings.System.getString(this.getContentResolver(), TOUCH_STATS);
            JSONObject touchData = new JSONObject(touchDataJson != null ? touchDataJson : "{}");
            if (touchData.has("min")) {
                this.mPressureMin = Math.min(this.mPressureMin, touchData.getDouble("min"));
            }
            if (touchData.has("max")) {
                this.mPressureMax = Math.max(this.mPressureMax, touchData.getDouble("max"));
            }
            if (this.mPressureMax >= 0.0) {
                touchData.put("min", this.mPressureMin);
                touchData.put("max", this.mPressureMax);
                Settings.System.putString(this.getContentResolver(), TOUCH_STATS, touchData.toString());
            }
        }
        catch (Exception e) {
            Log.e("com.android.internal.app.PlatLogoActivity", "Can't write touch settings", e);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        this.syncTouchPressure();
    }

    @Override
    public void onStop() {
        this.syncTouchPressure();
        super.onStop();
    }

    class BigDialView
    extends ImageView {
        private static final int COLOR_GREEN = -12723068;
        private static final int COLOR_BLUE = -12417548;
        private static final int COLOR_NAVY = -16306110;
        private static final int COLOR_ORANGE = -497868;
        private static final int COLOR_CHARTREUSE = -1050673;
        private static final int COLOR_LIGHTBLUE = -2625538;
        private static final int STEPS = 11;
        private static final float VALUE_CHANGE_MAX = 0.09090909f;
        private BigDialDrawable mDialDrawable;
        private boolean mWasLocked;

        BigDialView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.init();
        }

        BigDialView(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
            this.init();
        }

        BigDialView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
            this.init();
        }

        private void init() {
            this.mDialDrawable = new BigDialDrawable();
            this.setImageDrawable(this.mDialDrawable);
        }

        @Override
        public void onDraw(Canvas c) {
            super.onDraw(c);
        }

        double toPositiveDegrees(double rad) {
            return (Math.toDegrees(rad) + 360.0 - 90.0) % 360.0;
        }

        @Override
        public boolean onTouchEvent(MotionEvent ev) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mWasLocked = this.mDialDrawable.isLocked();
                }
                case 2: {
                    float x = ev.getX();
                    float y = ev.getY();
                    float cx = (float)(this.getLeft() + this.getRight()) / 2.0f;
                    float cy = (float)(this.getTop() + this.getBottom()) / 2.0f;
                    float angle = (float)this.toPositiveDegrees(Math.atan2(x - cx, y - cy));
                    int oldLevel = this.mDialDrawable.getUserLevel();
                    this.mDialDrawable.touchAngle(angle);
                    int newLevel = this.mDialDrawable.getUserLevel();
                    if (oldLevel != newLevel) {
                        this.performHapticFeedback(newLevel == 11 ? 16 : 4);
                    }
                    return true;
                }
                case 1: {
                    if (this.mWasLocked != this.mDialDrawable.isLocked()) {
                        PlatLogoActivity.this.launchNextStage(this.mDialDrawable.isLocked());
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean performClick() {
            if (this.mDialDrawable.getUserLevel() < 10) {
                this.mDialDrawable.setUserLevel(this.mDialDrawable.getUserLevel() + 1);
                this.performHapticFeedback(4);
            }
            return true;
        }

        void setUnlockTries(int tries) {
            this.mDialDrawable.setUnlockTries(tries);
        }

        private class BigDialDrawable
        extends Drawable {
            public final int STEPS = 10;
            private int mUnlockTries = 0;
            final Paint mPaint = new Paint();
            final Drawable mEleven;
            private boolean mNightMode;
            private float mValue = 0.0f;
            float mElevenAnim = 0.0f;
            ObjectAnimator mElevenShowAnimator = ObjectAnimator.ofFloat((Object)this, "elevenAnim", 0.0f, 1.0f).setDuration(300L);
            ObjectAnimator mElevenHideAnimator = ObjectAnimator.ofFloat((Object)this, "elevenAnim", 1.0f, 0.0f).setDuration(500L);

            BigDialDrawable() {
                this.mNightMode = BigDialView.this.getContext().getResources().getConfiguration().isNightModeActive();
                this.mEleven = BigDialView.this.getContext().getDrawable(17302762);
                this.mElevenShowAnimator.setInterpolator(new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f));
                this.mElevenHideAnimator.setInterpolator(new PathInterpolator(0.8f, 0.2f, 0.6f, 1.0f));
            }

            public void setUnlockTries(int count) {
                if (this.mUnlockTries != count) {
                    this.mUnlockTries = count;
                    this.setValue(this.getValue());
                    this.invalidateSelf();
                }
            }

            boolean isLocked() {
                return this.mUnlockTries > 0;
            }

            public void setValue(float v) {
                float max;
                float f = max = this.isLocked() ? 0.9f : 1.0f;
                this.mValue = v < 0.0f ? 0.0f : (v > max ? max : v);
                this.invalidateSelf();
            }

            public float getValue() {
                return this.mValue;
            }

            public int getUserLevel() {
                return Math.round(this.getValue() * 10.0f - 0.25f);
            }

            public void setUserLevel(int i) {
                this.setValue(this.getValue() + (float)i / 10.0f);
            }

            public float getElevenAnim() {
                return this.mElevenAnim;
            }

            public void setElevenAnim(float f) {
                if (this.mElevenAnim != f) {
                    this.mElevenAnim = f;
                    this.invalidateSelf();
                }
            }

            @Override
            public void draw(Canvas canvas) {
                Rect bounds = this.getBounds();
                int w = bounds.width();
                int h = bounds.height();
                float w2 = (float)w / 2.0f;
                float h2 = (float)h / 2.0f;
                float radius = (float)w / 4.0f;
                canvas.drawColor(this.mNightMode ? -16306110 : -2625538);
                canvas.save();
                canvas.rotate(45.0f, w2, h2);
                canvas.clipRect(w2, h2 - radius, (float)Math.min(w, h), h2 + radius);
                int gradientColor = this.mNightMode ? 0x60000020 : 268906562;
                this.mPaint.setShader(new LinearGradient(w2, h2, (float)Math.min(w, h), h2, gradientColor, 0xFFFFFF & gradientColor, Shader.TileMode.CLAMP));
                this.mPaint.setColor(-16777216);
                canvas.drawPaint(this.mPaint);
                this.mPaint.setShader(null);
                canvas.restore();
                this.mPaint.setStyle(Paint.Style.FILL);
                this.mPaint.setColor(-12723068);
                canvas.drawCircle(w2, h2, radius, this.mPaint);
                this.mPaint.setColor(this.mNightMode ? -2625538 : -16306110);
                float cx = (float)w * 0.85f;
                for (int i = 0; i < 10; ++i) {
                    float f = (float)i / 10.0f;
                    canvas.save();
                    float angle = this.valueToAngle(f);
                    canvas.rotate(-angle, w2, h2);
                    canvas.drawCircle(cx, h2, i <= this.getUserLevel() ? 20.0f : 5.0f, this.mPaint);
                    canvas.restore();
                }
                if (this.mElevenAnim > 0.0f) {
                    int color2 = -497868;
                    int size2 = (int)((0.5 + (double)(0.5f * this.mElevenAnim)) * (double)w / 14.0);
                    float cx11 = cx + (float)size2 / 4.0f;
                    this.mEleven.setBounds((int)cx11 - size2, (int)h2 - size2, (int)cx11 + size2, (int)h2 + size2);
                    int alpha = 0xFFFFFF | (int)this.clamp(510.0f * this.mElevenAnim, 0.0f, 255.0f) << 24;
                    this.mEleven.setTint(alpha & 0xFFF86734);
                    this.mEleven.draw(canvas);
                }
                float angle = this.valueToAngle(this.mValue);
                canvas.rotate(-angle, w2, h2);
                this.mPaint.setColor(-1);
                float dimple = w2 / 12.0f;
                canvas.drawCircle((float)w - radius - dimple * 2.0f, h2, dimple, this.mPaint);
            }

            float clamp(float x, float a, float b) {
                return x < a ? a : (x > b ? b : x);
            }

            float angleToValue(float a) {
                return 1.0f - this.clamp(a / 315.0f, 0.0f, 1.0f);
            }

            float valueToAngle(float v) {
                return (1.0f - v) * 315.0f;
            }

            public void touchAngle(float a) {
                int oldUserLevel = this.getUserLevel();
                float newValue = this.angleToValue(a);
                if (Math.abs(newValue - this.getValue()) < 0.09090909f) {
                    this.setValue(newValue);
                    if (this.isLocked() && oldUserLevel != 9 && this.getUserLevel() == 9) {
                        --this.mUnlockTries;
                    } else if (!this.isLocked() && this.getUserLevel() == 0) {
                        this.mUnlockTries = 3;
                    }
                    if (!this.isLocked()) {
                        if (this.getUserLevel() == 10 && this.mElevenAnim != 1.0f && !this.mElevenShowAnimator.isRunning()) {
                            this.mElevenHideAnimator.cancel();
                            this.mElevenShowAnimator.start();
                        } else if (this.getUserLevel() != 10 && this.mElevenAnim == 1.0f && !this.mElevenHideAnimator.isRunning()) {
                            this.mElevenShowAnimator.cancel();
                            this.mElevenHideAnimator.start();
                        }
                    }
                }
            }

            @Override
            public void setAlpha(int i) {
            }

            @Override
            public void setColorFilter(ColorFilter colorFilter) {
            }

            @Override
            public int getOpacity() {
                return -3;
            }
        }
    }
}

