/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content.om;

import android.content.pm.PackagePartitions;
import android.content.pm.parsing.ParsingPackageRead;
import android.os.Trace;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.om.OverlayConfigParser;
import com.android.internal.content.om.OverlayScanner;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class OverlayConfig {
    static final String TAG = "OverlayConfig";
    @VisibleForTesting
    public static final int DEFAULT_PRIORITY = Integer.MAX_VALUE;
    private static final Comparator<OverlayConfigParser.ParsedConfiguration> sStaticOverlayComparator = (c1, c2) -> {
        OverlayScanner.ParsedOverlayInfo o1 = c1.parsedInfo;
        OverlayScanner.ParsedOverlayInfo o2 = c2.parsedInfo;
        Preconditions.checkArgument(o1.isStatic && o2.isStatic, "attempted to sort non-static overlay");
        if (!o1.targetPackageName.equals(o2.targetPackageName)) {
            return o1.targetPackageName.compareTo(o2.targetPackageName);
        }
        int comparedPriority = o1.priority - o2.priority;
        return comparedPriority == 0 ? o1.path.compareTo(o2.path) : comparedPriority;
    };
    private final ArrayMap<String, Configuration> mConfigurations = new ArrayMap();
    private static OverlayConfig sInstance;

    @VisibleForTesting
    public OverlayConfig(File rootDirectory, Supplier<OverlayScanner> scannerFactory, PackageProvider packageProvider) {
        int i;
        Preconditions.checkArgument(scannerFactory == null != (packageProvider == null), "scannerFactory and packageProvider cannot be both null or both non-null");
        ArrayList<OverlayConfigParser.OverlayPartition> partitions = rootDirectory == null ? new ArrayList<OverlayConfigParser.OverlayPartition>(PackagePartitions.getOrderedPartitions(OverlayConfigParser.OverlayPartition::new)) : new ArrayList<OverlayConfigParser.OverlayPartition>(PackagePartitions.getOrderedPartitions(p -> new OverlayConfigParser.OverlayPartition(new File(rootDirectory, p.getFolder().getPath()), (PackagePartitions.SystemPartition)p)));
        boolean foundConfigFile = false;
        ArrayList<OverlayScanner.ParsedOverlayInfo> packageManagerOverlayInfos = null;
        ArrayList<OverlayConfigParser.ParsedConfiguration> overlays = new ArrayList<OverlayConfigParser.ParsedConfiguration>();
        int n = partitions.size();
        for (i = 0; i < n; ++i) {
            ArrayList<OverlayScanner.ParsedOverlayInfo> partitionOverlayInfos;
            OverlayScanner scanner;
            OverlayConfigParser.OverlayPartition partition = partitions.get(i);
            ArrayList<OverlayConfigParser.ParsedConfiguration> partitionOverlays = OverlayConfigParser.getConfigurations(partition, scanner = scannerFactory == null ? null : scannerFactory.get());
            if (partitionOverlays != null) {
                foundConfigFile = true;
                overlays.addAll(partitionOverlays);
                continue;
            }
            if (scannerFactory != null) {
                partitionOverlayInfos = new ArrayList<OverlayScanner.ParsedOverlayInfo>(scanner.getAllParsedInfos());
            } else {
                if (packageManagerOverlayInfos == null) {
                    packageManagerOverlayInfos = OverlayConfig.getOverlayPackageInfos(packageProvider);
                }
                partitionOverlayInfos = new ArrayList<OverlayScanner.ParsedOverlayInfo>(packageManagerOverlayInfos);
                for (int j = partitionOverlayInfos.size() - 1; j >= 0; --j) {
                    if (partition.containsFile(partitionOverlayInfos.get((int)j).path)) continue;
                    partitionOverlayInfos.remove(j);
                }
            }
            ArrayList<OverlayConfigParser.ParsedConfiguration> partitionConfigs = new ArrayList<OverlayConfigParser.ParsedConfiguration>();
            int m = partitionOverlayInfos.size();
            for (int j = 0; j < m; ++j) {
                OverlayScanner.ParsedOverlayInfo p2 = partitionOverlayInfos.get(j);
                if (!p2.isStatic) continue;
                partitionConfigs.add(new OverlayConfigParser.ParsedConfiguration(p2.packageName, true, false, partition.policy, p2));
            }
            partitionConfigs.sort(sStaticOverlayComparator);
            overlays.addAll(partitionConfigs);
        }
        if (!foundConfigFile) {
            overlays.sort(sStaticOverlayComparator);
        }
        n = overlays.size();
        for (i = 0; i < n; ++i) {
            OverlayConfigParser.ParsedConfiguration config = (OverlayConfigParser.ParsedConfiguration)overlays.get(i);
            this.mConfigurations.put(config.packageName, new Configuration(config, i));
        }
    }

    public static OverlayConfig getZygoteInstance() {
        Trace.traceBegin(0x4000000L, "OverlayConfig#getZygoteInstance");
        try {
            OverlayConfig overlayConfig = new OverlayConfig(null, OverlayScanner::new, null);
            return overlayConfig;
        }
        finally {
            Trace.traceEnd(0x4000000L);
        }
    }

    public static OverlayConfig initializeSystemInstance(PackageProvider packageProvider) {
        Trace.traceBegin(0x4000000L, "OverlayConfig#initializeSystemInstance");
        try {
            sInstance = new OverlayConfig(null, null, packageProvider);
        }
        finally {
            Trace.traceEnd(0x4000000L);
        }
        return sInstance;
    }

    public static OverlayConfig getSystemInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("System instance not initialized");
        }
        return sInstance;
    }

    @VisibleForTesting
    public Configuration getConfiguration(String packageName) {
        return this.mConfigurations.get(packageName);
    }

    public boolean isEnabled(String packageName) {
        Configuration config = this.mConfigurations.get(packageName);
        return config == null ? false : config.parsedConfig.enabled;
    }

    public boolean isMutable(String packageName) {
        Configuration config = this.mConfigurations.get(packageName);
        return config == null ? true : config.parsedConfig.mutable;
    }

    public int getPriority(String packageName) {
        Configuration config = this.mConfigurations.get(packageName);
        return config == null ? Integer.MAX_VALUE : config.configIndex;
    }

    private ArrayList<Configuration> getSortedOverlays() {
        ArrayList<Configuration> sortedOverlays = new ArrayList<Configuration>();
        int n = this.mConfigurations.size();
        for (int i = 0; i < n; ++i) {
            sortedOverlays.add(this.mConfigurations.valueAt(i));
        }
        sortedOverlays.sort(Comparator.comparingInt(o -> o.configIndex));
        return sortedOverlays;
    }

    private static ArrayList<OverlayScanner.ParsedOverlayInfo> getOverlayPackageInfos(PackageProvider packageManager) {
        ArrayList<OverlayScanner.ParsedOverlayInfo> overlays = new ArrayList<OverlayScanner.ParsedOverlayInfo>();
        packageManager.forEachPackage((p, isSystem) -> {
            if (p.getOverlayTarget() != null && isSystem.booleanValue()) {
                overlays.add(new OverlayScanner.ParsedOverlayInfo(p.getPackageName(), p.getOverlayTarget(), p.getTargetSdkVersion(), p.isOverlayIsStatic(), p.getOverlayPriority(), new File(p.getBaseCodePath())));
            }
        });
        return overlays;
    }

    @VisibleForTesting
    public ArrayList<IdmapInvocation> getImmutableFrameworkOverlayIdmapInvocations() {
        ArrayList<IdmapInvocation> idmapInvocations = new ArrayList<IdmapInvocation>();
        ArrayList<Configuration> sortedConfigs = this.getSortedOverlays();
        int n = sortedConfigs.size();
        for (int i = 0; i < n; ++i) {
            Configuration overlay = sortedConfigs.get(i);
            if (overlay.parsedConfig.mutable || !overlay.parsedConfig.enabled || !"android".equals(overlay.parsedConfig.parsedInfo.targetPackageName)) continue;
            boolean enforceOverlayable = overlay.parsedConfig.parsedInfo.targetSdkVersion >= 29;
            IdmapInvocation invocation = null;
            if (!idmapInvocations.isEmpty()) {
                IdmapInvocation last = idmapInvocations.get(idmapInvocations.size() - 1);
                if (last.enforceOverlayable == enforceOverlayable && last.policy.equals(overlay.parsedConfig.policy)) {
                    invocation = last;
                }
            }
            if (invocation == null) {
                invocation = new IdmapInvocation(enforceOverlayable, overlay.parsedConfig.policy);
                idmapInvocations.add(invocation);
            }
            invocation.overlayPaths.add(overlay.parsedConfig.parsedInfo.path.getAbsolutePath());
        }
        return idmapInvocations;
    }

    public String[] createImmutableFrameworkIdmapsInZygote() {
        String targetPath = "/system/framework/framework-res.apk";
        ArrayList<String> idmapPaths = new ArrayList<String>();
        ArrayList<IdmapInvocation> idmapInvocations = this.getImmutableFrameworkOverlayIdmapInvocations();
        int n = idmapInvocations.size();
        for (int i = 0; i < n; ++i) {
            IdmapInvocation invocation = idmapInvocations.get(i);
            String[] idmaps = OverlayConfig.createIdmap("/system/framework/framework-res.apk", invocation.overlayPaths.toArray(new String[0]), new String[]{"public", invocation.policy}, invocation.enforceOverlayable);
            if (idmaps == null) {
                Log.w(TAG, "'idmap2 create-multiple' failed: no mutable=\"false\" overlays targeting \"android\" will be loaded");
                return new String[0];
            }
            idmapPaths.addAll(Arrays.asList(idmaps));
        }
        return idmapPaths.toArray(new String[0]);
    }

    private static String[] createIdmap(String string2, String[] stringArray, String[] stringArray2, boolean bl) {
        return (String[])OverrideMethod.invokeA("com.android.internal.content.om.OverlayConfig#createIdmap(Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Z)[Ljava/lang/String;", true, null);
    }

    @VisibleForTesting
    public static class IdmapInvocation {
        public final boolean enforceOverlayable;
        public final String policy;
        public final ArrayList<String> overlayPaths = new ArrayList();

        IdmapInvocation(boolean enforceOverlayable, String policy) {
            this.enforceOverlayable = enforceOverlayable;
            this.policy = policy;
        }

        public String toString() {
            return this.getClass().getSimpleName() + String.format("{enforceOverlayable=%s, policy=%s, overlayPaths=[%s]}", this.enforceOverlayable, this.policy, String.join((CharSequence)", ", this.overlayPaths));
        }
    }

    public static interface PackageProvider {
        public void forEachPackage(BiConsumer<ParsingPackageRead, Boolean> var1);
    }

    @VisibleForTesting
    public static class Configuration {
        public final OverlayConfigParser.ParsedConfiguration parsedConfig;
        public final int configIndex;

        public Configuration(OverlayConfigParser.ParsedConfiguration parsedConfig, int configIndex) {
            this.parsedConfig = parsedConfig;
            this.configIndex = configIndex;
        }
    }
}

