/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ProviderProperties
implements Parcelable {
    public final boolean mRequiresNetwork;
    public final boolean mRequiresSatellite;
    public final boolean mRequiresCell;
    public final boolean mHasMonetaryCost;
    public final boolean mSupportsAltitude;
    public final boolean mSupportsSpeed;
    public final boolean mSupportsBearing;
    public final int mPowerRequirement;
    public final int mAccuracy;
    public static final Parcelable.Creator<ProviderProperties> CREATOR = new Parcelable.Creator<ProviderProperties>(){

        @Override
        public ProviderProperties createFromParcel(Parcel in) {
            boolean requiresNetwork = in.readInt() == 1;
            boolean requiresSatellite = in.readInt() == 1;
            boolean requiresCell = in.readInt() == 1;
            boolean hasMonetaryCost = in.readInt() == 1;
            boolean supportsAltitude = in.readInt() == 1;
            boolean supportsSpeed = in.readInt() == 1;
            boolean supportsBearing = in.readInt() == 1;
            int powerRequirement = in.readInt();
            int accuracy = in.readInt();
            return new ProviderProperties(requiresNetwork, requiresSatellite, requiresCell, hasMonetaryCost, supportsAltitude, supportsSpeed, supportsBearing, powerRequirement, accuracy);
        }

        public ProviderProperties[] newArray(int size) {
            return new ProviderProperties[size];
        }
    };

    public ProviderProperties(boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
        this.mRequiresNetwork = requiresNetwork;
        this.mRequiresSatellite = requiresSatellite;
        this.mRequiresCell = requiresCell;
        this.mHasMonetaryCost = hasMonetaryCost;
        this.mSupportsAltitude = supportsAltitude;
        this.mSupportsSpeed = supportsSpeed;
        this.mSupportsBearing = supportsBearing;
        this.mPowerRequirement = Preconditions.checkArgumentInRange(powerRequirement, 1, 3, "powerRequirement");
        this.mAccuracy = Preconditions.checkArgumentInRange(accuracy, 1, 2, "accuracy");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mRequiresNetwork ? 1 : 0);
        parcel.writeInt(this.mRequiresSatellite ? 1 : 0);
        parcel.writeInt(this.mRequiresCell ? 1 : 0);
        parcel.writeInt(this.mHasMonetaryCost ? 1 : 0);
        parcel.writeInt(this.mSupportsAltitude ? 1 : 0);
        parcel.writeInt(this.mSupportsSpeed ? 1 : 0);
        parcel.writeInt(this.mSupportsBearing ? 1 : 0);
        parcel.writeInt(this.mPowerRequirement);
        parcel.writeInt(this.mAccuracy);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ProviderProperties[");
        b.append("power=").append(ProviderProperties.powerToString(this.mPowerRequirement)).append(", ");
        b.append("accuracy=").append(ProviderProperties.accuracyToString(this.mAccuracy));
        if (this.mRequiresNetwork || this.mRequiresSatellite || this.mRequiresCell) {
            b.append(", requires=");
            if (this.mRequiresNetwork) {
                b.append("network,");
            }
            if (this.mRequiresSatellite) {
                b.append("satellite,");
            }
            if (this.mRequiresCell) {
                b.append("cell,");
            }
            b.setLength(b.length() - 1);
        }
        if (this.mHasMonetaryCost) {
            b.append(", hasMonetaryCost");
        }
        if (this.mSupportsBearing || this.mSupportsSpeed || this.mSupportsAltitude) {
            b.append(", supports=[");
            if (this.mSupportsBearing) {
                b.append("bearing, ");
            }
            if (this.mSupportsSpeed) {
                b.append("speed, ");
            }
            if (this.mSupportsAltitude) {
                b.append("altitude, ");
            }
            b.setLength(b.length() - 2);
            b.append("]");
        }
        b.append("]");
        return b.toString();
    }

    private static String powerToString(int power) {
        switch (power) {
            case 1: {
                return "Low";
            }
            case 2: {
                return "Medium";
            }
            case 3: {
                return "High";
            }
        }
        return "???";
    }

    private static String accuracyToString(int accuracy) {
        switch (accuracy) {
            case 2: {
                return "Coarse";
            }
            case 1: {
                return "Fine";
            }
        }
        return "???";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Accuracy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerRequirement {
    }
}

