/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.BatteryStats;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import java.util.List;

public class SensorPowerCalculator
extends PowerCalculator {
    private final List<Sensor> mSensors;
    private final double mGpsPower;

    public SensorPowerCalculator(PowerProfile profile, SensorManager sensorManager, BatteryStats stats, long rawRealtimeUs, int statsType) {
        this.mSensors = sensorManager.getSensorList(-1);
        this.mGpsPower = this.getAverageGpsPower(profile, stats, rawRealtimeUs, statsType);
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        SparseArray<? extends BatteryStats.Uid.Sensor> sensorStats = u.getSensorStats();
        int NSE = sensorStats.size();
        block3: for (int ise = 0; ise < NSE; ++ise) {
            BatteryStats.Uid.Sensor sensor = sensorStats.valueAt(ise);
            int sensorHandle = sensorStats.keyAt(ise);
            BatteryStats.Timer timer = sensor.getSensorTime();
            long sensorTime = timer.getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L;
            switch (sensorHandle) {
                case -10000: {
                    app.gpsTimeMs = sensorTime;
                    app.gpsPowerMah = (double)app.gpsTimeMs * this.mGpsPower / 3600000.0;
                    continue block3;
                }
                default: {
                    int sensorsCount = this.mSensors.size();
                    for (int i = 0; i < sensorsCount; ++i) {
                        Sensor s = this.mSensors.get(i);
                        if (s.getHandle() != sensorHandle) continue;
                        app.sensorPowerMah += (double)((float)sensorTime * s.getPower() / 3600000.0f);
                        continue block3;
                    }
                }
            }
        }
    }

    private double getAverageGpsPower(PowerProfile profile, BatteryStats stats, long rawRealtimeUs, int statsType) {
        double averagePower = profile.getAveragePowerOrDefault("gps.on", -1.0);
        if (averagePower != -1.0) {
            return averagePower;
        }
        averagePower = 0.0;
        long totalTime = 0L;
        double totalPower = 0.0;
        for (int i = 0; i < 2; ++i) {
            long timePerLevel = stats.getGpsSignalQualityTime(i, rawRealtimeUs, statsType);
            totalTime += timePerLevel;
            totalPower += profile.getAveragePower("gps.signalqualitybased", i) * (double)timePerLevel;
        }
        if (totalTime != 0L) {
            averagePower = totalPower / (double)totalTime;
        }
        return averagePower;
    }
}

