/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import java.util.ArrayList;
import java.util.Arrays;

class ZygoteArguments {
    int mUid = 0;
    boolean mUidSpecified;
    int mGid = 0;
    boolean mGidSpecified;
    int[] mGids;
    int mRuntimeFlags;
    int mMountExternal = 0;
    private boolean mTargetSdkVersionSpecified;
    int mTargetSdkVersion;
    String mNiceName;
    private boolean mCapabilitiesSpecified;
    long mPermittedCapabilities;
    long mEffectiveCapabilities;
    private boolean mSeInfoSpecified;
    String mSeInfo;
    boolean mUsapPoolEnabled;
    boolean mUsapPoolStatusSpecified = false;
    ArrayList<int[]> mRLimits;
    String mInvokeWith;
    String mPackageName;
    String[] mRemainingArgs;
    boolean mAbiListQuery;
    String mInstructionSet;
    String mAppDataDir;
    String mPreloadPackage;
    String mPreloadApp;
    String mPreloadPackageLibs;
    String mPreloadPackageLibFileName;
    String mPreloadPackageCacheKey;
    boolean mPreloadDefault;
    boolean mStartChildZygote;
    boolean mPidQuery;
    boolean mBootCompleted;
    String[] mApiBlacklistExemptions;
    int mHiddenApiAccessLogSampleRate = -1;
    int mHiddenApiAccessStatslogSampleRate = -1;
    boolean mIsTopApp;
    long[] mDisabledCompatChanges = null;
    String[] mPkgDataInfoList;
    String[] mWhitelistedDataInfoList;
    boolean mBindMountAppStorageDirs;
    boolean mBindMountAppDataDirs;

    ZygoteArguments(String[] args) throws IllegalArgumentException {
        this.parseArgs(args);
    }

    private void parseArgs(String[] args) throws IllegalArgumentException {
        int curArg;
        boolean seenRuntimeArgs = false;
        boolean expectRuntimeArgs = true;
        for (curArg = 0; curArg < args.length; ++curArg) {
            String rateStr;
            String[] params;
            int i;
            String arg = args[curArg];
            if (arg.equals("--")) {
                ++curArg;
                break;
            }
            if (arg.startsWith("--setuid=")) {
                if (this.mUidSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mUidSpecified = true;
                this.mUid = Integer.parseInt(ZygoteArguments.getAssignmentValue(arg));
                continue;
            }
            if (arg.startsWith("--setgid=")) {
                if (this.mGidSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mGidSpecified = true;
                this.mGid = Integer.parseInt(ZygoteArguments.getAssignmentValue(arg));
                continue;
            }
            if (arg.startsWith("--target-sdk-version=")) {
                if (this.mTargetSdkVersionSpecified) {
                    throw new IllegalArgumentException("Duplicate target-sdk-version specified");
                }
                this.mTargetSdkVersionSpecified = true;
                this.mTargetSdkVersion = Integer.parseInt(ZygoteArguments.getAssignmentValue(arg));
                continue;
            }
            if (arg.equals("--runtime-args")) {
                seenRuntimeArgs = true;
                continue;
            }
            if (arg.startsWith("--runtime-flags=")) {
                this.mRuntimeFlags = Integer.parseInt(ZygoteArguments.getAssignmentValue(arg));
                continue;
            }
            if (arg.startsWith("--seinfo=")) {
                if (this.mSeInfoSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mSeInfoSpecified = true;
                this.mSeInfo = ZygoteArguments.getAssignmentValue(arg);
                continue;
            }
            if (arg.startsWith("--capabilities=")) {
                if (this.mCapabilitiesSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mCapabilitiesSpecified = true;
                String capString = ZygoteArguments.getAssignmentValue(arg);
                String[] capStrings = capString.split(",", 2);
                if (capStrings.length == 1) {
                    this.mPermittedCapabilities = this.mEffectiveCapabilities = Long.decode(capStrings[0]).longValue();
                    continue;
                }
                this.mPermittedCapabilities = Long.decode(capStrings[0]);
                this.mEffectiveCapabilities = Long.decode(capStrings[1]);
                continue;
            }
            if (arg.startsWith("--rlimit=")) {
                String[] limitStrings = ZygoteArguments.getAssignmentList(arg);
                if (limitStrings.length != 3) {
                    throw new IllegalArgumentException("--rlimit= should have 3 comma-delimited ints");
                }
                int[] rlimitTuple = new int[limitStrings.length];
                for (i = 0; i < limitStrings.length; ++i) {
                    rlimitTuple[i] = Integer.parseInt(limitStrings[i]);
                }
                if (this.mRLimits == null) {
                    this.mRLimits = new ArrayList();
                }
                this.mRLimits.add(rlimitTuple);
                continue;
            }
            if (arg.startsWith("--setgroups=")) {
                if (this.mGids != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                params = ZygoteArguments.getAssignmentList(arg);
                this.mGids = new int[params.length];
                for (int i2 = params.length - 1; i2 >= 0; --i2) {
                    this.mGids[i2] = Integer.parseInt(params[i2]);
                }
                continue;
            }
            if (arg.equals("--invoke-with")) {
                if (this.mInvokeWith != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                try {
                    this.mInvokeWith = args[++curArg];
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new IllegalArgumentException("--invoke-with requires argument");
                }
            }
            if (arg.startsWith("--nice-name=")) {
                if (this.mNiceName != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mNiceName = ZygoteArguments.getAssignmentValue(arg);
                continue;
            }
            if (arg.equals("--mount-external-default")) {
                this.mMountExternal = 1;
                continue;
            }
            if (arg.equals("--mount-external-read")) {
                this.mMountExternal = 2;
                continue;
            }
            if (arg.equals("--mount-external-write")) {
                this.mMountExternal = 3;
                continue;
            }
            if (arg.equals("--mount-external-full")) {
                this.mMountExternal = 6;
                continue;
            }
            if (arg.equals("--mount-external-installer")) {
                this.mMountExternal = 5;
                continue;
            }
            if (arg.equals("--mount-external-legacy")) {
                this.mMountExternal = 4;
                continue;
            }
            if (arg.equals("--mount-external-pass-through")) {
                this.mMountExternal = 7;
                continue;
            }
            if (arg.equals("--mount-external-android-writable")) {
                this.mMountExternal = 8;
                continue;
            }
            if (arg.equals("--query-abi-list")) {
                this.mAbiListQuery = true;
                continue;
            }
            if (arg.equals("--get-pid")) {
                this.mPidQuery = true;
                continue;
            }
            if (arg.equals("--boot-completed")) {
                this.mBootCompleted = true;
                continue;
            }
            if (arg.startsWith("--instruction-set=")) {
                this.mInstructionSet = ZygoteArguments.getAssignmentValue(arg);
                continue;
            }
            if (arg.startsWith("--app-data-dir=")) {
                this.mAppDataDir = ZygoteArguments.getAssignmentValue(arg);
                continue;
            }
            if (arg.equals("--preload-app")) {
                this.mPreloadApp = args[++curArg];
                continue;
            }
            if (arg.equals("--preload-package")) {
                this.mPreloadPackage = args[++curArg];
                this.mPreloadPackageLibs = args[++curArg];
                this.mPreloadPackageLibFileName = args[++curArg];
                this.mPreloadPackageCacheKey = args[++curArg];
                continue;
            }
            if (arg.equals("--preload-default")) {
                this.mPreloadDefault = true;
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.equals("--start-child-zygote")) {
                this.mStartChildZygote = true;
                continue;
            }
            if (arg.equals("--set-api-blacklist-exemptions")) {
                this.mApiBlacklistExemptions = Arrays.copyOfRange(args, curArg + 1, args.length);
                curArg = args.length;
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.startsWith("--hidden-api-log-sampling-rate=")) {
                rateStr = ZygoteArguments.getAssignmentValue(arg);
                try {
                    this.mHiddenApiAccessLogSampleRate = Integer.parseInt(rateStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid log sampling rate: " + rateStr, nfe);
                }
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.startsWith("--hidden-api-statslog-sampling-rate=")) {
                rateStr = ZygoteArguments.getAssignmentValue(arg);
                try {
                    this.mHiddenApiAccessStatslogSampleRate = Integer.parseInt(rateStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid statslog sampling rate: " + rateStr, nfe);
                }
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.startsWith("--package-name=")) {
                if (this.mPackageName != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mPackageName = ZygoteArguments.getAssignmentValue(arg);
                continue;
            }
            if (arg.startsWith("--usap-pool-enabled=")) {
                this.mUsapPoolStatusSpecified = true;
                this.mUsapPoolEnabled = Boolean.parseBoolean(ZygoteArguments.getAssignmentValue(arg));
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.startsWith("--is-top-app")) {
                this.mIsTopApp = true;
                continue;
            }
            if (arg.startsWith("--disabled-compat-changes=")) {
                if (this.mDisabledCompatChanges != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                params = ZygoteArguments.getAssignmentList(arg);
                int length = params.length;
                this.mDisabledCompatChanges = new long[length];
                for (i = 0; i < length; ++i) {
                    this.mDisabledCompatChanges[i] = Long.parseLong(params[i]);
                }
                continue;
            }
            if (arg.startsWith("--pkg-data-info-map")) {
                this.mPkgDataInfoList = ZygoteArguments.getAssignmentList(arg);
                continue;
            }
            if (arg.startsWith("--whitelisted-data-info-map")) {
                this.mWhitelistedDataInfoList = ZygoteArguments.getAssignmentList(arg);
                continue;
            }
            if (arg.equals("--bind-mount-storage-dirs")) {
                this.mBindMountAppStorageDirs = true;
                continue;
            }
            if (!arg.equals("--bind-mount-data-dirs")) break;
            this.mBindMountAppDataDirs = true;
        }
        if (this.mBootCompleted) {
            if (args.length - curArg > 0) {
                throw new IllegalArgumentException("Unexpected arguments after --boot-completed");
            }
        } else if (this.mAbiListQuery || this.mPidQuery) {
            if (args.length - curArg > 0) {
                throw new IllegalArgumentException("Unexpected arguments after --query-abi-list.");
            }
        } else if (this.mPreloadPackage != null) {
            if (args.length - curArg > 0) {
                throw new IllegalArgumentException("Unexpected arguments after --preload-package.");
            }
        } else if (this.mPreloadApp != null) {
            if (args.length - curArg > 0) {
                throw new IllegalArgumentException("Unexpected arguments after --preload-app.");
            }
        } else if (expectRuntimeArgs) {
            if (!seenRuntimeArgs) {
                throw new IllegalArgumentException("Unexpected argument : " + args[curArg]);
            }
            this.mRemainingArgs = new String[args.length - curArg];
            System.arraycopy(args, curArg, this.mRemainingArgs, 0, this.mRemainingArgs.length);
        }
        if (this.mStartChildZygote) {
            boolean seenChildSocketArg = false;
            for (String arg : this.mRemainingArgs) {
                if (!arg.startsWith("--zygote-socket=")) continue;
                seenChildSocketArg = true;
                break;
            }
            if (!seenChildSocketArg) {
                throw new IllegalArgumentException("--start-child-zygote specified without --zygote-socket=");
            }
        }
    }

    private static String getAssignmentValue(String arg) {
        return arg.substring(arg.indexOf(61) + 1);
    }

    private static String[] getAssignmentList(String arg) {
        return ZygoteArguments.getAssignmentValue(arg).split(",");
    }
}

