/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.telephony.SubscriptionInfo;
import com.android.internal.telephony.ISetOpportunisticDataCallback;
import java.util.ArrayList;
import java.util.List;

public interface ISub
extends IInterface {
    public List<SubscriptionInfo> getAllSubInfoList(String var1, String var2) throws RemoteException;

    public int getAllSubInfoCount(String var1, String var2) throws RemoteException;

    public SubscriptionInfo getActiveSubscriptionInfo(int var1, String var2, String var3) throws RemoteException;

    public SubscriptionInfo getActiveSubscriptionInfoForIccId(String var1, String var2, String var3) throws RemoteException;

    public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int var1, String var2, String var3) throws RemoteException;

    public List<SubscriptionInfo> getActiveSubscriptionInfoList(String var1, String var2) throws RemoteException;

    public int getActiveSubInfoCount(String var1, String var2) throws RemoteException;

    public int getActiveSubInfoCountMax() throws RemoteException;

    public List<SubscriptionInfo> getAvailableSubscriptionInfoList(String var1, String var2) throws RemoteException;

    public List<SubscriptionInfo> getAccessibleSubscriptionInfoList(String var1) throws RemoteException;

    public void requestEmbeddedSubscriptionInfoListRefresh(int var1) throws RemoteException;

    public int addSubInfoRecord(String var1, int var2) throws RemoteException;

    public int addSubInfo(String var1, String var2, int var3, int var4) throws RemoteException;

    public int removeSubInfo(String var1, int var2) throws RemoteException;

    public int setIconTint(int var1, int var2) throws RemoteException;

    public int setDisplayNameUsingSrc(String var1, int var2, int var3) throws RemoteException;

    public int setDisplayNumber(String var1, int var2) throws RemoteException;

    public int setDataRoaming(int var1, int var2) throws RemoteException;

    public int setOpportunistic(boolean var1, int var2, String var3) throws RemoteException;

    public ParcelUuid createSubscriptionGroup(int[] var1, String var2) throws RemoteException;

    public void setPreferredDataSubscriptionId(int var1, boolean var2, ISetOpportunisticDataCallback var3) throws RemoteException;

    public int getPreferredDataSubscriptionId() throws RemoteException;

    public List<SubscriptionInfo> getOpportunisticSubscriptions(String var1, String var2) throws RemoteException;

    public void removeSubscriptionsFromGroup(int[] var1, ParcelUuid var2, String var3) throws RemoteException;

    public void addSubscriptionsIntoGroup(int[] var1, ParcelUuid var2, String var3) throws RemoteException;

    public List<SubscriptionInfo> getSubscriptionsInGroup(ParcelUuid var1, String var2, String var3) throws RemoteException;

    public int getSlotIndex(int var1) throws RemoteException;

    public int[] getSubId(int var1) throws RemoteException;

    public int getDefaultSubId() throws RemoteException;

    public int clearSubInfo() throws RemoteException;

    public int getPhoneId(int var1) throws RemoteException;

    public int getDefaultDataSubId() throws RemoteException;

    public void setDefaultDataSubId(int var1) throws RemoteException;

    public int getDefaultVoiceSubId() throws RemoteException;

    public void setDefaultVoiceSubId(int var1) throws RemoteException;

    public int getDefaultSmsSubId() throws RemoteException;

    public void setDefaultSmsSubId(int var1) throws RemoteException;

    public int[] getActiveSubIdList(boolean var1) throws RemoteException;

    public int setSubscriptionProperty(int var1, String var2, String var3) throws RemoteException;

    public String getSubscriptionProperty(int var1, String var2, String var3, String var4) throws RemoteException;

    public boolean setSubscriptionEnabled(boolean var1, int var2) throws RemoteException;

    public boolean isSubscriptionEnabled(int var1) throws RemoteException;

    public int getEnabledSubscriptionId(int var1) throws RemoteException;

    public int getSimStateForSlotIndex(int var1) throws RemoteException;

    public boolean isActiveSubId(int var1, String var2, String var3) throws RemoteException;

    public int getActiveDataSubscriptionId() throws RemoteException;

    public boolean canDisablePhysicalSubscription() throws RemoteException;

    public int setUiccApplicationsEnabled(boolean var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISub {
        private static final String DESCRIPTOR = "com.android.internal.telephony.ISub";
        static final int TRANSACTION_getAllSubInfoList = 1;
        static final int TRANSACTION_getAllSubInfoCount = 2;
        static final int TRANSACTION_getActiveSubscriptionInfo = 3;
        static final int TRANSACTION_getActiveSubscriptionInfoForIccId = 4;
        static final int TRANSACTION_getActiveSubscriptionInfoForSimSlotIndex = 5;
        static final int TRANSACTION_getActiveSubscriptionInfoList = 6;
        static final int TRANSACTION_getActiveSubInfoCount = 7;
        static final int TRANSACTION_getActiveSubInfoCountMax = 8;
        static final int TRANSACTION_getAvailableSubscriptionInfoList = 9;
        static final int TRANSACTION_getAccessibleSubscriptionInfoList = 10;
        static final int TRANSACTION_requestEmbeddedSubscriptionInfoListRefresh = 11;
        static final int TRANSACTION_addSubInfoRecord = 12;
        static final int TRANSACTION_addSubInfo = 13;
        static final int TRANSACTION_removeSubInfo = 14;
        static final int TRANSACTION_setIconTint = 15;
        static final int TRANSACTION_setDisplayNameUsingSrc = 16;
        static final int TRANSACTION_setDisplayNumber = 17;
        static final int TRANSACTION_setDataRoaming = 18;
        static final int TRANSACTION_setOpportunistic = 19;
        static final int TRANSACTION_createSubscriptionGroup = 20;
        static final int TRANSACTION_setPreferredDataSubscriptionId = 21;
        static final int TRANSACTION_getPreferredDataSubscriptionId = 22;
        static final int TRANSACTION_getOpportunisticSubscriptions = 23;
        static final int TRANSACTION_removeSubscriptionsFromGroup = 24;
        static final int TRANSACTION_addSubscriptionsIntoGroup = 25;
        static final int TRANSACTION_getSubscriptionsInGroup = 26;
        static final int TRANSACTION_getSlotIndex = 27;
        static final int TRANSACTION_getSubId = 28;
        static final int TRANSACTION_getDefaultSubId = 29;
        static final int TRANSACTION_clearSubInfo = 30;
        static final int TRANSACTION_getPhoneId = 31;
        static final int TRANSACTION_getDefaultDataSubId = 32;
        static final int TRANSACTION_setDefaultDataSubId = 33;
        static final int TRANSACTION_getDefaultVoiceSubId = 34;
        static final int TRANSACTION_setDefaultVoiceSubId = 35;
        static final int TRANSACTION_getDefaultSmsSubId = 36;
        static final int TRANSACTION_setDefaultSmsSubId = 37;
        static final int TRANSACTION_getActiveSubIdList = 38;
        static final int TRANSACTION_setSubscriptionProperty = 39;
        static final int TRANSACTION_getSubscriptionProperty = 40;
        static final int TRANSACTION_setSubscriptionEnabled = 41;
        static final int TRANSACTION_isSubscriptionEnabled = 42;
        static final int TRANSACTION_getEnabledSubscriptionId = 43;
        static final int TRANSACTION_getSimStateForSlotIndex = 44;
        static final int TRANSACTION_isActiveSubId = 45;
        static final int TRANSACTION_getActiveDataSubscriptionId = 46;
        static final int TRANSACTION_canDisablePhysicalSubscription = 47;
        static final int TRANSACTION_setUiccApplicationsEnabled = 48;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISub asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISub) {
                return (ISub)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getAllSubInfoList";
                }
                case 2: {
                    return "getAllSubInfoCount";
                }
                case 3: {
                    return "getActiveSubscriptionInfo";
                }
                case 4: {
                    return "getActiveSubscriptionInfoForIccId";
                }
                case 5: {
                    return "getActiveSubscriptionInfoForSimSlotIndex";
                }
                case 6: {
                    return "getActiveSubscriptionInfoList";
                }
                case 7: {
                    return "getActiveSubInfoCount";
                }
                case 8: {
                    return "getActiveSubInfoCountMax";
                }
                case 9: {
                    return "getAvailableSubscriptionInfoList";
                }
                case 10: {
                    return "getAccessibleSubscriptionInfoList";
                }
                case 11: {
                    return "requestEmbeddedSubscriptionInfoListRefresh";
                }
                case 12: {
                    return "addSubInfoRecord";
                }
                case 13: {
                    return "addSubInfo";
                }
                case 14: {
                    return "removeSubInfo";
                }
                case 15: {
                    return "setIconTint";
                }
                case 16: {
                    return "setDisplayNameUsingSrc";
                }
                case 17: {
                    return "setDisplayNumber";
                }
                case 18: {
                    return "setDataRoaming";
                }
                case 19: {
                    return "setOpportunistic";
                }
                case 20: {
                    return "createSubscriptionGroup";
                }
                case 21: {
                    return "setPreferredDataSubscriptionId";
                }
                case 22: {
                    return "getPreferredDataSubscriptionId";
                }
                case 23: {
                    return "getOpportunisticSubscriptions";
                }
                case 24: {
                    return "removeSubscriptionsFromGroup";
                }
                case 25: {
                    return "addSubscriptionsIntoGroup";
                }
                case 26: {
                    return "getSubscriptionsInGroup";
                }
                case 27: {
                    return "getSlotIndex";
                }
                case 28: {
                    return "getSubId";
                }
                case 29: {
                    return "getDefaultSubId";
                }
                case 30: {
                    return "clearSubInfo";
                }
                case 31: {
                    return "getPhoneId";
                }
                case 32: {
                    return "getDefaultDataSubId";
                }
                case 33: {
                    return "setDefaultDataSubId";
                }
                case 34: {
                    return "getDefaultVoiceSubId";
                }
                case 35: {
                    return "setDefaultVoiceSubId";
                }
                case 36: {
                    return "getDefaultSmsSubId";
                }
                case 37: {
                    return "setDefaultSmsSubId";
                }
                case 38: {
                    return "getActiveSubIdList";
                }
                case 39: {
                    return "setSubscriptionProperty";
                }
                case 40: {
                    return "getSubscriptionProperty";
                }
                case 41: {
                    return "setSubscriptionEnabled";
                }
                case 42: {
                    return "isSubscriptionEnabled";
                }
                case 43: {
                    return "getEnabledSubscriptionId";
                }
                case 44: {
                    return "getSimStateForSlotIndex";
                }
                case 45: {
                    return "isActiveSubId";
                }
                case 46: {
                    return "getActiveDataSubscriptionId";
                }
                case 47: {
                    return "canDisablePhysicalSubscription";
                }
                case 48: {
                    return "setUiccApplicationsEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    List<SubscriptionInfo> _result = this.getAllSubInfoList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _result = this.getAllSubInfoCount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    SubscriptionInfo _result = this.getActiveSubscriptionInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    SubscriptionInfo _result = this.getActiveSubscriptionInfoForIccId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    SubscriptionInfo _result = this.getActiveSubscriptionInfoForSimSlotIndex(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    List<SubscriptionInfo> _result = this.getActiveSubscriptionInfoList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _result = this.getActiveSubInfoCount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _result = this.getActiveSubInfoCountMax();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    List<SubscriptionInfo> _result = this.getAvailableSubscriptionInfoList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List<SubscriptionInfo> _result = this.getAccessibleSubscriptionInfoList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.requestEmbeddedSubscriptionInfoListRefresh(_arg0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _result = this.addSubInfoRecord(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _result = this.addSubInfo(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _result = this.removeSubInfo(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _result = this.setIconTint(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _result = this.setDisplayNameUsingSrc(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _result = this.setDisplayNumber(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _result = this.setDataRoaming(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _result = this.setOpportunistic(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    String _arg1 = data.readString();
                    ParcelUuid _result = this.createSubscriptionGroup(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    ISetOpportunisticDataCallback _arg2 = ISetOpportunisticDataCallback.Stub.asInterface(data.readStrongBinder());
                    this.setPreferredDataSubscriptionId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    int _result = this.getPreferredDataSubscriptionId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    List<SubscriptionInfo> _result = this.getOpportunisticSubscriptions(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    ParcelUuid _arg1 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    this.removeSubscriptionsFromGroup(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    ParcelUuid _arg1 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    this.addSubscriptionsIntoGroup(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    ParcelUuid _arg0 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    List<SubscriptionInfo> _result = this.getSubscriptionsInGroup(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getSlotIndex(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int[] _result = this.getSubId(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    int _result = this.getDefaultSubId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    int _result = this.clearSubInfo();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getPhoneId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    int _result = this.getDefaultDataSubId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setDefaultDataSubId(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    int _result = this.getDefaultVoiceSubId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setDefaultVoiceSubId(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    int _result = this.getDefaultSmsSubId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setDefaultSmsSubId(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int[] _result = this.getActiveSubIdList(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _result = this.setSubscriptionProperty(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    String _result = this.getSubscriptionProperty(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int _arg1 = data.readInt();
                    boolean _result = this.setSubscriptionEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isSubscriptionEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getEnabledSubscriptionId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getSimStateForSlotIndex(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    boolean _result = this.isActiveSubId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    int _result = this.getActiveDataSubscriptionId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.canDisablePhysicalSubscription();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int _arg1 = data.readInt();
                    int _result = this.setUiccApplicationsEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ISub impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISub getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISub {
            private IBinder mRemote;
            public static ISub sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getAllSubInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<SubscriptionInfo> list = Stub.getDefaultImpl().getAllSubInfoList(callingPackage, callingFeatureId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAllSubInfoCount(String callingPackage, String callingFeatureId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getAllSubInfoCount(callingPackage, callingFeatureId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubscriptionInfo getActiveSubscriptionInfo(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
                SubscriptionInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        SubscriptionInfo subscriptionInfo = Stub.getDefaultImpl().getActiveSubscriptionInfo(subId, callingPackage, callingFeatureId);
                        return subscriptionInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? SubscriptionInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubscriptionInfo getActiveSubscriptionInfoForIccId(String iccId, String callingPackage, String callingFeatureId) throws RemoteException {
                SubscriptionInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iccId);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        SubscriptionInfo subscriptionInfo = Stub.getDefaultImpl().getActiveSubscriptionInfoForIccId(iccId, callingPackage, callingFeatureId);
                        return subscriptionInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? SubscriptionInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIndex, String callingPackage, String callingFeatureId) throws RemoteException {
                SubscriptionInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotIndex);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        SubscriptionInfo subscriptionInfo = Stub.getDefaultImpl().getActiveSubscriptionInfoForSimSlotIndex(slotIndex, callingPackage, callingFeatureId);
                        return subscriptionInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? SubscriptionInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getActiveSubscriptionInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<SubscriptionInfo> list = Stub.getDefaultImpl().getActiveSubscriptionInfoList(callingPackage, callingFeatureId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActiveSubInfoCount(String callingPackage, String callingFeatureId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getActiveSubInfoCount(callingPackage, callingFeatureId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActiveSubInfoCountMax() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getActiveSubInfoCountMax();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getAvailableSubscriptionInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<SubscriptionInfo> list = Stub.getDefaultImpl().getAvailableSubscriptionInfoList(callingPackage, callingFeatureId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getAccessibleSubscriptionInfoList(String callingPackage) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<SubscriptionInfo> list = Stub.getDefaultImpl().getAccessibleSubscriptionInfoList(callingPackage);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestEmbeddedSubscriptionInfoListRefresh(int cardId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(cardId);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestEmbeddedSubscriptionInfoListRefresh(cardId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addSubInfoRecord(String iccId, int slotIndex) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iccId);
                    _data.writeInt(slotIndex);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().addSubInfoRecord(iccId, slotIndex);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addSubInfo(String uniqueId, String displayName, int slotIndex, int subscriptionType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uniqueId);
                    _data.writeString(displayName);
                    _data.writeInt(slotIndex);
                    _data.writeInt(subscriptionType);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().addSubInfo(uniqueId, displayName, slotIndex, subscriptionType);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeSubInfo(String uniqueId, int subscriptionType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uniqueId);
                    _data.writeInt(subscriptionType);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().removeSubInfo(uniqueId, subscriptionType);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setIconTint(int tint, int subId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(tint);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setIconTint(tint, subId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDisplayNameUsingSrc(String displayName, int subId, int nameSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(displayName);
                    _data.writeInt(subId);
                    _data.writeInt(nameSource);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setDisplayNameUsingSrc(displayName, subId, nameSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDisplayNumber(String number, int subId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(number);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setDisplayNumber(number, subId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDataRoaming(int roaming, int subId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(roaming);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setDataRoaming(roaming, subId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setOpportunistic(boolean opportunistic, int subId, String callingPackage) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(opportunistic ? 1 : 0);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setOpportunistic(opportunistic, subId, callingPackage);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelUuid createSubscriptionGroup(int[] subIdList, String callingPackage) throws RemoteException {
                ParcelUuid _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(subIdList);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParcelUuid parcelUuid = Stub.getDefaultImpl().createSubscriptionGroup(subIdList, callingPackage);
                        return parcelUuid;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ParcelUuid.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPreferredDataSubscriptionId(int subId, boolean needValidation, ISetOpportunisticDataCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeInt(needValidation ? 1 : 0);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPreferredDataSubscriptionId(subId, needValidation, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPreferredDataSubscriptionId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getPreferredDataSubscriptionId();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getOpportunisticSubscriptions(String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<SubscriptionInfo> list = Stub.getDefaultImpl().getOpportunisticSubscriptions(callingPackage, callingFeatureId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSubscriptionsFromGroup(int[] subIdList, ParcelUuid groupUuid, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(subIdList);
                    if (groupUuid != null) {
                        _data.writeInt(1);
                        groupUuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeSubscriptionsFromGroup(subIdList, groupUuid, callingPackage);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSubscriptionsIntoGroup(int[] subIdList, ParcelUuid groupUuid, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(subIdList);
                    if (groupUuid != null) {
                        _data.writeInt(1);
                        groupUuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addSubscriptionsIntoGroup(subIdList, groupUuid, callingPackage);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getSubscriptionsInGroup(ParcelUuid groupUuid, String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (groupUuid != null) {
                        _data.writeInt(1);
                        groupUuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<SubscriptionInfo> list = Stub.getDefaultImpl().getSubscriptionsInGroup(groupUuid, callingPackage, callingFeatureId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSlotIndex(int subId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getSlotIndex(subId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getSubId(int slotIndex) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotIndex);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int[] nArray = Stub.getDefaultImpl().getSubId(slotIndex);
                        return nArray;
                    }
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultSubId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getDefaultSubId();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int clearSubInfo() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().clearSubInfo();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPhoneId(int subId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getPhoneId(subId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultDataSubId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getDefaultDataSubId();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultDataSubId(int subId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDefaultDataSubId(subId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultVoiceSubId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getDefaultVoiceSubId();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultVoiceSubId(int subId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDefaultVoiceSubId(subId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultSmsSubId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getDefaultSmsSubId();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultSmsSubId(int subId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDefaultSmsSubId(subId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getActiveSubIdList(boolean visibleOnly) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(visibleOnly ? 1 : 0);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int[] nArray = Stub.getDefaultImpl().getActiveSubIdList(visibleOnly);
                        return nArray;
                    }
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setSubscriptionProperty(int subId, String propKey, String propValue) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(propKey);
                    _data.writeString(propValue);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setSubscriptionProperty(subId, propKey, propValue);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSubscriptionProperty(int subId, String propKey, String callingPackage, String callingFeatureId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(propKey);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getSubscriptionProperty(subId, propKey, callingPackage, callingFeatureId);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSubscriptionEnabled(boolean enable, int subId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setSubscriptionEnabled(enable, subId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSubscriptionEnabled(int subId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isSubscriptionEnabled(subId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getEnabledSubscriptionId(int slotIndex) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotIndex);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getEnabledSubscriptionId(slotIndex);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSimStateForSlotIndex(int slotIndex) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotIndex);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getSimStateForSlotIndex(slotIndex);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isActiveSubId(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isActiveSubId(subId, callingPackage, callingFeatureId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActiveDataSubscriptionId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getActiveDataSubscriptionId();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canDisablePhysicalSubscription() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().canDisablePhysicalSubscription();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setUiccApplicationsEnabled(boolean enabled, int subscriptionId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    _data.writeInt(subscriptionId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setUiccApplicationsEnabled(enabled, subscriptionId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISub {
        @Override
        public List<SubscriptionInfo> getAllSubInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public int getAllSubInfoCount(String callingPackage, String callingFeatureId) throws RemoteException {
            return 0;
        }

        @Override
        public SubscriptionInfo getActiveSubscriptionInfo(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public SubscriptionInfo getActiveSubscriptionInfoForIccId(String iccId, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIndex, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public List<SubscriptionInfo> getActiveSubscriptionInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public int getActiveSubInfoCount(String callingPackage, String callingFeatureId) throws RemoteException {
            return 0;
        }

        @Override
        public int getActiveSubInfoCountMax() throws RemoteException {
            return 0;
        }

        @Override
        public List<SubscriptionInfo> getAvailableSubscriptionInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public List<SubscriptionInfo> getAccessibleSubscriptionInfoList(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void requestEmbeddedSubscriptionInfoListRefresh(int cardId) throws RemoteException {
        }

        @Override
        public int addSubInfoRecord(String iccId, int slotIndex) throws RemoteException {
            return 0;
        }

        @Override
        public int addSubInfo(String uniqueId, String displayName, int slotIndex, int subscriptionType) throws RemoteException {
            return 0;
        }

        @Override
        public int removeSubInfo(String uniqueId, int subscriptionType) throws RemoteException {
            return 0;
        }

        @Override
        public int setIconTint(int tint, int subId) throws RemoteException {
            return 0;
        }

        @Override
        public int setDisplayNameUsingSrc(String displayName, int subId, int nameSource) throws RemoteException {
            return 0;
        }

        @Override
        public int setDisplayNumber(String number, int subId) throws RemoteException {
            return 0;
        }

        @Override
        public int setDataRoaming(int roaming, int subId) throws RemoteException {
            return 0;
        }

        @Override
        public int setOpportunistic(boolean opportunistic, int subId, String callingPackage) throws RemoteException {
            return 0;
        }

        @Override
        public ParcelUuid createSubscriptionGroup(int[] subIdList, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void setPreferredDataSubscriptionId(int subId, boolean needValidation, ISetOpportunisticDataCallback callback) throws RemoteException {
        }

        @Override
        public int getPreferredDataSubscriptionId() throws RemoteException {
            return 0;
        }

        @Override
        public List<SubscriptionInfo> getOpportunisticSubscriptions(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public void removeSubscriptionsFromGroup(int[] subIdList, ParcelUuid groupUuid, String callingPackage) throws RemoteException {
        }

        @Override
        public void addSubscriptionsIntoGroup(int[] subIdList, ParcelUuid groupUuid, String callingPackage) throws RemoteException {
        }

        @Override
        public List<SubscriptionInfo> getSubscriptionsInGroup(ParcelUuid groupUuid, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public int getSlotIndex(int subId) throws RemoteException {
            return 0;
        }

        @Override
        public int[] getSubId(int slotIndex) throws RemoteException {
            return null;
        }

        @Override
        public int getDefaultSubId() throws RemoteException {
            return 0;
        }

        @Override
        public int clearSubInfo() throws RemoteException {
            return 0;
        }

        @Override
        public int getPhoneId(int subId) throws RemoteException {
            return 0;
        }

        @Override
        public int getDefaultDataSubId() throws RemoteException {
            return 0;
        }

        @Override
        public void setDefaultDataSubId(int subId) throws RemoteException {
        }

        @Override
        public int getDefaultVoiceSubId() throws RemoteException {
            return 0;
        }

        @Override
        public void setDefaultVoiceSubId(int subId) throws RemoteException {
        }

        @Override
        public int getDefaultSmsSubId() throws RemoteException {
            return 0;
        }

        @Override
        public void setDefaultSmsSubId(int subId) throws RemoteException {
        }

        @Override
        public int[] getActiveSubIdList(boolean visibleOnly) throws RemoteException {
            return null;
        }

        @Override
        public int setSubscriptionProperty(int subId, String propKey, String propValue) throws RemoteException {
            return 0;
        }

        @Override
        public String getSubscriptionProperty(int subId, String propKey, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public boolean setSubscriptionEnabled(boolean enable, int subId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isSubscriptionEnabled(int subId) throws RemoteException {
            return false;
        }

        @Override
        public int getEnabledSubscriptionId(int slotIndex) throws RemoteException {
            return 0;
        }

        @Override
        public int getSimStateForSlotIndex(int slotIndex) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isActiveSubId(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
            return false;
        }

        @Override
        public int getActiveDataSubscriptionId() throws RemoteException {
            return 0;
        }

        @Override
        public boolean canDisablePhysicalSubscription() throws RemoteException {
            return false;
        }

        @Override
        public int setUiccApplicationsEnabled(boolean enabled, int subscriptionId) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

