/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.inputmethodservice.AbstractInputMethodService;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionInspector;
import android.view.inputmethod.InputContentInfo;
import com.android.internal.inputmethod.CancellationGroup;
import com.android.internal.inputmethod.ResultCallbacks;
import com.android.internal.view.IInputContext;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;

public class InputConnectionWrapper
implements InputConnection {
    private static final String TAG = "InputConnectionWrapper";
    private static final int MAX_WAIT_TIME_MILLIS = 2000;
    private final IInputContext mIInputContext;
    private final WeakReference<AbstractInputMethodService> mInputMethodService;
    private final int mMissingMethods;
    private final CancellationGroup mCancellationGroup;

    public InputConnectionWrapper(WeakReference<AbstractInputMethodService> inputMethodService, IInputContext inputContext, int missingMethods, CancellationGroup cancellationGroup) {
        this.mInputMethodService = inputMethodService;
        this.mIInputContext = inputContext;
        this.mMissingMethods = missingMethods;
        this.mCancellationGroup = cancellationGroup;
    }

    private static void logInternal(String methodName, boolean timedOut, Object defaultValue) {
        if (timedOut) {
            Log.w(TAG, methodName + " didn't respond in " + 2000 + " msec. Returning default: " + defaultValue);
        } else {
            Log.w(TAG, methodName + " was canceled before complete. Returning default: " + defaultValue);
        }
    }

    private static int getResultOrZero(CancellationGroup.Completable.Int value, String methodName) {
        boolean timedOut = value.await(2000, TimeUnit.MILLISECONDS);
        if (value.hasValue()) {
            return value.getValue();
        }
        InputConnectionWrapper.logInternal(methodName, timedOut, 0);
        return 0;
    }

    private static <T> T getResultOrNull(CancellationGroup.Completable.Values<T> value, String methodName) {
        boolean timedOut = value.await(2000, TimeUnit.MILLISECONDS);
        if (value.hasValue()) {
            return value.getValue();
        }
        InputConnectionWrapper.logInternal(methodName, timedOut, null);
        return null;
    }

    @Override
    public CharSequence getTextAfterCursor(int length, int flags) {
        if (this.mCancellationGroup.isCanceled()) {
            return null;
        }
        CancellationGroup.Completable.CharSequence value = this.mCancellationGroup.createCompletableCharSequence();
        try {
            this.mIInputContext.getTextAfterCursor(length, flags, ResultCallbacks.of(value));
        }
        catch (RemoteException e) {
            return null;
        }
        return InputConnectionWrapper.getResultOrNull(value, "getTextAfterCursor()");
    }

    @Override
    public CharSequence getTextBeforeCursor(int length, int flags) {
        if (this.mCancellationGroup.isCanceled()) {
            return null;
        }
        CancellationGroup.Completable.CharSequence value = this.mCancellationGroup.createCompletableCharSequence();
        try {
            this.mIInputContext.getTextBeforeCursor(length, flags, ResultCallbacks.of(value));
        }
        catch (RemoteException e) {
            return null;
        }
        return InputConnectionWrapper.getResultOrNull(value, "getTextBeforeCursor()");
    }

    @Override
    public CharSequence getSelectedText(int flags) {
        if (this.mCancellationGroup.isCanceled()) {
            return null;
        }
        if (this.isMethodMissing(1)) {
            return null;
        }
        CancellationGroup.Completable.CharSequence value = this.mCancellationGroup.createCompletableCharSequence();
        try {
            this.mIInputContext.getSelectedText(flags, ResultCallbacks.of(value));
        }
        catch (RemoteException e) {
            return null;
        }
        return InputConnectionWrapper.getResultOrNull(value, "getSelectedText()");
    }

    @Override
    public int getCursorCapsMode(int reqModes) {
        if (this.mCancellationGroup.isCanceled()) {
            return 0;
        }
        CancellationGroup.Completable.Int value = this.mCancellationGroup.createCompletableInt();
        try {
            this.mIInputContext.getCursorCapsMode(reqModes, ResultCallbacks.of(value));
        }
        catch (RemoteException e) {
            return 0;
        }
        return InputConnectionWrapper.getResultOrZero(value, "getCursorCapsMode()");
    }

    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        if (this.mCancellationGroup.isCanceled()) {
            return null;
        }
        CancellationGroup.Completable.ExtractedText value = this.mCancellationGroup.createCompletableExtractedText();
        try {
            this.mIInputContext.getExtractedText(request, flags, ResultCallbacks.of(value));
        }
        catch (RemoteException e) {
            return null;
        }
        return InputConnectionWrapper.getResultOrNull(value, "getExtractedText()");
    }

    @Override
    public boolean commitText(CharSequence text, int newCursorPosition) {
        try {
            this.mIInputContext.commitText(text, newCursorPosition);
            this.notifyUserActionIfNecessary();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private void notifyUserActionIfNecessary() {
        AbstractInputMethodService inputMethodService = (AbstractInputMethodService)this.mInputMethodService.get();
        if (inputMethodService == null) {
            return;
        }
        inputMethodService.notifyUserActionIfNecessary();
    }

    @Override
    public boolean commitCompletion(CompletionInfo text) {
        if (this.isMethodMissing(4)) {
            return false;
        }
        try {
            this.mIInputContext.commitCompletion(text);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        try {
            this.mIInputContext.commitCorrection(correctionInfo);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean setSelection(int start, int end) {
        try {
            this.mIInputContext.setSelection(start, end);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean performEditorAction(int actionCode) {
        try {
            this.mIInputContext.performEditorAction(actionCode);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean performContextMenuAction(int id2) {
        try {
            this.mIInputContext.performContextMenuAction(id2);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean setComposingRegion(int start, int end) {
        if (this.isMethodMissing(2)) {
            return false;
        }
        try {
            this.mIInputContext.setComposingRegion(start, end);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        try {
            this.mIInputContext.setComposingText(text, newCursorPosition);
            this.notifyUserActionIfNecessary();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean finishComposingText() {
        try {
            this.mIInputContext.finishComposingText();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean beginBatchEdit() {
        try {
            this.mIInputContext.beginBatchEdit();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean endBatchEdit() {
        try {
            this.mIInputContext.endBatchEdit();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean sendKeyEvent(KeyEvent event) {
        try {
            this.mIInputContext.sendKeyEvent(event);
            this.notifyUserActionIfNecessary();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean clearMetaKeyStates(int states) {
        try {
            this.mIInputContext.clearMetaKeyStates(states);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        try {
            this.mIInputContext.deleteSurroundingText(beforeLength, afterLength);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        if (this.isMethodMissing(16)) {
            return false;
        }
        try {
            this.mIInputContext.deleteSurroundingTextInCodePoints(beforeLength, afterLength);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean reportFullscreenMode(boolean enabled) {
        return false;
    }

    @Override
    public boolean performPrivateCommand(String action, Bundle data) {
        try {
            this.mIInputContext.performPrivateCommand(action, data);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean requestCursorUpdates(int cursorUpdateMode) {
        if (this.mCancellationGroup.isCanceled()) {
            return false;
        }
        if (this.isMethodMissing(8)) {
            return false;
        }
        CancellationGroup.Completable.Int value = this.mCancellationGroup.createCompletableInt();
        try {
            this.mIInputContext.requestUpdateCursorAnchorInfo(cursorUpdateMode, ResultCallbacks.of(value));
        }
        catch (RemoteException e) {
            return false;
        }
        return InputConnectionWrapper.getResultOrZero(value, "requestUpdateCursorAnchorInfo()") != 0;
    }

    @Override
    public Handler getHandler() {
        return null;
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public boolean commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts) {
        if (this.mCancellationGroup.isCanceled()) {
            return false;
        }
        if (this.isMethodMissing(128)) {
            return false;
        }
        if ((flags & 1) != 0) {
            AbstractInputMethodService inputMethodService = (AbstractInputMethodService)this.mInputMethodService.get();
            if (inputMethodService == null) {
                return false;
            }
            inputMethodService.exposeContent(inputContentInfo, this);
        }
        CancellationGroup.Completable.Int value = this.mCancellationGroup.createCompletableInt();
        try {
            this.mIInputContext.commitContent(inputContentInfo, flags, opts, ResultCallbacks.of(value));
        }
        catch (RemoteException e) {
            return false;
        }
        return InputConnectionWrapper.getResultOrZero(value, "commitContent()") != 0;
    }

    private boolean isMethodMissing(int methodFlag) {
        return (this.mMissingMethods & methodFlag) == methodFlag;
    }

    public String toString() {
        return "InputConnectionWrapper{idHash=#" + Integer.toHexString(System.identityHashCode(this)) + " mMissingMethods=" + InputConnectionInspector.getMissingMethodFlagsAsString(this.mMissingMethods) + "}";
    }
}

