/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.os.AsyncTask;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockscreenCredential;

public class LockPatternChecker {
    public static AsyncTask<?, ?, ?> verifyCredential(final LockPatternUtils utils, LockscreenCredential credential, final long challenge, final int userId, final OnVerifyCallback callback) {
        final LockscreenCredential credentialCopy = credential.duplicate();
        AsyncTask<Void, Void, byte[]> task = new AsyncTask<Void, Void, byte[]>(){
            private int mThrottleTimeout;

            protected byte[] doInBackground(Void ... args) {
                try {
                    return utils.verifyCredential(credentialCopy, challenge, userId);
                }
                catch (LockPatternUtils.RequestThrottledException ex) {
                    this.mThrottleTimeout = ex.getTimeoutMs();
                    return null;
                }
            }

            @Override
            protected void onPostExecute(byte[] result) {
                callback.onVerified(result, this.mThrottleTimeout);
                credentialCopy.zeroize();
            }

            @Override
            protected void onCancelled() {
                credentialCopy.zeroize();
            }
        };
        task.execute(new Void[0]);
        return task;
    }

    public static AsyncTask<?, ?, ?> checkCredential(final LockPatternUtils utils, LockscreenCredential credential, final int userId, final OnCheckCallback callback) {
        final LockscreenCredential credentialCopy = credential.duplicate();
        AsyncTask<Void, Void, Boolean> task = new AsyncTask<Void, Void, Boolean>(){
            private int mThrottleTimeout;

            protected Boolean doInBackground(Void ... args) {
                try {
                    return utils.checkCredential(credentialCopy, userId, callback::onEarlyMatched);
                }
                catch (LockPatternUtils.RequestThrottledException ex) {
                    this.mThrottleTimeout = ex.getTimeoutMs();
                    return false;
                }
            }

            @Override
            protected void onPostExecute(Boolean result) {
                callback.onChecked(result, this.mThrottleTimeout);
                credentialCopy.zeroize();
            }

            @Override
            protected void onCancelled() {
                callback.onCancelled();
                credentialCopy.zeroize();
            }
        };
        task.execute(new Void[0]);
        return task;
    }

    public static AsyncTask<?, ?, ?> verifyTiedProfileChallenge(final LockPatternUtils utils, LockscreenCredential credential, final long challenge, final int userId, final OnVerifyCallback callback) {
        final LockscreenCredential credentialCopy = credential.duplicate();
        AsyncTask<Void, Void, byte[]> task = new AsyncTask<Void, Void, byte[]>(){
            private int mThrottleTimeout;

            protected byte[] doInBackground(Void ... args) {
                try {
                    return utils.verifyTiedProfileChallenge(credentialCopy, challenge, userId);
                }
                catch (LockPatternUtils.RequestThrottledException ex) {
                    this.mThrottleTimeout = ex.getTimeoutMs();
                    return null;
                }
            }

            @Override
            protected void onPostExecute(byte[] result) {
                callback.onVerified(result, this.mThrottleTimeout);
                credentialCopy.zeroize();
            }

            @Override
            protected void onCancelled() {
                credentialCopy.zeroize();
            }
        };
        task.execute(new Void[0]);
        return task;
    }

    public static interface OnVerifyCallback {
        public void onVerified(byte[] var1, int var2);
    }

    public static interface OnCheckCallback {
        default public void onEarlyMatched() {
        }

        public void onChecked(boolean var1, int var2);

        default public void onCancelled() {
        }
    }
}

