/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class NotificationExpandButton
extends ImageView {
    private int mOriginalNotificationColor;

    public NotificationExpandButton(Context context) {
        super(context);
    }

    public NotificationExpandButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public NotificationExpandButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public NotificationExpandButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void getBoundsOnScreen(Rect outRect, boolean clipToParent) {
        super.getBoundsOnScreen(outRect, clipToParent);
        this.extendRectToMinTouchSize(outRect);
    }

    @RemotableViewMethod
    public void setOriginalNotificationColor(int color2) {
        this.mOriginalNotificationColor = color2;
    }

    public int getOriginalNotificationColor() {
        return this.mOriginalNotificationColor;
    }

    private void extendRectToMinTouchSize(Rect rect) {
        int touchTargetSize = (int)(this.getResources().getDisplayMetrics().density * 48.0f);
        rect.left = rect.centerX() - touchTargetSize / 2;
        rect.right = rect.left + touchTargetSize;
        rect.top = rect.centerY() - touchTargetSize / 2;
        rect.bottom = rect.top + touchTargetSize;
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(Button.class.getName());
    }
}

