/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import android.os.SystemClock_Delegate;
import android.view.Choreographer;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.utils.Pair;
import java.util.ArrayList;

public class ChoreographerCallbacks {
    private final RangeList<Pair<Object, Long>> mCallbacks = new RangeList();

    public void add(Object action, long delayMillis) {
        int idx;
        long now = SystemClock_Delegate.uptimeMillis();
        long dueTime = now + delayMillis;
        for (idx = 0; idx < this.mCallbacks.size() && (Long)((Pair)this.mCallbacks.get(idx)).getSecond() <= dueTime; ++idx) {
        }
        this.mCallbacks.add(idx, Pair.of((Object)action, (Object)dueTime));
    }

    public void remove(Object action) {
        this.mCallbacks.removeIf(el -> el.getFirst() == action);
    }

    public void execute(long currentTimeMs, ILayoutLog logger) {
        int idx;
        long currentTimeNanos = currentTimeMs * 1000000L;
        for (idx = 0; idx < this.mCallbacks.size() && (Long)((Pair)this.mCallbacks.get(idx)).getSecond() <= currentTimeMs; ++idx) {
        }
        ArrayList toExecute = new ArrayList(this.mCallbacks.subList(0, idx));
        ((RangeList)this.mCallbacks).removeFrontElements(idx);
        toExecute.forEach(p -> ChoreographerCallbacks.executeSafely(p.getFirst(), currentTimeNanos, logger));
    }

    public void clear() {
        this.mCallbacks.clear();
    }

    private static void executeSafely(Object action, long frameTimeNanos, ILayoutLog logger) {
        try {
            if (action instanceof Choreographer.FrameCallback) {
                Choreographer.FrameCallback callback = (Choreographer.FrameCallback)action;
                callback.doFrame(frameTimeNanos);
            } else if (action instanceof Runnable) {
                Runnable runnable = (Runnable)action;
                runnable.run();
            } else {
                logger.error("broken", "Unexpected action as Choreographer callback", null, null);
            }
        }
        catch (Throwable t) {
            logger.error("broken", "Failed executing Choreographer callback", t, null, null);
        }
    }

    private static class RangeList<T>
    extends ArrayList<T> {
        private RangeList() {
        }

        private void removeFrontElements(int n) {
            this.removeRange(0, n);
        }
    }
}

