/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.validator;

import android.view.View;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.idea.validator.ValidatorHierarchy;
import com.android.tools.idea.validator.ValidatorResult;
import com.android.tools.idea.validator.ValidatorUtil;
import java.awt.image.BufferedImage;
import java.util.EnumSet;

public class LayoutValidator {
    public static final ValidatorData.Policy DEFAULT_POLICY;
    private static ValidatorData.Policy sPolicy;

    public static ValidatorResult validate(View view, BufferedImage image) {
        if (view.isAttachedToWindow()) {
            ValidatorHierarchy hierarchy = ValidatorUtil.buildHierarchy(sPolicy, view, image);
            return ValidatorUtil.generateResults(sPolicy, hierarchy);
        }
        return new ValidatorResult.Builder().build();
    }

    public static ValidatorHierarchy buildHierarchy(View view, BufferedImage image) {
        if (view.isAttachedToWindow()) {
            return ValidatorUtil.buildHierarchy(sPolicy, view, image);
        }
        return new ValidatorHierarchy();
    }

    public static ValidatorResult validate(ValidatorHierarchy hierarchy) {
        return ValidatorUtil.generateResults(sPolicy, hierarchy);
    }

    public static void updatePolicy(ValidatorData.Policy policy) {
        sPolicy = policy;
    }

    static {
        sPolicy = DEFAULT_POLICY = new ValidatorData.Policy(EnumSet.of(ValidatorData.Type.ACCESSIBILITY, ValidatorData.Type.RENDER), EnumSet.of(ValidatorData.Level.ERROR, ValidatorData.Level.WARNING, ValidatorData.Level.INFO, ValidatorData.Level.VERBOSE));
    }
}

