/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.validator;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import java.util.EnumSet;
import java.util.HashSet;

public class ValidatorData {

    public static class Issue {
        public final String mCategory;
        public final Type mType;
        public final String mMsg;
        public final Level mLevel;
        public final Long mSrcId;
        public final Fix mFix;
        public final String mSourceClass;
        public final String mHelpfulUrl;

        private Issue(String category, Type type, String msg, Level level, Long srcId, Fix fix, String sourceClass, String helpfulUrl) {
            this.mCategory = category;
            this.mType = type;
            this.mMsg = msg;
            this.mLevel = level;
            this.mSrcId = srcId;
            this.mFix = fix;
            this.mSourceClass = sourceClass;
            this.mHelpfulUrl = helpfulUrl;
        }

        public static class IssueBuilder {
            private String mCategory;
            private Type mType = Type.ACCESSIBILITY;
            private String mMsg;
            private Level mLevel;
            private Long mSrcId;
            private Fix mFix;
            private String mSourceClass;
            private String mHelpfulUrl;

            public IssueBuilder setCategory(String category) {
                this.mCategory = category;
                return this;
            }

            public IssueBuilder setType(Type type) {
                this.mType = type;
                return this;
            }

            public IssueBuilder setMsg(String msg) {
                this.mMsg = msg;
                return this;
            }

            public IssueBuilder setLevel(Level level) {
                this.mLevel = level;
                return this;
            }

            public IssueBuilder setSrcId(Long srcId) {
                this.mSrcId = srcId;
                return this;
            }

            public IssueBuilder setFix(Fix fix) {
                this.mFix = fix;
                return this;
            }

            public IssueBuilder setSourceClass(String sourceClass) {
                this.mSourceClass = sourceClass;
                return this;
            }

            public IssueBuilder setHelpfulUrl(String url) {
                this.mHelpfulUrl = url;
                return this;
            }

            public Issue build() {
                assert (this.mCategory != null);
                assert (this.mType != null);
                assert (this.mMsg != null);
                assert (this.mLevel != null);
                assert (this.mSourceClass != null);
                return new Issue(this.mCategory, this.mType, this.mMsg, this.mLevel, this.mSrcId, this.mFix, this.mSourceClass, this.mHelpfulUrl);
            }
        }
    }

    public static class Fix {
        public final String mFix;

        public Fix(String fix) {
            this.mFix = fix;
        }
    }

    public static class Policy {
        public final EnumSet<Type> mTypes;
        public final EnumSet<Level> mLevels;
        public final HashSet<AccessibilityHierarchyCheck> mChecks = new HashSet();

        public Policy(EnumSet<Type> types, EnumSet<Level> levels) {
            this.mTypes = types;
            this.mLevels = levels;
        }
    }

    public static enum Level {
        ERROR,
        WARNING,
        INFO,
        VERBOSE;

    }

    public static enum Type {
        ACCESSIBILITY,
        RENDER,
        INTERNAL_ERROR;

    }
}

