/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.validator;

import android.view.View;
import com.android.tools.idea.validator.AtfBufferedImage;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.idea.validator.ValidatorHierarchy;
import com.android.tools.idea.validator.ValidatorResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPreset;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchyAndroid;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;

public class ValidatorUtil {
    public static ValidatorHierarchy buildHierarchy(ValidatorData.Policy policy, View view, BufferedImage image) {
        ValidatorHierarchy hierarchy = new ValidatorHierarchy();
        if (!policy.mTypes.contains((Object)ValidatorData.Type.ACCESSIBILITY)) {
            return hierarchy;
        }
        ValidatorResult.Builder builder = new ValidatorResult.Builder();
        Parameters parameters = null;
        builder.mMetric.startTimer();
        hierarchy.mView = AccessibilityHierarchyAndroid.newBuilder(view).setViewOriginMap(builder.mSrcMap).build();
        if (image != null) {
            parameters = new Parameters();
            parameters.putScreenCapture(new AtfBufferedImage(image, builder.mMetric));
        }
        builder.mMetric.recordHierarchyCreationTime();
        hierarchy.mBuilder = builder;
        hierarchy.mParameters = parameters;
        return hierarchy;
    }

    public static ValidatorResult generateResults(ValidatorData.Policy policy, ValidatorHierarchy hierarchy) {
        ValidatorResult.Builder builder = hierarchy.mBuilder;
        if (!hierarchy.isHierarchyBuilt()) {
            builder = new ValidatorResult.Builder();
            String errorMsg = hierarchy.mErrorMessage != null ? hierarchy.mErrorMessage : "Hierarchy is not built yet.";
            builder.mIssues.add(new ValidatorData.Issue.IssueBuilder().setCategory("Accessibility").setType(ValidatorData.Type.INTERNAL_ERROR).setMsg(errorMsg).setLevel(ValidatorData.Level.ERROR).setSourceClass("ValidatorHierarchy").build());
            return builder.build();
        }
        AccessibilityHierarchyAndroid view = hierarchy.mView;
        Parameters parameters = hierarchy.mParameters;
        EnumSet<ValidatorData.Level> filter = policy.mLevels;
        ArrayList<AccessibilityHierarchyCheckResult> a11yResults = new ArrayList<AccessibilityHierarchyCheckResult>();
        HashSet<AccessibilityHierarchyCheck> policyChecks = policy.mChecks;
        HashSet<AccessibilityHierarchyCheck> checks = policyChecks.isEmpty() ? AccessibilityCheckPreset.getAccessibilityHierarchyChecksForPreset(AccessibilityCheckPreset.LATEST) : policyChecks;
        for (AccessibilityHierarchyCheck check : checks) {
            a11yResults.addAll(check.runCheckOnHierarchy(view, null, parameters));
        }
        for (AccessibilityHierarchyCheckResult result : a11yResults) {
            String category = ValidatorUtil.getCheckClassCategory(result.getSourceCheckClass());
            ValidatorData.Level level = ValidatorUtil.convertLevel(result.getType());
            if (!filter.contains((Object)level)) continue;
            try {
                AccessibilityHierarchyCheck subclass;
                ValidatorData.Issue.IssueBuilder issueBuilder = new ValidatorData.Issue.IssueBuilder().setCategory(category).setMsg(result.getMessage(Locale.ENGLISH).toString()).setLevel(level).setFix(ValidatorUtil.generateFix(result)).setSourceClass(result.getSourceCheckClass().getSimpleName());
                if (result.getElement() != null) {
                    issueBuilder.setSrcId(result.getElement().getCondensedUniqueId());
                }
                if ((subclass = AccessibilityCheckPreset.getHierarchyCheckForClass(result.getSourceCheckClass().asSubclass(AccessibilityHierarchyCheck.class))) != null) {
                    issueBuilder.setHelpfulUrl(subclass.getHelpUrl());
                }
                builder.mIssues.add(issueBuilder.build());
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                builder.mIssues.add(new ValidatorData.Issue.IssueBuilder().setCategory(category).setType(ValidatorData.Type.INTERNAL_ERROR).setMsg(sw.toString()).setLevel(ValidatorData.Level.ERROR).setSourceClass("ValidatorHierarchy").build());
            }
        }
        builder.mMetric.endTimer();
        return builder.build();
    }

    private static String getCheckClassCategory(Class<?> checkClass) {
        try {
            Class<AccessibilityHierarchyCheck> subClass = checkClass.asSubclass(AccessibilityHierarchyCheck.class);
            AccessibilityHierarchyCheck check = AccessibilityCheckPreset.getHierarchyCheckForClass(subClass);
            return check == null ? "Accessibility" : check.getCategory().name();
        }
        catch (ClassCastException e) {
            return "Accessibility";
        }
    }

    private static ValidatorData.Level convertLevel(AccessibilityCheckResult.AccessibilityCheckResultType type) {
        switch (type) {
            case ERROR: {
                return ValidatorData.Level.ERROR;
            }
            case WARNING: {
                return ValidatorData.Level.WARNING;
            }
            case INFO: {
                return ValidatorData.Level.INFO;
            }
        }
        return ValidatorData.Level.VERBOSE;
    }

    private static ValidatorData.Fix generateFix(AccessibilityHierarchyCheckResult result) {
        return new ValidatorData.Fix("");
    }

    static {
        StringManager.setResourceBundleProvider(locale -> ResourceBundle.getBundle("strings"));
    }
}

