/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.common.base.Preconditions;
import java.util.Locale;

public class AccessibilityEventCheckResult
extends AccessibilityCheckResult
implements Parcelable {
    private final AccessibilityEvent event;
    public static final Parcelable.Creator<AccessibilityEventCheckResult> CREATOR = new Parcelable.Creator<AccessibilityEventCheckResult>(){

        @Override
        public AccessibilityEventCheckResult createFromParcel(Parcel in) {
            return AccessibilityEventCheckResult.readFromParcel(in);
        }

        public AccessibilityEventCheckResult[] newArray(int size) {
            return new AccessibilityEventCheckResult[size];
        }
    };

    public AccessibilityEventCheckResult(Class<? extends AccessibilityCheck> checkClass, AccessibilityCheckResult.AccessibilityCheckResultType type, CharSequence message, AccessibilityEvent event) {
        super(checkClass, type, message);
        this.event = AccessibilityEvent.obtain(event);
    }

    public AccessibilityEvent getEvent() {
        return this.event;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getSourceCheckClass().getName());
        dest.writeInt(this.getType().ordinal());
        TextUtils.writeToParcel(this.getMessage(Locale.ENGLISH), dest, flags);
        this.event.writeToParcel(dest, flags);
    }

    private static AccessibilityEventCheckResult readFromParcel(Parcel in) {
        Class<?> checkClass;
        String checkClassName = (String)Preconditions.checkNotNull((Object)in.readString());
        try {
            Class<?> uncheckedClass = Class.forName(checkClassName);
            if (uncheckedClass == null || !AccessibilityCheck.class.isAssignableFrom(uncheckedClass)) {
                throw new RuntimeException(String.format("Class: %1$s is not assignable from AccessibilityCheck", checkClassName));
            }
            checkClass = uncheckedClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Failed to resolve check class: %1$s", checkClassName), e);
        }
        int typeInt = in.readInt();
        AccessibilityCheckResult.AccessibilityCheckResultType type = AccessibilityCheckResult.AccessibilityCheckResultType.values()[typeInt];
        CharSequence message = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        AccessibilityEvent event = AccessibilityEvent.CREATOR.createFromParcel(in);
        return new AccessibilityEventCheckResult(checkClass, (AccessibilityCheckResult.AccessibilityCheckResultType)((Object)Preconditions.checkNotNull((Object)((Object)type))), message, event);
    }
}

